/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures conditions under which the processing job should be stopped, such as how long the processing job has been
 * running. After the condition is met, the processing job is stopped.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProcessingStoppingCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<ProcessingStoppingCondition.Builder, ProcessingStoppingCondition> {
    private static final SdkField<Integer> MAX_RUNTIME_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRuntimeInSeconds").getter(getter(ProcessingStoppingCondition::maxRuntimeInSeconds))
            .setter(setter(Builder::maxRuntimeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRuntimeInSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RUNTIME_IN_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxRuntimeInSeconds;

    private ProcessingStoppingCondition(BuilderImpl builder) {
        this.maxRuntimeInSeconds = builder.maxRuntimeInSeconds;
    }

    /**
     * <p>
     * Specifies the maximum runtime in seconds.
     * </p>
     * 
     * @return Specifies the maximum runtime in seconds.
     */
    public final Integer maxRuntimeInSeconds() {
        return maxRuntimeInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxRuntimeInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessingStoppingCondition)) {
            return false;
        }
        ProcessingStoppingCondition other = (ProcessingStoppingCondition) obj;
        return Objects.equals(maxRuntimeInSeconds(), other.maxRuntimeInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProcessingStoppingCondition").add("MaxRuntimeInSeconds", maxRuntimeInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxRuntimeInSeconds":
            return Optional.ofNullable(clazz.cast(maxRuntimeInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProcessingStoppingCondition, T> g) {
        return obj -> g.apply((ProcessingStoppingCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProcessingStoppingCondition> {
        /**
         * <p>
         * Specifies the maximum runtime in seconds.
         * </p>
         * 
         * @param maxRuntimeInSeconds
         *        Specifies the maximum runtime in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRuntimeInSeconds(Integer maxRuntimeInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxRuntimeInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessingStoppingCondition model) {
            maxRuntimeInSeconds(model.maxRuntimeInSeconds);
        }

        public final Integer getMaxRuntimeInSeconds() {
            return maxRuntimeInSeconds;
        }

        public final void setMaxRuntimeInSeconds(Integer maxRuntimeInSeconds) {
            this.maxRuntimeInSeconds = maxRuntimeInSeconds;
        }

        @Override
        @Transient
        public final Builder maxRuntimeInSeconds(Integer maxRuntimeInSeconds) {
            this.maxRuntimeInSeconds = maxRuntimeInSeconds;
            return this;
        }

        @Override
        public ProcessingStoppingCondition build() {
            return new ProcessingStoppingCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
