/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEndpointRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateEndpointRequest.Builder, UpdateEndpointRequest> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(UpdateEndpointRequest::endpointName)).setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<String> ENDPOINT_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointConfigName").getter(getter(UpdateEndpointRequest::endpointConfigName))
            .setter(setter(Builder::endpointConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfigName").build())
            .build();

    private static final SdkField<Boolean> RETAIN_ALL_VARIANT_PROPERTIES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RetainAllVariantProperties")
            .getter(getter(UpdateEndpointRequest::retainAllVariantProperties))
            .setter(setter(Builder::retainAllVariantProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainAllVariantProperties").build())
            .build();

    private static final SdkField<List<VariantProperty>> EXCLUDE_RETAINED_VARIANT_PROPERTIES_FIELD = SdkField
            .<List<VariantProperty>> builder(MarshallingType.LIST)
            .memberName("ExcludeRetainedVariantProperties")
            .getter(getter(UpdateEndpointRequest::excludeRetainedVariantProperties))
            .setter(setter(Builder::excludeRetainedVariantProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeRetainedVariantProperties")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VariantProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(VariantProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DeploymentConfig> DEPLOYMENT_CONFIG_FIELD = SdkField
            .<DeploymentConfig> builder(MarshallingType.SDK_POJO).memberName("DeploymentConfig")
            .getter(getter(UpdateEndpointRequest::deploymentConfig)).setter(setter(Builder::deploymentConfig))
            .constructor(DeploymentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD,
            ENDPOINT_CONFIG_NAME_FIELD, RETAIN_ALL_VARIANT_PROPERTIES_FIELD, EXCLUDE_RETAINED_VARIANT_PROPERTIES_FIELD,
            DEPLOYMENT_CONFIG_FIELD));

    private final String endpointName;

    private final String endpointConfigName;

    private final Boolean retainAllVariantProperties;

    private final List<VariantProperty> excludeRetainedVariantProperties;

    private final DeploymentConfig deploymentConfig;

    private UpdateEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.endpointConfigName = builder.endpointConfigName;
        this.retainAllVariantProperties = builder.retainAllVariantProperties;
        this.excludeRetainedVariantProperties = builder.excludeRetainedVariantProperties;
        this.deploymentConfig = builder.deploymentConfig;
    }

    /**
     * <p>
     * The name of the endpoint whose configuration you want to update.
     * </p>
     * 
     * @return The name of the endpoint whose configuration you want to update.
     */
    public final String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * The name of the new endpoint configuration.
     * </p>
     * 
     * @return The name of the new endpoint configuration.
     */
    public final String endpointConfigName() {
        return endpointConfigName;
    }

    /**
     * <p>
     * When updating endpoint resources, enables or disables the retention of <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VariantProperty.html">variant properties</a>,
     * such as the instance count or the variant weight. To retain the variant properties of an endpoint when updating
     * it, set <code>RetainAllVariantProperties</code> to <code>true</code>. To use the variant properties specified in
     * a new <code>EndpointConfig</code> call when updating an endpoint, set <code>RetainAllVariantProperties</code> to
     * <code>false</code>. The default is <code>false</code>.
     * </p>
     * 
     * @return When updating endpoint resources, enables or disables the retention of <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VariantProperty.html">variant
     *         properties</a>, such as the instance count or the variant weight. To retain the variant properties of an
     *         endpoint when updating it, set <code>RetainAllVariantProperties</code> to <code>true</code>. To use the
     *         variant properties specified in a new <code>EndpointConfig</code> call when updating an endpoint, set
     *         <code>RetainAllVariantProperties</code> to <code>false</code>. The default is <code>false</code>.
     */
    public final Boolean retainAllVariantProperties() {
        return retainAllVariantProperties;
    }

    /**
     * Returns true if the ExcludeRetainedVariantProperties property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasExcludeRetainedVariantProperties() {
        return excludeRetainedVariantProperties != null && !(excludeRetainedVariantProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * When you are updating endpoint resources with <a>UpdateEndpointInput$RetainAllVariantProperties</a>, whose value
     * is set to <code>true</code>, <code>ExcludeRetainedVariantProperties</code> specifies the list of type
     * <a>VariantProperty</a> to override with the values provided by <code>EndpointConfig</code>. If you don't specify
     * a value for <code>ExcludeAllVariantProperties</code>, no variant properties are overridden.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExcludeRetainedVariantProperties()} to see if a value was sent in this field.
     * </p>
     * 
     * @return When you are updating endpoint resources with <a>UpdateEndpointInput$RetainAllVariantProperties</a>,
     *         whose value is set to <code>true</code>, <code>ExcludeRetainedVariantProperties</code> specifies the list
     *         of type <a>VariantProperty</a> to override with the values provided by <code>EndpointConfig</code>. If
     *         you don't specify a value for <code>ExcludeAllVariantProperties</code>, no variant properties are
     *         overridden.
     */
    public final List<VariantProperty> excludeRetainedVariantProperties() {
        return excludeRetainedVariantProperties;
    }

    /**
     * <p>
     * The deployment configuration for the endpoint to be updated.
     * </p>
     * 
     * @return The deployment configuration for the endpoint to be updated.
     */
    public final DeploymentConfig deploymentConfig() {
        return deploymentConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(endpointConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(retainAllVariantProperties());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasExcludeRetainedVariantProperties() ? excludeRetainedVariantProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEndpointRequest)) {
            return false;
        }
        UpdateEndpointRequest other = (UpdateEndpointRequest) obj;
        return Objects.equals(endpointName(), other.endpointName())
                && Objects.equals(endpointConfigName(), other.endpointConfigName())
                && Objects.equals(retainAllVariantProperties(), other.retainAllVariantProperties())
                && hasExcludeRetainedVariantProperties() == other.hasExcludeRetainedVariantProperties()
                && Objects.equals(excludeRetainedVariantProperties(), other.excludeRetainedVariantProperties())
                && Objects.equals(deploymentConfig(), other.deploymentConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateEndpointRequest")
                .add("EndpointName", endpointName())
                .add("EndpointConfigName", endpointConfigName())
                .add("RetainAllVariantProperties", retainAllVariantProperties())
                .add("ExcludeRetainedVariantProperties",
                        hasExcludeRetainedVariantProperties() ? excludeRetainedVariantProperties() : null)
                .add("DeploymentConfig", deploymentConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "EndpointConfigName":
            return Optional.ofNullable(clazz.cast(endpointConfigName()));
        case "RetainAllVariantProperties":
            return Optional.ofNullable(clazz.cast(retainAllVariantProperties()));
        case "ExcludeRetainedVariantProperties":
            return Optional.ofNullable(clazz.cast(excludeRetainedVariantProperties()));
        case "DeploymentConfig":
            return Optional.ofNullable(clazz.cast(deploymentConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEndpointRequest, T> g) {
        return obj -> g.apply((UpdateEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEndpointRequest> {
        /**
         * <p>
         * The name of the endpoint whose configuration you want to update.
         * </p>
         * 
         * @param endpointName
         *        The name of the endpoint whose configuration you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * The name of the new endpoint configuration.
         * </p>
         * 
         * @param endpointConfigName
         *        The name of the new endpoint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfigName(String endpointConfigName);

        /**
         * <p>
         * When updating endpoint resources, enables or disables the retention of <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VariantProperty.html">variant
         * properties</a>, such as the instance count or the variant weight. To retain the variant properties of an
         * endpoint when updating it, set <code>RetainAllVariantProperties</code> to <code>true</code>. To use the
         * variant properties specified in a new <code>EndpointConfig</code> call when updating an endpoint, set
         * <code>RetainAllVariantProperties</code> to <code>false</code>. The default is <code>false</code>.
         * </p>
         * 
         * @param retainAllVariantProperties
         *        When updating endpoint resources, enables or disables the retention of <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VariantProperty.html">variant
         *        properties</a>, such as the instance count or the variant weight. To retain the variant properties of
         *        an endpoint when updating it, set <code>RetainAllVariantProperties</code> to <code>true</code>. To use
         *        the variant properties specified in a new <code>EndpointConfig</code> call when updating an endpoint,
         *        set <code>RetainAllVariantProperties</code> to <code>false</code>. The default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retainAllVariantProperties(Boolean retainAllVariantProperties);

        /**
         * <p>
         * When you are updating endpoint resources with <a>UpdateEndpointInput$RetainAllVariantProperties</a>, whose
         * value is set to <code>true</code>, <code>ExcludeRetainedVariantProperties</code> specifies the list of type
         * <a>VariantProperty</a> to override with the values provided by <code>EndpointConfig</code>. If you don't
         * specify a value for <code>ExcludeAllVariantProperties</code>, no variant properties are overridden.
         * </p>
         * 
         * @param excludeRetainedVariantProperties
         *        When you are updating endpoint resources with <a>UpdateEndpointInput$RetainAllVariantProperties</a>,
         *        whose value is set to <code>true</code>, <code>ExcludeRetainedVariantProperties</code> specifies the
         *        list of type <a>VariantProperty</a> to override with the values provided by
         *        <code>EndpointConfig</code>. If you don't specify a value for <code>ExcludeAllVariantProperties</code>
         *        , no variant properties are overridden.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeRetainedVariantProperties(Collection<VariantProperty> excludeRetainedVariantProperties);

        /**
         * <p>
         * When you are updating endpoint resources with <a>UpdateEndpointInput$RetainAllVariantProperties</a>, whose
         * value is set to <code>true</code>, <code>ExcludeRetainedVariantProperties</code> specifies the list of type
         * <a>VariantProperty</a> to override with the values provided by <code>EndpointConfig</code>. If you don't
         * specify a value for <code>ExcludeAllVariantProperties</code>, no variant properties are overridden.
         * </p>
         * 
         * @param excludeRetainedVariantProperties
         *        When you are updating endpoint resources with <a>UpdateEndpointInput$RetainAllVariantProperties</a>,
         *        whose value is set to <code>true</code>, <code>ExcludeRetainedVariantProperties</code> specifies the
         *        list of type <a>VariantProperty</a> to override with the values provided by
         *        <code>EndpointConfig</code>. If you don't specify a value for <code>ExcludeAllVariantProperties</code>
         *        , no variant properties are overridden.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeRetainedVariantProperties(VariantProperty... excludeRetainedVariantProperties);

        /**
         * <p>
         * When you are updating endpoint resources with <a>UpdateEndpointInput$RetainAllVariantProperties</a>, whose
         * value is set to <code>true</code>, <code>ExcludeRetainedVariantProperties</code> specifies the list of type
         * <a>VariantProperty</a> to override with the values provided by <code>EndpointConfig</code>. If you don't
         * specify a value for <code>ExcludeAllVariantProperties</code>, no variant properties are overridden.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VariantProperty>.Builder} avoiding the need
         * to create one manually via {@link List<VariantProperty>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VariantProperty>.Builder#build()} is called immediately and
         * its result is passed to {@link #excludeRetainedVariantProperties(List<VariantProperty>)}.
         * 
         * @param excludeRetainedVariantProperties
         *        a consumer that will call methods on {@link List<VariantProperty>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excludeRetainedVariantProperties(List<VariantProperty>)
         */
        Builder excludeRetainedVariantProperties(Consumer<VariantProperty.Builder>... excludeRetainedVariantProperties);

        /**
         * <p>
         * The deployment configuration for the endpoint to be updated.
         * </p>
         * 
         * @param deploymentConfig
         *        The deployment configuration for the endpoint to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfig(DeploymentConfig deploymentConfig);

        /**
         * <p>
         * The deployment configuration for the endpoint to be updated.
         * </p>
         * This is a convenience that creates an instance of the {@link DeploymentConfig.Builder} avoiding the need to
         * create one manually via {@link DeploymentConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #deploymentConfig(DeploymentConfig)}.
         * 
         * @param deploymentConfig
         *        a consumer that will call methods on {@link DeploymentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentConfig(DeploymentConfig)
         */
        default Builder deploymentConfig(Consumer<DeploymentConfig.Builder> deploymentConfig) {
            return deploymentConfig(DeploymentConfig.builder().applyMutation(deploymentConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String endpointName;

        private String endpointConfigName;

        private Boolean retainAllVariantProperties;

        private List<VariantProperty> excludeRetainedVariantProperties = DefaultSdkAutoConstructList.getInstance();

        private DeploymentConfig deploymentConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEndpointRequest model) {
            super(model);
            endpointName(model.endpointName);
            endpointConfigName(model.endpointConfigName);
            retainAllVariantProperties(model.retainAllVariantProperties);
            excludeRetainedVariantProperties(model.excludeRetainedVariantProperties);
            deploymentConfig(model.deploymentConfig);
        }

        public final String getEndpointName() {
            return endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        @Transient
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getEndpointConfigName() {
            return endpointConfigName;
        }

        public final void setEndpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
        }

        @Override
        @Transient
        public final Builder endpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
            return this;
        }

        public final Boolean getRetainAllVariantProperties() {
            return retainAllVariantProperties;
        }

        public final void setRetainAllVariantProperties(Boolean retainAllVariantProperties) {
            this.retainAllVariantProperties = retainAllVariantProperties;
        }

        @Override
        @Transient
        public final Builder retainAllVariantProperties(Boolean retainAllVariantProperties) {
            this.retainAllVariantProperties = retainAllVariantProperties;
            return this;
        }

        public final List<VariantProperty.Builder> getExcludeRetainedVariantProperties() {
            List<VariantProperty.Builder> result = VariantPropertyListCopier.copyToBuilder(this.excludeRetainedVariantProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExcludeRetainedVariantProperties(
                Collection<VariantProperty.BuilderImpl> excludeRetainedVariantProperties) {
            this.excludeRetainedVariantProperties = VariantPropertyListCopier.copyFromBuilder(excludeRetainedVariantProperties);
        }

        @Override
        @Transient
        public final Builder excludeRetainedVariantProperties(Collection<VariantProperty> excludeRetainedVariantProperties) {
            this.excludeRetainedVariantProperties = VariantPropertyListCopier.copy(excludeRetainedVariantProperties);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder excludeRetainedVariantProperties(VariantProperty... excludeRetainedVariantProperties) {
            excludeRetainedVariantProperties(Arrays.asList(excludeRetainedVariantProperties));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder excludeRetainedVariantProperties(
                Consumer<VariantProperty.Builder>... excludeRetainedVariantProperties) {
            excludeRetainedVariantProperties(Stream.of(excludeRetainedVariantProperties)
                    .map(c -> VariantProperty.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final DeploymentConfig.Builder getDeploymentConfig() {
            return deploymentConfig != null ? deploymentConfig.toBuilder() : null;
        }

        public final void setDeploymentConfig(DeploymentConfig.BuilderImpl deploymentConfig) {
            this.deploymentConfig = deploymentConfig != null ? deploymentConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder deploymentConfig(DeploymentConfig deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEndpointRequest build() {
            return new UpdateEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
