/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about how and under what conditions SageMaker creates a human loop. If
 * <code>HumanLoopActivationConfig</code> is not given, then all requests go to humans.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HumanLoopActivationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<HumanLoopActivationConfig.Builder, HumanLoopActivationConfig> {
    private static final SdkField<HumanLoopActivationConditionsConfig> HUMAN_LOOP_ACTIVATION_CONDITIONS_CONFIG_FIELD = SdkField
            .<HumanLoopActivationConditionsConfig> builder(MarshallingType.SDK_POJO)
            .memberName("HumanLoopActivationConditionsConfig")
            .getter(getter(HumanLoopActivationConfig::humanLoopActivationConditionsConfig))
            .setter(setter(Builder::humanLoopActivationConditionsConfig))
            .constructor(HumanLoopActivationConditionsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("HumanLoopActivationConditionsConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(HUMAN_LOOP_ACTIVATION_CONDITIONS_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final HumanLoopActivationConditionsConfig humanLoopActivationConditionsConfig;

    private HumanLoopActivationConfig(BuilderImpl builder) {
        this.humanLoopActivationConditionsConfig = builder.humanLoopActivationConditionsConfig;
    }

    /**
     * <p>
     * Container structure for defining under what conditions SageMaker creates a human loop.
     * </p>
     * 
     * @return Container structure for defining under what conditions SageMaker creates a human loop.
     */
    public final HumanLoopActivationConditionsConfig humanLoopActivationConditionsConfig() {
        return humanLoopActivationConditionsConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopActivationConditionsConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanLoopActivationConfig)) {
            return false;
        }
        HumanLoopActivationConfig other = (HumanLoopActivationConfig) obj;
        return Objects.equals(humanLoopActivationConditionsConfig(), other.humanLoopActivationConditionsConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HumanLoopActivationConfig")
                .add("HumanLoopActivationConditionsConfig", humanLoopActivationConditionsConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HumanLoopActivationConditionsConfig":
            return Optional.ofNullable(clazz.cast(humanLoopActivationConditionsConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HumanLoopActivationConfig, T> g) {
        return obj -> g.apply((HumanLoopActivationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HumanLoopActivationConfig> {
        /**
         * <p>
         * Container structure for defining under what conditions SageMaker creates a human loop.
         * </p>
         * 
         * @param humanLoopActivationConditionsConfig
         *        Container structure for defining under what conditions SageMaker creates a human loop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopActivationConditionsConfig(HumanLoopActivationConditionsConfig humanLoopActivationConditionsConfig);

        /**
         * <p>
         * Container structure for defining under what conditions SageMaker creates a human loop.
         * </p>
         * This is a convenience that creates an instance of the {@link HumanLoopActivationConditionsConfig.Builder}
         * avoiding the need to create one manually via {@link HumanLoopActivationConditionsConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link HumanLoopActivationConditionsConfig.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #humanLoopActivationConditionsConfig(HumanLoopActivationConditionsConfig)}.
         * 
         * @param humanLoopActivationConditionsConfig
         *        a consumer that will call methods on {@link HumanLoopActivationConditionsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #humanLoopActivationConditionsConfig(HumanLoopActivationConditionsConfig)
         */
        default Builder humanLoopActivationConditionsConfig(
                Consumer<HumanLoopActivationConditionsConfig.Builder> humanLoopActivationConditionsConfig) {
            return humanLoopActivationConditionsConfig(HumanLoopActivationConditionsConfig.builder()
                    .applyMutation(humanLoopActivationConditionsConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private HumanLoopActivationConditionsConfig humanLoopActivationConditionsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(HumanLoopActivationConfig model) {
            humanLoopActivationConditionsConfig(model.humanLoopActivationConditionsConfig);
        }

        public final HumanLoopActivationConditionsConfig.Builder getHumanLoopActivationConditionsConfig() {
            return humanLoopActivationConditionsConfig != null ? humanLoopActivationConditionsConfig.toBuilder() : null;
        }

        public final void setHumanLoopActivationConditionsConfig(
                HumanLoopActivationConditionsConfig.BuilderImpl humanLoopActivationConditionsConfig) {
            this.humanLoopActivationConditionsConfig = humanLoopActivationConditionsConfig != null ? humanLoopActivationConditionsConfig
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder humanLoopActivationConditionsConfig(
                HumanLoopActivationConditionsConfig humanLoopActivationConditionsConfig) {
            this.humanLoopActivationConditionsConfig = humanLoopActivationConditionsConfig;
            return this;
        }

        @Override
        public HumanLoopActivationConfig build() {
            return new HumanLoopActivationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
