/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDeviceFleetRequest extends SageMakerRequest implements
        ToCopyableBuilder<DeleteDeviceFleetRequest.Builder, DeleteDeviceFleetRequest> {
    private static final SdkField<String> DEVICE_FLEET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceFleetName").getter(getter(DeleteDeviceFleetRequest::deviceFleetName))
            .setter(setter(Builder::deviceFleetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_FLEET_NAME_FIELD));

    private final String deviceFleetName;

    private DeleteDeviceFleetRequest(BuilderImpl builder) {
        super(builder);
        this.deviceFleetName = builder.deviceFleetName;
    }

    /**
     * <p>
     * The name of the fleet to delete.
     * </p>
     * 
     * @return The name of the fleet to delete.
     */
    public final String deviceFleetName() {
        return deviceFleetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceFleetName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDeviceFleetRequest)) {
            return false;
        }
        DeleteDeviceFleetRequest other = (DeleteDeviceFleetRequest) obj;
        return Objects.equals(deviceFleetName(), other.deviceFleetName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteDeviceFleetRequest").add("DeviceFleetName", deviceFleetName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceFleetName":
            return Optional.ofNullable(clazz.cast(deviceFleetName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDeviceFleetRequest, T> g) {
        return obj -> g.apply((DeleteDeviceFleetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteDeviceFleetRequest> {
        /**
         * <p>
         * The name of the fleet to delete.
         * </p>
         * 
         * @param deviceFleetName
         *        The name of the fleet to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceFleetName(String deviceFleetName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String deviceFleetName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDeviceFleetRequest model) {
            super(model);
            deviceFleetName(model.deviceFleetName);
        }

        public final String getDeviceFleetName() {
            return deviceFleetName;
        }

        public final void setDeviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
        }

        @Override
        @Transient
        public final Builder deviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDeviceFleetRequest build() {
            return new DeleteDeviceFleetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
