/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Inputs for the model bias job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelBiasJobInput implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelBiasJobInput.Builder, ModelBiasJobInput> {
    private static final SdkField<EndpointInput> ENDPOINT_INPUT_FIELD = SdkField
            .<EndpointInput> builder(MarshallingType.SDK_POJO).memberName("EndpointInput")
            .getter(getter(ModelBiasJobInput::endpointInput)).setter(setter(Builder::endpointInput))
            .constructor(EndpointInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointInput").build()).build();

    private static final SdkField<MonitoringGroundTruthS3Input> GROUND_TRUTH_S3_INPUT_FIELD = SdkField
            .<MonitoringGroundTruthS3Input> builder(MarshallingType.SDK_POJO).memberName("GroundTruthS3Input")
            .getter(getter(ModelBiasJobInput::groundTruthS3Input)).setter(setter(Builder::groundTruthS3Input))
            .constructor(MonitoringGroundTruthS3Input::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroundTruthS3Input").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_INPUT_FIELD,
            GROUND_TRUTH_S3_INPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final EndpointInput endpointInput;

    private final MonitoringGroundTruthS3Input groundTruthS3Input;

    private ModelBiasJobInput(BuilderImpl builder) {
        this.endpointInput = builder.endpointInput;
        this.groundTruthS3Input = builder.groundTruthS3Input;
    }

    /**
     * Returns the value of the EndpointInput property for this object.
     * 
     * @return The value of the EndpointInput property for this object.
     */
    public final EndpointInput endpointInput() {
        return endpointInput;
    }

    /**
     * <p>
     * Location of ground truth labels to use in model bias job.
     * </p>
     * 
     * @return Location of ground truth labels to use in model bias job.
     */
    public final MonitoringGroundTruthS3Input groundTruthS3Input() {
        return groundTruthS3Input;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointInput());
        hashCode = 31 * hashCode + Objects.hashCode(groundTruthS3Input());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelBiasJobInput)) {
            return false;
        }
        ModelBiasJobInput other = (ModelBiasJobInput) obj;
        return Objects.equals(endpointInput(), other.endpointInput())
                && Objects.equals(groundTruthS3Input(), other.groundTruthS3Input());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelBiasJobInput").add("EndpointInput", endpointInput())
                .add("GroundTruthS3Input", groundTruthS3Input()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointInput":
            return Optional.ofNullable(clazz.cast(endpointInput()));
        case "GroundTruthS3Input":
            return Optional.ofNullable(clazz.cast(groundTruthS3Input()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelBiasJobInput, T> g) {
        return obj -> g.apply((ModelBiasJobInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelBiasJobInput> {
        /**
         * Sets the value of the EndpointInput property for this object.
         *
         * @param endpointInput
         *        The new value for the EndpointInput property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointInput(EndpointInput endpointInput);

        /**
         * Sets the value of the EndpointInput property for this object.
         *
         * This is a convenience that creates an instance of the {@link EndpointInput.Builder} avoiding the need to
         * create one manually via {@link EndpointInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link EndpointInput.Builder#build()} is called immediately and its
         * result is passed to {@link #endpointInput(EndpointInput)}.
         * 
         * @param endpointInput
         *        a consumer that will call methods on {@link EndpointInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointInput(EndpointInput)
         */
        default Builder endpointInput(Consumer<EndpointInput.Builder> endpointInput) {
            return endpointInput(EndpointInput.builder().applyMutation(endpointInput).build());
        }

        /**
         * <p>
         * Location of ground truth labels to use in model bias job.
         * </p>
         * 
         * @param groundTruthS3Input
         *        Location of ground truth labels to use in model bias job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groundTruthS3Input(MonitoringGroundTruthS3Input groundTruthS3Input);

        /**
         * <p>
         * Location of ground truth labels to use in model bias job.
         * </p>
         * This is a convenience that creates an instance of the {@link MonitoringGroundTruthS3Input.Builder} avoiding
         * the need to create one manually via {@link MonitoringGroundTruthS3Input#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringGroundTruthS3Input.Builder#build()} is called
         * immediately and its result is passed to {@link #groundTruthS3Input(MonitoringGroundTruthS3Input)}.
         * 
         * @param groundTruthS3Input
         *        a consumer that will call methods on {@link MonitoringGroundTruthS3Input.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groundTruthS3Input(MonitoringGroundTruthS3Input)
         */
        default Builder groundTruthS3Input(Consumer<MonitoringGroundTruthS3Input.Builder> groundTruthS3Input) {
            return groundTruthS3Input(MonitoringGroundTruthS3Input.builder().applyMutation(groundTruthS3Input).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EndpointInput endpointInput;

        private MonitoringGroundTruthS3Input groundTruthS3Input;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelBiasJobInput model) {
            endpointInput(model.endpointInput);
            groundTruthS3Input(model.groundTruthS3Input);
        }

        public final EndpointInput.Builder getEndpointInput() {
            return endpointInput != null ? endpointInput.toBuilder() : null;
        }

        public final void setEndpointInput(EndpointInput.BuilderImpl endpointInput) {
            this.endpointInput = endpointInput != null ? endpointInput.build() : null;
        }

        @Override
        @Transient
        public final Builder endpointInput(EndpointInput endpointInput) {
            this.endpointInput = endpointInput;
            return this;
        }

        public final MonitoringGroundTruthS3Input.Builder getGroundTruthS3Input() {
            return groundTruthS3Input != null ? groundTruthS3Input.toBuilder() : null;
        }

        public final void setGroundTruthS3Input(MonitoringGroundTruthS3Input.BuilderImpl groundTruthS3Input) {
            this.groundTruthS3Input = groundTruthS3Input != null ? groundTruthS3Input.build() : null;
        }

        @Override
        @Transient
        public final Builder groundTruthS3Input(MonitoringGroundTruthS3Input groundTruthS3Input) {
            this.groundTruthS3Input = groundTruthS3Input;
            return this;
        }

        @Override
        public ModelBiasJobInput build() {
            return new ModelBiasJobInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
