/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for monitoring constraints and monitoring statistics. These baseline resources are compared against the
 * results of the current job from the series of jobs scheduled to collect data periodically.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelQualityBaselineConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelQualityBaselineConfig.Builder, ModelQualityBaselineConfig> {
    private static final SdkField<String> BASELINING_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseliningJobName").getter(getter(ModelQualityBaselineConfig::baseliningJobName))
            .setter(setter(Builder::baseliningJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseliningJobName").build()).build();

    private static final SdkField<MonitoringConstraintsResource> CONSTRAINTS_RESOURCE_FIELD = SdkField
            .<MonitoringConstraintsResource> builder(MarshallingType.SDK_POJO).memberName("ConstraintsResource")
            .getter(getter(ModelQualityBaselineConfig::constraintsResource)).setter(setter(Builder::constraintsResource))
            .constructor(MonitoringConstraintsResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConstraintsResource").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASELINING_JOB_NAME_FIELD,
            CONSTRAINTS_RESOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String baseliningJobName;

    private final MonitoringConstraintsResource constraintsResource;

    private ModelQualityBaselineConfig(BuilderImpl builder) {
        this.baseliningJobName = builder.baseliningJobName;
        this.constraintsResource = builder.constraintsResource;
    }

    /**
     * <p>
     * The name of the job that performs baselining for the monitoring job.
     * </p>
     * 
     * @return The name of the job that performs baselining for the monitoring job.
     */
    public final String baseliningJobName() {
        return baseliningJobName;
    }

    /**
     * Returns the value of the ConstraintsResource property for this object.
     * 
     * @return The value of the ConstraintsResource property for this object.
     */
    public final MonitoringConstraintsResource constraintsResource() {
        return constraintsResource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baseliningJobName());
        hashCode = 31 * hashCode + Objects.hashCode(constraintsResource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelQualityBaselineConfig)) {
            return false;
        }
        ModelQualityBaselineConfig other = (ModelQualityBaselineConfig) obj;
        return Objects.equals(baseliningJobName(), other.baseliningJobName())
                && Objects.equals(constraintsResource(), other.constraintsResource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelQualityBaselineConfig").add("BaseliningJobName", baseliningJobName())
                .add("ConstraintsResource", constraintsResource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaseliningJobName":
            return Optional.ofNullable(clazz.cast(baseliningJobName()));
        case "ConstraintsResource":
            return Optional.ofNullable(clazz.cast(constraintsResource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelQualityBaselineConfig, T> g) {
        return obj -> g.apply((ModelQualityBaselineConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelQualityBaselineConfig> {
        /**
         * <p>
         * The name of the job that performs baselining for the monitoring job.
         * </p>
         * 
         * @param baseliningJobName
         *        The name of the job that performs baselining for the monitoring job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseliningJobName(String baseliningJobName);

        /**
         * Sets the value of the ConstraintsResource property for this object.
         *
         * @param constraintsResource
         *        The new value for the ConstraintsResource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constraintsResource(MonitoringConstraintsResource constraintsResource);

        /**
         * Sets the value of the ConstraintsResource property for this object.
         *
         * This is a convenience that creates an instance of the {@link MonitoringConstraintsResource.Builder} avoiding
         * the need to create one manually via {@link MonitoringConstraintsResource#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringConstraintsResource.Builder#build()} is called
         * immediately and its result is passed to {@link #constraintsResource(MonitoringConstraintsResource)}.
         * 
         * @param constraintsResource
         *        a consumer that will call methods on {@link MonitoringConstraintsResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #constraintsResource(MonitoringConstraintsResource)
         */
        default Builder constraintsResource(Consumer<MonitoringConstraintsResource.Builder> constraintsResource) {
            return constraintsResource(MonitoringConstraintsResource.builder().applyMutation(constraintsResource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String baseliningJobName;

        private MonitoringConstraintsResource constraintsResource;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelQualityBaselineConfig model) {
            baseliningJobName(model.baseliningJobName);
            constraintsResource(model.constraintsResource);
        }

        public final String getBaseliningJobName() {
            return baseliningJobName;
        }

        public final void setBaseliningJobName(String baseliningJobName) {
            this.baseliningJobName = baseliningJobName;
        }

        @Override
        @Transient
        public final Builder baseliningJobName(String baseliningJobName) {
            this.baseliningJobName = baseliningJobName;
            return this;
        }

        public final MonitoringConstraintsResource.Builder getConstraintsResource() {
            return constraintsResource != null ? constraintsResource.toBuilder() : null;
        }

        public final void setConstraintsResource(MonitoringConstraintsResource.BuilderImpl constraintsResource) {
            this.constraintsResource = constraintsResource != null ? constraintsResource.build() : null;
        }

        @Override
        @Transient
        public final Builder constraintsResource(MonitoringConstraintsResource constraintsResource) {
            this.constraintsResource = constraintsResource;
            return this;
        }

        @Override
        public ModelQualityBaselineConfig build() {
            return new ModelQualityBaselineConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
