/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateModelBiasJobDefinitionRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateModelBiasJobDefinitionRequest.Builder, CreateModelBiasJobDefinitionRequest> {
    private static final SdkField<String> JOB_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobDefinitionName").getter(getter(CreateModelBiasJobDefinitionRequest::jobDefinitionName))
            .setter(setter(Builder::jobDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDefinitionName").build()).build();

    private static final SdkField<ModelBiasBaselineConfig> MODEL_BIAS_BASELINE_CONFIG_FIELD = SdkField
            .<ModelBiasBaselineConfig> builder(MarshallingType.SDK_POJO).memberName("ModelBiasBaselineConfig")
            .getter(getter(CreateModelBiasJobDefinitionRequest::modelBiasBaselineConfig))
            .setter(setter(Builder::modelBiasBaselineConfig)).constructor(ModelBiasBaselineConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelBiasBaselineConfig").build())
            .build();

    private static final SdkField<ModelBiasAppSpecification> MODEL_BIAS_APP_SPECIFICATION_FIELD = SdkField
            .<ModelBiasAppSpecification> builder(MarshallingType.SDK_POJO).memberName("ModelBiasAppSpecification")
            .getter(getter(CreateModelBiasJobDefinitionRequest::modelBiasAppSpecification))
            .setter(setter(Builder::modelBiasAppSpecification)).constructor(ModelBiasAppSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelBiasAppSpecification").build())
            .build();

    private static final SdkField<ModelBiasJobInput> MODEL_BIAS_JOB_INPUT_FIELD = SdkField
            .<ModelBiasJobInput> builder(MarshallingType.SDK_POJO).memberName("ModelBiasJobInput")
            .getter(getter(CreateModelBiasJobDefinitionRequest::modelBiasJobInput)).setter(setter(Builder::modelBiasJobInput))
            .constructor(ModelBiasJobInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelBiasJobInput").build()).build();

    private static final SdkField<MonitoringOutputConfig> MODEL_BIAS_JOB_OUTPUT_CONFIG_FIELD = SdkField
            .<MonitoringOutputConfig> builder(MarshallingType.SDK_POJO).memberName("ModelBiasJobOutputConfig")
            .getter(getter(CreateModelBiasJobDefinitionRequest::modelBiasJobOutputConfig))
            .setter(setter(Builder::modelBiasJobOutputConfig)).constructor(MonitoringOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelBiasJobOutputConfig").build())
            .build();

    private static final SdkField<MonitoringResources> JOB_RESOURCES_FIELD = SdkField
            .<MonitoringResources> builder(MarshallingType.SDK_POJO).memberName("JobResources")
            .getter(getter(CreateModelBiasJobDefinitionRequest::jobResources)).setter(setter(Builder::jobResources))
            .constructor(MonitoringResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobResources").build()).build();

    private static final SdkField<MonitoringNetworkConfig> NETWORK_CONFIG_FIELD = SdkField
            .<MonitoringNetworkConfig> builder(MarshallingType.SDK_POJO).memberName("NetworkConfig")
            .getter(getter(CreateModelBiasJobDefinitionRequest::networkConfig)).setter(setter(Builder::networkConfig))
            .constructor(MonitoringNetworkConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfig").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateModelBiasJobDefinitionRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<MonitoringStoppingCondition> STOPPING_CONDITION_FIELD = SdkField
            .<MonitoringStoppingCondition> builder(MarshallingType.SDK_POJO).memberName("StoppingCondition")
            .getter(getter(CreateModelBiasJobDefinitionRequest::stoppingCondition)).setter(setter(Builder::stoppingCondition))
            .constructor(MonitoringStoppingCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateModelBiasJobDefinitionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITION_NAME_FIELD,
            MODEL_BIAS_BASELINE_CONFIG_FIELD, MODEL_BIAS_APP_SPECIFICATION_FIELD, MODEL_BIAS_JOB_INPUT_FIELD,
            MODEL_BIAS_JOB_OUTPUT_CONFIG_FIELD, JOB_RESOURCES_FIELD, NETWORK_CONFIG_FIELD, ROLE_ARN_FIELD,
            STOPPING_CONDITION_FIELD, TAGS_FIELD));

    private final String jobDefinitionName;

    private final ModelBiasBaselineConfig modelBiasBaselineConfig;

    private final ModelBiasAppSpecification modelBiasAppSpecification;

    private final ModelBiasJobInput modelBiasJobInput;

    private final MonitoringOutputConfig modelBiasJobOutputConfig;

    private final MonitoringResources jobResources;

    private final MonitoringNetworkConfig networkConfig;

    private final String roleArn;

    private final MonitoringStoppingCondition stoppingCondition;

    private final List<Tag> tags;

    private CreateModelBiasJobDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.jobDefinitionName = builder.jobDefinitionName;
        this.modelBiasBaselineConfig = builder.modelBiasBaselineConfig;
        this.modelBiasAppSpecification = builder.modelBiasAppSpecification;
        this.modelBiasJobInput = builder.modelBiasJobInput;
        this.modelBiasJobOutputConfig = builder.modelBiasJobOutputConfig;
        this.jobResources = builder.jobResources;
        this.networkConfig = builder.networkConfig;
        this.roleArn = builder.roleArn;
        this.stoppingCondition = builder.stoppingCondition;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the bias job definition. The name must be unique within an Amazon Web Services Region in the Amazon
     * Web Services account.
     * </p>
     * 
     * @return The name of the bias job definition. The name must be unique within an Amazon Web Services Region in the
     *         Amazon Web Services account.
     */
    public final String jobDefinitionName() {
        return jobDefinitionName;
    }

    /**
     * <p>
     * The baseline configuration for a model bias job.
     * </p>
     * 
     * @return The baseline configuration for a model bias job.
     */
    public final ModelBiasBaselineConfig modelBiasBaselineConfig() {
        return modelBiasBaselineConfig;
    }

    /**
     * <p>
     * Configures the model bias job to run a specified Docker container image.
     * </p>
     * 
     * @return Configures the model bias job to run a specified Docker container image.
     */
    public final ModelBiasAppSpecification modelBiasAppSpecification() {
        return modelBiasAppSpecification;
    }

    /**
     * <p>
     * Inputs for the model bias job.
     * </p>
     * 
     * @return Inputs for the model bias job.
     */
    public final ModelBiasJobInput modelBiasJobInput() {
        return modelBiasJobInput;
    }

    /**
     * Returns the value of the ModelBiasJobOutputConfig property for this object.
     * 
     * @return The value of the ModelBiasJobOutputConfig property for this object.
     */
    public final MonitoringOutputConfig modelBiasJobOutputConfig() {
        return modelBiasJobOutputConfig;
    }

    /**
     * Returns the value of the JobResources property for this object.
     * 
     * @return The value of the JobResources property for this object.
     */
    public final MonitoringResources jobResources() {
        return jobResources;
    }

    /**
     * <p>
     * Networking options for a model bias job.
     * </p>
     * 
     * @return Networking options for a model bias job.
     */
    public final MonitoringNetworkConfig networkConfig() {
        return networkConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your
     *         behalf.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * Returns the value of the StoppingCondition property for this object.
     * 
     * @return The value of the StoppingCondition property for this object.
     */
    public final MonitoringStoppingCondition stoppingCondition() {
        return stoppingCondition;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Optional) An array of key-value pairs. For more information, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using
     * Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return (Optional) An array of key-value pairs. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
     *         >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(modelBiasBaselineConfig());
        hashCode = 31 * hashCode + Objects.hashCode(modelBiasAppSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(modelBiasJobInput());
        hashCode = 31 * hashCode + Objects.hashCode(modelBiasJobOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(jobResources());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelBiasJobDefinitionRequest)) {
            return false;
        }
        CreateModelBiasJobDefinitionRequest other = (CreateModelBiasJobDefinitionRequest) obj;
        return Objects.equals(jobDefinitionName(), other.jobDefinitionName())
                && Objects.equals(modelBiasBaselineConfig(), other.modelBiasBaselineConfig())
                && Objects.equals(modelBiasAppSpecification(), other.modelBiasAppSpecification())
                && Objects.equals(modelBiasJobInput(), other.modelBiasJobInput())
                && Objects.equals(modelBiasJobOutputConfig(), other.modelBiasJobOutputConfig())
                && Objects.equals(jobResources(), other.jobResources()) && Objects.equals(networkConfig(), other.networkConfig())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(stoppingCondition(), other.stoppingCondition())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateModelBiasJobDefinitionRequest").add("JobDefinitionName", jobDefinitionName())
                .add("ModelBiasBaselineConfig", modelBiasBaselineConfig())
                .add("ModelBiasAppSpecification", modelBiasAppSpecification()).add("ModelBiasJobInput", modelBiasJobInput())
                .add("ModelBiasJobOutputConfig", modelBiasJobOutputConfig()).add("JobResources", jobResources())
                .add("NetworkConfig", networkConfig()).add("RoleArn", roleArn()).add("StoppingCondition", stoppingCondition())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobDefinitionName":
            return Optional.ofNullable(clazz.cast(jobDefinitionName()));
        case "ModelBiasBaselineConfig":
            return Optional.ofNullable(clazz.cast(modelBiasBaselineConfig()));
        case "ModelBiasAppSpecification":
            return Optional.ofNullable(clazz.cast(modelBiasAppSpecification()));
        case "ModelBiasJobInput":
            return Optional.ofNullable(clazz.cast(modelBiasJobInput()));
        case "ModelBiasJobOutputConfig":
            return Optional.ofNullable(clazz.cast(modelBiasJobOutputConfig()));
        case "JobResources":
            return Optional.ofNullable(clazz.cast(jobResources()));
        case "NetworkConfig":
            return Optional.ofNullable(clazz.cast(networkConfig()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "StoppingCondition":
            return Optional.ofNullable(clazz.cast(stoppingCondition()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelBiasJobDefinitionRequest, T> g) {
        return obj -> g.apply((CreateModelBiasJobDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateModelBiasJobDefinitionRequest> {
        /**
         * <p>
         * The name of the bias job definition. The name must be unique within an Amazon Web Services Region in the
         * Amazon Web Services account.
         * </p>
         * 
         * @param jobDefinitionName
         *        The name of the bias job definition. The name must be unique within an Amazon Web Services Region in
         *        the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitionName(String jobDefinitionName);

        /**
         * <p>
         * The baseline configuration for a model bias job.
         * </p>
         * 
         * @param modelBiasBaselineConfig
         *        The baseline configuration for a model bias job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelBiasBaselineConfig(ModelBiasBaselineConfig modelBiasBaselineConfig);

        /**
         * <p>
         * The baseline configuration for a model bias job.
         * </p>
         * This is a convenience that creates an instance of the {@link ModelBiasBaselineConfig.Builder} avoiding the
         * need to create one manually via {@link ModelBiasBaselineConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelBiasBaselineConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #modelBiasBaselineConfig(ModelBiasBaselineConfig)}.
         * 
         * @param modelBiasBaselineConfig
         *        a consumer that will call methods on {@link ModelBiasBaselineConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelBiasBaselineConfig(ModelBiasBaselineConfig)
         */
        default Builder modelBiasBaselineConfig(Consumer<ModelBiasBaselineConfig.Builder> modelBiasBaselineConfig) {
            return modelBiasBaselineConfig(ModelBiasBaselineConfig.builder().applyMutation(modelBiasBaselineConfig).build());
        }

        /**
         * <p>
         * Configures the model bias job to run a specified Docker container image.
         * </p>
         * 
         * @param modelBiasAppSpecification
         *        Configures the model bias job to run a specified Docker container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelBiasAppSpecification(ModelBiasAppSpecification modelBiasAppSpecification);

        /**
         * <p>
         * Configures the model bias job to run a specified Docker container image.
         * </p>
         * This is a convenience that creates an instance of the {@link ModelBiasAppSpecification.Builder} avoiding the
         * need to create one manually via {@link ModelBiasAppSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelBiasAppSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #modelBiasAppSpecification(ModelBiasAppSpecification)}.
         * 
         * @param modelBiasAppSpecification
         *        a consumer that will call methods on {@link ModelBiasAppSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelBiasAppSpecification(ModelBiasAppSpecification)
         */
        default Builder modelBiasAppSpecification(Consumer<ModelBiasAppSpecification.Builder> modelBiasAppSpecification) {
            return modelBiasAppSpecification(ModelBiasAppSpecification.builder().applyMutation(modelBiasAppSpecification).build());
        }

        /**
         * <p>
         * Inputs for the model bias job.
         * </p>
         * 
         * @param modelBiasJobInput
         *        Inputs for the model bias job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelBiasJobInput(ModelBiasJobInput modelBiasJobInput);

        /**
         * <p>
         * Inputs for the model bias job.
         * </p>
         * This is a convenience that creates an instance of the {@link ModelBiasJobInput.Builder} avoiding the need to
         * create one manually via {@link ModelBiasJobInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelBiasJobInput.Builder#build()} is called immediately and its
         * result is passed to {@link #modelBiasJobInput(ModelBiasJobInput)}.
         * 
         * @param modelBiasJobInput
         *        a consumer that will call methods on {@link ModelBiasJobInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelBiasJobInput(ModelBiasJobInput)
         */
        default Builder modelBiasJobInput(Consumer<ModelBiasJobInput.Builder> modelBiasJobInput) {
            return modelBiasJobInput(ModelBiasJobInput.builder().applyMutation(modelBiasJobInput).build());
        }

        /**
         * Sets the value of the ModelBiasJobOutputConfig property for this object.
         *
         * @param modelBiasJobOutputConfig
         *        The new value for the ModelBiasJobOutputConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelBiasJobOutputConfig(MonitoringOutputConfig modelBiasJobOutputConfig);

        /**
         * Sets the value of the ModelBiasJobOutputConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link MonitoringOutputConfig.Builder} avoiding the
         * need to create one manually via {@link MonitoringOutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringOutputConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #modelBiasJobOutputConfig(MonitoringOutputConfig)}.
         * 
         * @param modelBiasJobOutputConfig
         *        a consumer that will call methods on {@link MonitoringOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelBiasJobOutputConfig(MonitoringOutputConfig)
         */
        default Builder modelBiasJobOutputConfig(Consumer<MonitoringOutputConfig.Builder> modelBiasJobOutputConfig) {
            return modelBiasJobOutputConfig(MonitoringOutputConfig.builder().applyMutation(modelBiasJobOutputConfig).build());
        }

        /**
         * Sets the value of the JobResources property for this object.
         *
         * @param jobResources
         *        The new value for the JobResources property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobResources(MonitoringResources jobResources);

        /**
         * Sets the value of the JobResources property for this object.
         *
         * This is a convenience that creates an instance of the {@link MonitoringResources.Builder} avoiding the need
         * to create one manually via {@link MonitoringResources#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringResources.Builder#build()} is called immediately and
         * its result is passed to {@link #jobResources(MonitoringResources)}.
         * 
         * @param jobResources
         *        a consumer that will call methods on {@link MonitoringResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobResources(MonitoringResources)
         */
        default Builder jobResources(Consumer<MonitoringResources.Builder> jobResources) {
            return jobResources(MonitoringResources.builder().applyMutation(jobResources).build());
        }

        /**
         * <p>
         * Networking options for a model bias job.
         * </p>
         * 
         * @param networkConfig
         *        Networking options for a model bias job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfig(MonitoringNetworkConfig networkConfig);

        /**
         * <p>
         * Networking options for a model bias job.
         * </p>
         * This is a convenience that creates an instance of the {@link MonitoringNetworkConfig.Builder} avoiding the
         * need to create one manually via {@link MonitoringNetworkConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringNetworkConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #networkConfig(MonitoringNetworkConfig)}.
         * 
         * @param networkConfig
         *        a consumer that will call methods on {@link MonitoringNetworkConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfig(MonitoringNetworkConfig)
         */
        default Builder networkConfig(Consumer<MonitoringNetworkConfig.Builder> networkConfig) {
            return networkConfig(MonitoringNetworkConfig.builder().applyMutation(networkConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your
         * behalf.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on
         *        your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * Sets the value of the StoppingCondition property for this object.
         *
         * @param stoppingCondition
         *        The new value for the StoppingCondition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingCondition(MonitoringStoppingCondition stoppingCondition);

        /**
         * Sets the value of the StoppingCondition property for this object.
         *
         * This is a convenience that creates an instance of the {@link MonitoringStoppingCondition.Builder} avoiding
         * the need to create one manually via {@link MonitoringStoppingCondition#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringStoppingCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #stoppingCondition(MonitoringStoppingCondition)}.
         * 
         * @param stoppingCondition
         *        a consumer that will call methods on {@link MonitoringStoppingCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingCondition(MonitoringStoppingCondition)
         */
        default Builder stoppingCondition(Consumer<MonitoringStoppingCondition.Builder> stoppingCondition) {
            return stoppingCondition(MonitoringStoppingCondition.builder().applyMutation(stoppingCondition).build());
        }

        /**
         * <p>
         * (Optional) An array of key-value pairs. For more information, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         * >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.
         * </p>
         * 
         * @param tags
         *        (Optional) An array of key-value pairs. For more information, see <a href=
         *        "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         *        >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * (Optional) An array of key-value pairs. For more information, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         * >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.
         * </p>
         * 
         * @param tags
         *        (Optional) An array of key-value pairs. For more information, see <a href=
         *        "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         *        >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * (Optional) An array of key-value pairs. For more information, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         * >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String jobDefinitionName;

        private ModelBiasBaselineConfig modelBiasBaselineConfig;

        private ModelBiasAppSpecification modelBiasAppSpecification;

        private ModelBiasJobInput modelBiasJobInput;

        private MonitoringOutputConfig modelBiasJobOutputConfig;

        private MonitoringResources jobResources;

        private MonitoringNetworkConfig networkConfig;

        private String roleArn;

        private MonitoringStoppingCondition stoppingCondition;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelBiasJobDefinitionRequest model) {
            super(model);
            jobDefinitionName(model.jobDefinitionName);
            modelBiasBaselineConfig(model.modelBiasBaselineConfig);
            modelBiasAppSpecification(model.modelBiasAppSpecification);
            modelBiasJobInput(model.modelBiasJobInput);
            modelBiasJobOutputConfig(model.modelBiasJobOutputConfig);
            jobResources(model.jobResources);
            networkConfig(model.networkConfig);
            roleArn(model.roleArn);
            stoppingCondition(model.stoppingCondition);
            tags(model.tags);
        }

        public final String getJobDefinitionName() {
            return jobDefinitionName;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        @Override
        @Transient
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final ModelBiasBaselineConfig.Builder getModelBiasBaselineConfig() {
            return modelBiasBaselineConfig != null ? modelBiasBaselineConfig.toBuilder() : null;
        }

        public final void setModelBiasBaselineConfig(ModelBiasBaselineConfig.BuilderImpl modelBiasBaselineConfig) {
            this.modelBiasBaselineConfig = modelBiasBaselineConfig != null ? modelBiasBaselineConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder modelBiasBaselineConfig(ModelBiasBaselineConfig modelBiasBaselineConfig) {
            this.modelBiasBaselineConfig = modelBiasBaselineConfig;
            return this;
        }

        public final ModelBiasAppSpecification.Builder getModelBiasAppSpecification() {
            return modelBiasAppSpecification != null ? modelBiasAppSpecification.toBuilder() : null;
        }

        public final void setModelBiasAppSpecification(ModelBiasAppSpecification.BuilderImpl modelBiasAppSpecification) {
            this.modelBiasAppSpecification = modelBiasAppSpecification != null ? modelBiasAppSpecification.build() : null;
        }

        @Override
        @Transient
        public final Builder modelBiasAppSpecification(ModelBiasAppSpecification modelBiasAppSpecification) {
            this.modelBiasAppSpecification = modelBiasAppSpecification;
            return this;
        }

        public final ModelBiasJobInput.Builder getModelBiasJobInput() {
            return modelBiasJobInput != null ? modelBiasJobInput.toBuilder() : null;
        }

        public final void setModelBiasJobInput(ModelBiasJobInput.BuilderImpl modelBiasJobInput) {
            this.modelBiasJobInput = modelBiasJobInput != null ? modelBiasJobInput.build() : null;
        }

        @Override
        @Transient
        public final Builder modelBiasJobInput(ModelBiasJobInput modelBiasJobInput) {
            this.modelBiasJobInput = modelBiasJobInput;
            return this;
        }

        public final MonitoringOutputConfig.Builder getModelBiasJobOutputConfig() {
            return modelBiasJobOutputConfig != null ? modelBiasJobOutputConfig.toBuilder() : null;
        }

        public final void setModelBiasJobOutputConfig(MonitoringOutputConfig.BuilderImpl modelBiasJobOutputConfig) {
            this.modelBiasJobOutputConfig = modelBiasJobOutputConfig != null ? modelBiasJobOutputConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder modelBiasJobOutputConfig(MonitoringOutputConfig modelBiasJobOutputConfig) {
            this.modelBiasJobOutputConfig = modelBiasJobOutputConfig;
            return this;
        }

        public final MonitoringResources.Builder getJobResources() {
            return jobResources != null ? jobResources.toBuilder() : null;
        }

        public final void setJobResources(MonitoringResources.BuilderImpl jobResources) {
            this.jobResources = jobResources != null ? jobResources.build() : null;
        }

        @Override
        @Transient
        public final Builder jobResources(MonitoringResources jobResources) {
            this.jobResources = jobResources;
            return this;
        }

        public final MonitoringNetworkConfig.Builder getNetworkConfig() {
            return networkConfig != null ? networkConfig.toBuilder() : null;
        }

        public final void setNetworkConfig(MonitoringNetworkConfig.BuilderImpl networkConfig) {
            this.networkConfig = networkConfig != null ? networkConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder networkConfig(MonitoringNetworkConfig networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final MonitoringStoppingCondition.Builder getStoppingCondition() {
            return stoppingCondition != null ? stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(MonitoringStoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        @Transient
        public final Builder stoppingCondition(MonitoringStoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelBiasJobDefinitionRequest build() {
            return new CreateModelBiasJobDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
