/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListModelPackageGroupsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListModelPackageGroupsResponse.Builder, ListModelPackageGroupsResponse> {
    private static final SdkField<List<ModelPackageGroupSummary>> MODEL_PACKAGE_GROUP_SUMMARY_LIST_FIELD = SdkField
            .<List<ModelPackageGroupSummary>> builder(MarshallingType.LIST)
            .memberName("ModelPackageGroupSummaryList")
            .getter(getter(ListModelPackageGroupsResponse::modelPackageGroupSummaryList))
            .setter(setter(Builder::modelPackageGroupSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupSummaryList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelPackageGroupSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelPackageGroupSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListModelPackageGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MODEL_PACKAGE_GROUP_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<ModelPackageGroupSummary> modelPackageGroupSummaryList;

    private final String nextToken;

    private ListModelPackageGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.modelPackageGroupSummaryList = builder.modelPackageGroupSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ModelPackageGroupSummaryList property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasModelPackageGroupSummaryList() {
        return modelPackageGroupSummaryList != null && !(modelPackageGroupSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of summaries of the model groups in your Amazon Web Services account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasModelPackageGroupSummaryList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of summaries of the model groups in your Amazon Web Services account.
     */
    public final List<ModelPackageGroupSummary> modelPackageGroupSummaryList() {
        return modelPackageGroupSummaryList;
    }

    /**
     * <p>
     * If the response is truncated, SageMaker returns this token. To retrieve the next set of model groups, use it in
     * the subsequent request.
     * </p>
     * 
     * @return If the response is truncated, SageMaker returns this token. To retrieve the next set of model groups, use
     *         it in the subsequent request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasModelPackageGroupSummaryList() ? modelPackageGroupSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelPackageGroupsResponse)) {
            return false;
        }
        ListModelPackageGroupsResponse other = (ListModelPackageGroupsResponse) obj;
        return hasModelPackageGroupSummaryList() == other.hasModelPackageGroupSummaryList()
                && Objects.equals(modelPackageGroupSummaryList(), other.modelPackageGroupSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListModelPackageGroupsResponse")
                .add("ModelPackageGroupSummaryList", hasModelPackageGroupSummaryList() ? modelPackageGroupSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelPackageGroupSummaryList":
            return Optional.ofNullable(clazz.cast(modelPackageGroupSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListModelPackageGroupsResponse, T> g) {
        return obj -> g.apply((ListModelPackageGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListModelPackageGroupsResponse> {
        /**
         * <p>
         * A list of summaries of the model groups in your Amazon Web Services account.
         * </p>
         * 
         * @param modelPackageGroupSummaryList
         *        A list of summaries of the model groups in your Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageGroupSummaryList(Collection<ModelPackageGroupSummary> modelPackageGroupSummaryList);

        /**
         * <p>
         * A list of summaries of the model groups in your Amazon Web Services account.
         * </p>
         * 
         * @param modelPackageGroupSummaryList
         *        A list of summaries of the model groups in your Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageGroupSummaryList(ModelPackageGroupSummary... modelPackageGroupSummaryList);

        /**
         * <p>
         * A list of summaries of the model groups in your Amazon Web Services account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ModelPackageGroupSummary>.Builder} avoiding
         * the need to create one manually via {@link List<ModelPackageGroupSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ModelPackageGroupSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #modelPackageGroupSummaryList(List<ModelPackageGroupSummary>)}
         * .
         * 
         * @param modelPackageGroupSummaryList
         *        a consumer that will call methods on {@link List<ModelPackageGroupSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelPackageGroupSummaryList(List<ModelPackageGroupSummary>)
         */
        Builder modelPackageGroupSummaryList(Consumer<ModelPackageGroupSummary.Builder>... modelPackageGroupSummaryList);

        /**
         * <p>
         * If the response is truncated, SageMaker returns this token. To retrieve the next set of model groups, use it
         * in the subsequent request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, SageMaker returns this token. To retrieve the next set of model groups,
         *        use it in the subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<ModelPackageGroupSummary> modelPackageGroupSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelPackageGroupsResponse model) {
            super(model);
            modelPackageGroupSummaryList(model.modelPackageGroupSummaryList);
            nextToken(model.nextToken);
        }

        public final List<ModelPackageGroupSummary.Builder> getModelPackageGroupSummaryList() {
            List<ModelPackageGroupSummary.Builder> result = ModelPackageGroupSummaryListCopier
                    .copyToBuilder(this.modelPackageGroupSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelPackageGroupSummaryList(
                Collection<ModelPackageGroupSummary.BuilderImpl> modelPackageGroupSummaryList) {
            this.modelPackageGroupSummaryList = ModelPackageGroupSummaryListCopier.copyFromBuilder(modelPackageGroupSummaryList);
        }

        @Override
        @Transient
        public final Builder modelPackageGroupSummaryList(Collection<ModelPackageGroupSummary> modelPackageGroupSummaryList) {
            this.modelPackageGroupSummaryList = ModelPackageGroupSummaryListCopier.copy(modelPackageGroupSummaryList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder modelPackageGroupSummaryList(ModelPackageGroupSummary... modelPackageGroupSummaryList) {
            modelPackageGroupSummaryList(Arrays.asList(modelPackageGroupSummaryList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder modelPackageGroupSummaryList(
                Consumer<ModelPackageGroupSummary.Builder>... modelPackageGroupSummaryList) {
            modelPackageGroupSummaryList(Stream.of(modelPackageGroupSummaryList)
                    .map(c -> ModelPackageGroupSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListModelPackageGroupsResponse build() {
            return new ListModelPackageGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
