/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEndpointWeightsAndCapacitiesRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateEndpointWeightsAndCapacitiesRequest.Builder, UpdateEndpointWeightsAndCapacitiesRequest> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(UpdateEndpointWeightsAndCapacitiesRequest::endpointName))
            .setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<List<DesiredWeightAndCapacity>> DESIRED_WEIGHTS_AND_CAPACITIES_FIELD = SdkField
            .<List<DesiredWeightAndCapacity>> builder(MarshallingType.LIST)
            .memberName("DesiredWeightsAndCapacities")
            .getter(getter(UpdateEndpointWeightsAndCapacitiesRequest::desiredWeightsAndCapacities))
            .setter(setter(Builder::desiredWeightsAndCapacities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredWeightsAndCapacities")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DesiredWeightAndCapacity> builder(MarshallingType.SDK_POJO)
                                            .constructor(DesiredWeightAndCapacity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD,
            DESIRED_WEIGHTS_AND_CAPACITIES_FIELD));

    private final String endpointName;

    private final List<DesiredWeightAndCapacity> desiredWeightsAndCapacities;

    private UpdateEndpointWeightsAndCapacitiesRequest(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.desiredWeightsAndCapacities = builder.desiredWeightsAndCapacities;
    }

    /**
     * <p>
     * The name of an existing Amazon SageMaker endpoint.
     * </p>
     * 
     * @return The name of an existing Amazon SageMaker endpoint.
     */
    public final String endpointName() {
        return endpointName;
    }

    /**
     * Returns true if the DesiredWeightsAndCapacities property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasDesiredWeightsAndCapacities() {
        return desiredWeightsAndCapacities != null && !(desiredWeightsAndCapacities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object that provides new capacity and weight values for a variant.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDesiredWeightsAndCapacities()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An object that provides new capacity and weight values for a variant.
     */
    public final List<DesiredWeightAndCapacity> desiredWeightsAndCapacities() {
        return desiredWeightsAndCapacities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(hasDesiredWeightsAndCapacities() ? desiredWeightsAndCapacities() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEndpointWeightsAndCapacitiesRequest)) {
            return false;
        }
        UpdateEndpointWeightsAndCapacitiesRequest other = (UpdateEndpointWeightsAndCapacitiesRequest) obj;
        return Objects.equals(endpointName(), other.endpointName())
                && hasDesiredWeightsAndCapacities() == other.hasDesiredWeightsAndCapacities()
                && Objects.equals(desiredWeightsAndCapacities(), other.desiredWeightsAndCapacities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEndpointWeightsAndCapacitiesRequest").add("EndpointName", endpointName())
                .add("DesiredWeightsAndCapacities", hasDesiredWeightsAndCapacities() ? desiredWeightsAndCapacities() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "DesiredWeightsAndCapacities":
            return Optional.ofNullable(clazz.cast(desiredWeightsAndCapacities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEndpointWeightsAndCapacitiesRequest, T> g) {
        return obj -> g.apply((UpdateEndpointWeightsAndCapacitiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateEndpointWeightsAndCapacitiesRequest> {
        /**
         * <p>
         * The name of an existing Amazon SageMaker endpoint.
         * </p>
         * 
         * @param endpointName
         *        The name of an existing Amazon SageMaker endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * An object that provides new capacity and weight values for a variant.
         * </p>
         * 
         * @param desiredWeightsAndCapacities
         *        An object that provides new capacity and weight values for a variant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredWeightsAndCapacities(Collection<DesiredWeightAndCapacity> desiredWeightsAndCapacities);

        /**
         * <p>
         * An object that provides new capacity and weight values for a variant.
         * </p>
         * 
         * @param desiredWeightsAndCapacities
         *        An object that provides new capacity and weight values for a variant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredWeightsAndCapacities(DesiredWeightAndCapacity... desiredWeightsAndCapacities);

        /**
         * <p>
         * An object that provides new capacity and weight values for a variant.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DesiredWeightAndCapacity>.Builder} avoiding
         * the need to create one manually via {@link List<DesiredWeightAndCapacity>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DesiredWeightAndCapacity>.Builder#build()} is called
         * immediately and its result is passed to {@link #desiredWeightsAndCapacities(List<DesiredWeightAndCapacity>)}.
         * 
         * @param desiredWeightsAndCapacities
         *        a consumer that will call methods on {@link List<DesiredWeightAndCapacity>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #desiredWeightsAndCapacities(List<DesiredWeightAndCapacity>)
         */
        Builder desiredWeightsAndCapacities(Consumer<DesiredWeightAndCapacity.Builder>... desiredWeightsAndCapacities);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String endpointName;

        private List<DesiredWeightAndCapacity> desiredWeightsAndCapacities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEndpointWeightsAndCapacitiesRequest model) {
            super(model);
            endpointName(model.endpointName);
            desiredWeightsAndCapacities(model.desiredWeightsAndCapacities);
        }

        public final String getEndpointName() {
            return endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        @Transient
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final List<DesiredWeightAndCapacity.Builder> getDesiredWeightsAndCapacities() {
            List<DesiredWeightAndCapacity.Builder> result = DesiredWeightAndCapacityListCopier
                    .copyToBuilder(this.desiredWeightsAndCapacities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDesiredWeightsAndCapacities(
                Collection<DesiredWeightAndCapacity.BuilderImpl> desiredWeightsAndCapacities) {
            this.desiredWeightsAndCapacities = DesiredWeightAndCapacityListCopier.copyFromBuilder(desiredWeightsAndCapacities);
        }

        @Override
        @Transient
        public final Builder desiredWeightsAndCapacities(Collection<DesiredWeightAndCapacity> desiredWeightsAndCapacities) {
            this.desiredWeightsAndCapacities = DesiredWeightAndCapacityListCopier.copy(desiredWeightsAndCapacities);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder desiredWeightsAndCapacities(DesiredWeightAndCapacity... desiredWeightsAndCapacities) {
            desiredWeightsAndCapacities(Arrays.asList(desiredWeightsAndCapacities));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder desiredWeightsAndCapacities(
                Consumer<DesiredWeightAndCapacity.Builder>... desiredWeightsAndCapacities) {
            desiredWeightsAndCapacities(Stream.of(desiredWeightsAndCapacities)
                    .map(c -> DesiredWeightAndCapacity.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEndpointWeightsAndCapacitiesRequest build() {
            return new UpdateEndpointWeightsAndCapacitiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
