/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.EdgeOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEdgePackagingJobRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateEdgePackagingJobRequest> {
    private static final SdkField<String> EDGE_PACKAGING_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EdgePackagingJobName").getter(CreateEdgePackagingJobRequest.getter(CreateEdgePackagingJobRequest::edgePackagingJobName)).setter(CreateEdgePackagingJobRequest.setter(Builder::edgePackagingJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgePackagingJobName").build()}).build();
    private static final SdkField<String> COMPILATION_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompilationJobName").getter(CreateEdgePackagingJobRequest.getter(CreateEdgePackagingJobRequest::compilationJobName)).setter(CreateEdgePackagingJobRequest.setter(Builder::compilationJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobName").build()}).build();
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(CreateEdgePackagingJobRequest.getter(CreateEdgePackagingJobRequest::modelName)).setter(CreateEdgePackagingJobRequest.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelVersion").getter(CreateEdgePackagingJobRequest.getter(CreateEdgePackagingJobRequest::modelVersion)).setter(CreateEdgePackagingJobRequest.setter(Builder::modelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateEdgePackagingJobRequest.getter(CreateEdgePackagingJobRequest::roleArn)).setter(CreateEdgePackagingJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<EdgeOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(CreateEdgePackagingJobRequest.getter(CreateEdgePackagingJobRequest::outputConfig)).setter(CreateEdgePackagingJobRequest.setter(Builder::outputConfig)).constructor(EdgeOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<String> RESOURCE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceKey").getter(CreateEdgePackagingJobRequest.getter(CreateEdgePackagingJobRequest::resourceKey)).setter(CreateEdgePackagingJobRequest.setter(Builder::resourceKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceKey").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateEdgePackagingJobRequest.getter(CreateEdgePackagingJobRequest::tags)).setter(CreateEdgePackagingJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDGE_PACKAGING_JOB_NAME_FIELD, COMPILATION_JOB_NAME_FIELD, MODEL_NAME_FIELD, MODEL_VERSION_FIELD, ROLE_ARN_FIELD, OUTPUT_CONFIG_FIELD, RESOURCE_KEY_FIELD, TAGS_FIELD));
    private final String edgePackagingJobName;
    private final String compilationJobName;
    private final String modelName;
    private final String modelVersion;
    private final String roleArn;
    private final EdgeOutputConfig outputConfig;
    private final String resourceKey;
    private final List<Tag> tags;

    private CreateEdgePackagingJobRequest(BuilderImpl builder) {
        super(builder);
        this.edgePackagingJobName = builder.edgePackagingJobName;
        this.compilationJobName = builder.compilationJobName;
        this.modelName = builder.modelName;
        this.modelVersion = builder.modelVersion;
        this.roleArn = builder.roleArn;
        this.outputConfig = builder.outputConfig;
        this.resourceKey = builder.resourceKey;
        this.tags = builder.tags;
    }

    public final String edgePackagingJobName() {
        return this.edgePackagingJobName;
    }

    public final String compilationJobName() {
        return this.compilationJobName;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String modelVersion() {
        return this.modelVersion;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final EdgeOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final String resourceKey() {
        return this.resourceKey;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.edgePackagingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEdgePackagingJobRequest)) {
            return false;
        }
        CreateEdgePackagingJobRequest other = (CreateEdgePackagingJobRequest)((Object)obj);
        return Objects.equals(this.edgePackagingJobName(), other.edgePackagingJobName()) && Objects.equals(this.compilationJobName(), other.compilationJobName()) && Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.modelVersion(), other.modelVersion()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.resourceKey(), other.resourceKey()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEdgePackagingJobRequest").add("EdgePackagingJobName", (Object)this.edgePackagingJobName()).add("CompilationJobName", (Object)this.compilationJobName()).add("ModelName", (Object)this.modelName()).add("ModelVersion", (Object)this.modelVersion()).add("RoleArn", (Object)this.roleArn()).add("OutputConfig", (Object)this.outputConfig()).add("ResourceKey", (Object)this.resourceKey()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EdgePackagingJobName": {
                return Optional.ofNullable(clazz.cast(this.edgePackagingJobName()));
            }
            case "CompilationJobName": {
                return Optional.ofNullable(clazz.cast(this.compilationJobName()));
            }
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "ModelVersion": {
                return Optional.ofNullable(clazz.cast(this.modelVersion()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "ResourceKey": {
                return Optional.ofNullable(clazz.cast(this.resourceKey()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEdgePackagingJobRequest, T> g) {
        return obj -> g.apply((CreateEdgePackagingJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String edgePackagingJobName;
        private String compilationJobName;
        private String modelName;
        private String modelVersion;
        private String roleArn;
        private EdgeOutputConfig outputConfig;
        private String resourceKey;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEdgePackagingJobRequest model) {
            super(model);
            this.edgePackagingJobName(model.edgePackagingJobName);
            this.compilationJobName(model.compilationJobName);
            this.modelName(model.modelName);
            this.modelVersion(model.modelVersion);
            this.roleArn(model.roleArn);
            this.outputConfig(model.outputConfig);
            this.resourceKey(model.resourceKey);
            this.tags(model.tags);
        }

        public final String getEdgePackagingJobName() {
            return this.edgePackagingJobName;
        }

        public final void setEdgePackagingJobName(String edgePackagingJobName) {
            this.edgePackagingJobName = edgePackagingJobName;
        }

        @Override
        @Transient
        public final Builder edgePackagingJobName(String edgePackagingJobName) {
            this.edgePackagingJobName = edgePackagingJobName;
            return this;
        }

        public final String getCompilationJobName() {
            return this.compilationJobName;
        }

        public final void setCompilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
        }

        @Override
        @Transient
        public final Builder compilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
            return this;
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        @Transient
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelVersion() {
            return this.modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        @Transient
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final EdgeOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(EdgeOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder outputConfig(EdgeOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final String getResourceKey() {
            return this.resourceKey;
        }

        public final void setResourceKey(String resourceKey) {
            this.resourceKey = resourceKey;
        }

        @Override
        @Transient
        public final Builder resourceKey(String resourceKey) {
            this.resourceKey = resourceKey;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEdgePackagingJobRequest build() {
            return new CreateEdgePackagingJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEdgePackagingJobRequest> {
        public Builder edgePackagingJobName(String var1);

        public Builder compilationJobName(String var1);

        public Builder modelName(String var1);

        public Builder modelVersion(String var1);

        public Builder roleArn(String var1);

        public Builder outputConfig(EdgeOutputConfig var1);

        default public Builder outputConfig(Consumer<EdgeOutputConfig.Builder> outputConfig) {
            return this.outputConfig((EdgeOutputConfig)((EdgeOutputConfig.Builder)EdgeOutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder resourceKey(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

