/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProductionVariantServerlessConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProductionVariantServerlessConfig> {
    private static final SdkField<Integer> MEMORY_SIZE_IN_MB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MemorySizeInMB").getter(ProductionVariantServerlessConfig.getter(ProductionVariantServerlessConfig::memorySizeInMB)).setter(ProductionVariantServerlessConfig.setter(Builder::memorySizeInMB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemorySizeInMB").build()}).build();
    private static final SdkField<Integer> MAX_CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxConcurrency").getter(ProductionVariantServerlessConfig.getter(ProductionVariantServerlessConfig::maxConcurrency)).setter(ProductionVariantServerlessConfig.setter(Builder::maxConcurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_SIZE_IN_MB_FIELD, MAX_CONCURRENCY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer memorySizeInMB;
    private final Integer maxConcurrency;

    private ProductionVariantServerlessConfig(BuilderImpl builder) {
        this.memorySizeInMB = builder.memorySizeInMB;
        this.maxConcurrency = builder.maxConcurrency;
    }

    public final Integer memorySizeInMB() {
        return this.memorySizeInMB;
    }

    public final Integer maxConcurrency() {
        return this.maxConcurrency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.memorySizeInMB());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrency());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductionVariantServerlessConfig)) {
            return false;
        }
        ProductionVariantServerlessConfig other = (ProductionVariantServerlessConfig)obj;
        return Objects.equals(this.memorySizeInMB(), other.memorySizeInMB()) && Objects.equals(this.maxConcurrency(), other.maxConcurrency());
    }

    public final String toString() {
        return ToString.builder((String)"ProductionVariantServerlessConfig").add("MemorySizeInMB", (Object)this.memorySizeInMB()).add("MaxConcurrency", (Object)this.maxConcurrency()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MemorySizeInMB": {
                return Optional.ofNullable(clazz.cast(this.memorySizeInMB()));
            }
            case "MaxConcurrency": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrency()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProductionVariantServerlessConfig, T> g) {
        return obj -> g.apply((ProductionVariantServerlessConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer memorySizeInMB;
        private Integer maxConcurrency;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductionVariantServerlessConfig model) {
            this.memorySizeInMB(model.memorySizeInMB);
            this.maxConcurrency(model.maxConcurrency);
        }

        public final Integer getMemorySizeInMB() {
            return this.memorySizeInMB;
        }

        public final void setMemorySizeInMB(Integer memorySizeInMB) {
            this.memorySizeInMB = memorySizeInMB;
        }

        @Override
        @Transient
        public final Builder memorySizeInMB(Integer memorySizeInMB) {
            this.memorySizeInMB = memorySizeInMB;
            return this;
        }

        public final Integer getMaxConcurrency() {
            return this.maxConcurrency;
        }

        public final void setMaxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        @Override
        @Transient
        public final Builder maxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public ProductionVariantServerlessConfig build() {
            return new ProductionVariantServerlessConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProductionVariantServerlessConfig> {
        public Builder memorySizeInMB(Integer var1);

        public Builder maxConcurrency(Integer var1);
    }
}

