/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the drift check explainability baselines that can be used when the model monitor is set using the model
 * package.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DriftCheckExplainability implements SdkPojo, Serializable,
        ToCopyableBuilder<DriftCheckExplainability.Builder, DriftCheckExplainability> {
    private static final SdkField<MetricsSource> CONSTRAINTS_FIELD = SdkField.<MetricsSource> builder(MarshallingType.SDK_POJO)
            .memberName("Constraints").getter(getter(DriftCheckExplainability::constraints)).setter(setter(Builder::constraints))
            .constructor(MetricsSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Constraints").build()).build();

    private static final SdkField<FileSource> CONFIG_FILE_FIELD = SdkField.<FileSource> builder(MarshallingType.SDK_POJO)
            .memberName("ConfigFile").getter(getter(DriftCheckExplainability::configFile)).setter(setter(Builder::configFile))
            .constructor(FileSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigFile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSTRAINTS_FIELD,
            CONFIG_FILE_FIELD));

    private static final long serialVersionUID = 1L;

    private final MetricsSource constraints;

    private final FileSource configFile;

    private DriftCheckExplainability(BuilderImpl builder) {
        this.constraints = builder.constraints;
        this.configFile = builder.configFile;
    }

    /**
     * Returns the value of the Constraints property for this object.
     * 
     * @return The value of the Constraints property for this object.
     */
    public final MetricsSource constraints() {
        return constraints;
    }

    /**
     * <p>
     * The explainability config file for the model.
     * </p>
     * 
     * @return The explainability config file for the model.
     */
    public final FileSource configFile() {
        return configFile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(constraints());
        hashCode = 31 * hashCode + Objects.hashCode(configFile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DriftCheckExplainability)) {
            return false;
        }
        DriftCheckExplainability other = (DriftCheckExplainability) obj;
        return Objects.equals(constraints(), other.constraints()) && Objects.equals(configFile(), other.configFile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DriftCheckExplainability").add("Constraints", constraints()).add("ConfigFile", configFile())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Constraints":
            return Optional.ofNullable(clazz.cast(constraints()));
        case "ConfigFile":
            return Optional.ofNullable(clazz.cast(configFile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DriftCheckExplainability, T> g) {
        return obj -> g.apply((DriftCheckExplainability) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DriftCheckExplainability> {
        /**
         * Sets the value of the Constraints property for this object.
         *
         * @param constraints
         *        The new value for the Constraints property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constraints(MetricsSource constraints);

        /**
         * Sets the value of the Constraints property for this object.
         *
         * This is a convenience that creates an instance of the {@link MetricsSource.Builder} avoiding the need to
         * create one manually via {@link MetricsSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetricsSource.Builder#build()} is called immediately and its
         * result is passed to {@link #constraints(MetricsSource)}.
         * 
         * @param constraints
         *        a consumer that will call methods on {@link MetricsSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #constraints(MetricsSource)
         */
        default Builder constraints(Consumer<MetricsSource.Builder> constraints) {
            return constraints(MetricsSource.builder().applyMutation(constraints).build());
        }

        /**
         * <p>
         * The explainability config file for the model.
         * </p>
         * 
         * @param configFile
         *        The explainability config file for the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configFile(FileSource configFile);

        /**
         * <p>
         * The explainability config file for the model.
         * </p>
         * This is a convenience that creates an instance of the {@link FileSource.Builder} avoiding the need to create
         * one manually via {@link FileSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link FileSource.Builder#build()} is called immediately and its result
         * is passed to {@link #configFile(FileSource)}.
         * 
         * @param configFile
         *        a consumer that will call methods on {@link FileSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configFile(FileSource)
         */
        default Builder configFile(Consumer<FileSource.Builder> configFile) {
            return configFile(FileSource.builder().applyMutation(configFile).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MetricsSource constraints;

        private FileSource configFile;

        private BuilderImpl() {
        }

        private BuilderImpl(DriftCheckExplainability model) {
            constraints(model.constraints);
            configFile(model.configFile);
        }

        public final MetricsSource.Builder getConstraints() {
            return constraints != null ? constraints.toBuilder() : null;
        }

        public final void setConstraints(MetricsSource.BuilderImpl constraints) {
            this.constraints = constraints != null ? constraints.build() : null;
        }

        @Override
        @Transient
        public final Builder constraints(MetricsSource constraints) {
            this.constraints = constraints;
            return this;
        }

        public final FileSource.Builder getConfigFile() {
            return configFile != null ? configFile.toBuilder() : null;
        }

        public final void setConfigFile(FileSource.BuilderImpl configFile) {
            this.configFile = configFile != null ? configFile.build() : null;
        }

        @Override
        @Transient
        public final Builder configFile(FileSource configFile) {
            this.configFile = configFile;
            return this;
        }

        @Override
        public DriftCheckExplainability build() {
            return new DriftCheckExplainability(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
