/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the validation and image scan statuses of the algorithm.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlgorithmStatusDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AlgorithmStatusDetails.Builder, AlgorithmStatusDetails> {
    private static final SdkField<List<AlgorithmStatusItem>> VALIDATION_STATUSES_FIELD = SdkField
            .<List<AlgorithmStatusItem>> builder(MarshallingType.LIST)
            .memberName("ValidationStatuses")
            .getter(getter(AlgorithmStatusDetails::validationStatuses))
            .setter(setter(Builder::validationStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AlgorithmStatusItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(AlgorithmStatusItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AlgorithmStatusItem>> IMAGE_SCAN_STATUSES_FIELD = SdkField
            .<List<AlgorithmStatusItem>> builder(MarshallingType.LIST)
            .memberName("ImageScanStatuses")
            .getter(getter(AlgorithmStatusDetails::imageScanStatuses))
            .setter(setter(Builder::imageScanStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageScanStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AlgorithmStatusItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(AlgorithmStatusItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_STATUSES_FIELD,
            IMAGE_SCAN_STATUSES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AlgorithmStatusItem> validationStatuses;

    private final List<AlgorithmStatusItem> imageScanStatuses;

    private AlgorithmStatusDetails(BuilderImpl builder) {
        this.validationStatuses = builder.validationStatuses;
        this.imageScanStatuses = builder.imageScanStatuses;
    }

    /**
     * For responses, this returns true if the service returned a value for the ValidationStatuses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasValidationStatuses() {
        return validationStatuses != null && !(validationStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status of algorithm validation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValidationStatuses} method.
     * </p>
     * 
     * @return The status of algorithm validation.
     */
    public final List<AlgorithmStatusItem> validationStatuses() {
        return validationStatuses;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImageScanStatuses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImageScanStatuses() {
        return imageScanStatuses != null && !(imageScanStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status of the scan of the algorithm's Docker image container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImageScanStatuses} method.
     * </p>
     * 
     * @return The status of the scan of the algorithm's Docker image container.
     */
    public final List<AlgorithmStatusItem> imageScanStatuses() {
        return imageScanStatuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasValidationStatuses() ? validationStatuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasImageScanStatuses() ? imageScanStatuses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlgorithmStatusDetails)) {
            return false;
        }
        AlgorithmStatusDetails other = (AlgorithmStatusDetails) obj;
        return hasValidationStatuses() == other.hasValidationStatuses()
                && Objects.equals(validationStatuses(), other.validationStatuses())
                && hasImageScanStatuses() == other.hasImageScanStatuses()
                && Objects.equals(imageScanStatuses(), other.imageScanStatuses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AlgorithmStatusDetails")
                .add("ValidationStatuses", hasValidationStatuses() ? validationStatuses() : null)
                .add("ImageScanStatuses", hasImageScanStatuses() ? imageScanStatuses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ValidationStatuses":
            return Optional.ofNullable(clazz.cast(validationStatuses()));
        case "ImageScanStatuses":
            return Optional.ofNullable(clazz.cast(imageScanStatuses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlgorithmStatusDetails, T> g) {
        return obj -> g.apply((AlgorithmStatusDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AlgorithmStatusDetails> {
        /**
         * <p>
         * The status of algorithm validation.
         * </p>
         * 
         * @param validationStatuses
         *        The status of algorithm validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationStatuses(Collection<AlgorithmStatusItem> validationStatuses);

        /**
         * <p>
         * The status of algorithm validation.
         * </p>
         * 
         * @param validationStatuses
         *        The status of algorithm validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationStatuses(AlgorithmStatusItem... validationStatuses);

        /**
         * <p>
         * The status of algorithm validation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AlgorithmStatusItem>.Builder} avoiding the
         * need to create one manually via {@link List<AlgorithmStatusItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AlgorithmStatusItem>.Builder#build()} is called immediately
         * and its result is passed to {@link #validationStatuses(List<AlgorithmStatusItem>)}.
         * 
         * @param validationStatuses
         *        a consumer that will call methods on {@link List<AlgorithmStatusItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationStatuses(List<AlgorithmStatusItem>)
         */
        Builder validationStatuses(Consumer<AlgorithmStatusItem.Builder>... validationStatuses);

        /**
         * <p>
         * The status of the scan of the algorithm's Docker image container.
         * </p>
         * 
         * @param imageScanStatuses
         *        The status of the scan of the algorithm's Docker image container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageScanStatuses(Collection<AlgorithmStatusItem> imageScanStatuses);

        /**
         * <p>
         * The status of the scan of the algorithm's Docker image container.
         * </p>
         * 
         * @param imageScanStatuses
         *        The status of the scan of the algorithm's Docker image container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageScanStatuses(AlgorithmStatusItem... imageScanStatuses);

        /**
         * <p>
         * The status of the scan of the algorithm's Docker image container.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AlgorithmStatusItem>.Builder} avoiding the
         * need to create one manually via {@link List<AlgorithmStatusItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AlgorithmStatusItem>.Builder#build()} is called immediately
         * and its result is passed to {@link #imageScanStatuses(List<AlgorithmStatusItem>)}.
         * 
         * @param imageScanStatuses
         *        a consumer that will call methods on {@link List<AlgorithmStatusItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageScanStatuses(List<AlgorithmStatusItem>)
         */
        Builder imageScanStatuses(Consumer<AlgorithmStatusItem.Builder>... imageScanStatuses);
    }

    static final class BuilderImpl implements Builder {
        private List<AlgorithmStatusItem> validationStatuses = DefaultSdkAutoConstructList.getInstance();

        private List<AlgorithmStatusItem> imageScanStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AlgorithmStatusDetails model) {
            validationStatuses(model.validationStatuses);
            imageScanStatuses(model.imageScanStatuses);
        }

        public final List<AlgorithmStatusItem.Builder> getValidationStatuses() {
            List<AlgorithmStatusItem.Builder> result = AlgorithmStatusItemListCopier.copyToBuilder(this.validationStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidationStatuses(Collection<AlgorithmStatusItem.BuilderImpl> validationStatuses) {
            this.validationStatuses = AlgorithmStatusItemListCopier.copyFromBuilder(validationStatuses);
        }

        @Override
        @Transient
        public final Builder validationStatuses(Collection<AlgorithmStatusItem> validationStatuses) {
            this.validationStatuses = AlgorithmStatusItemListCopier.copy(validationStatuses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder validationStatuses(AlgorithmStatusItem... validationStatuses) {
            validationStatuses(Arrays.asList(validationStatuses));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder validationStatuses(Consumer<AlgorithmStatusItem.Builder>... validationStatuses) {
            validationStatuses(Stream.of(validationStatuses).map(c -> AlgorithmStatusItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AlgorithmStatusItem.Builder> getImageScanStatuses() {
            List<AlgorithmStatusItem.Builder> result = AlgorithmStatusItemListCopier.copyToBuilder(this.imageScanStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageScanStatuses(Collection<AlgorithmStatusItem.BuilderImpl> imageScanStatuses) {
            this.imageScanStatuses = AlgorithmStatusItemListCopier.copyFromBuilder(imageScanStatuses);
        }

        @Override
        @Transient
        public final Builder imageScanStatuses(Collection<AlgorithmStatusItem> imageScanStatuses) {
            this.imageScanStatuses = AlgorithmStatusItemListCopier.copy(imageScanStatuses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder imageScanStatuses(AlgorithmStatusItem... imageScanStatuses) {
            imageScanStatuses(Arrays.asList(imageScanStatuses));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder imageScanStatuses(Consumer<AlgorithmStatusItem.Builder>... imageScanStatuses) {
            imageScanStatuses(Stream.of(imageScanStatuses).map(c -> AlgorithmStatusItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AlgorithmStatusDetails build() {
            return new AlgorithmStatusDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
