/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lists a summary of the properties of an artifact. An artifact represents a URI addressable object or data. Some
 * examples are a dataset and a model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArtifactSummary implements SdkPojo, Serializable, ToCopyableBuilder<ArtifactSummary.Builder, ArtifactSummary> {
    private static final SdkField<String> ARTIFACT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArtifactArn").getter(getter(ArtifactSummary::artifactArn)).setter(setter(Builder::artifactArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactArn").build()).build();

    private static final SdkField<String> ARTIFACT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArtifactName").getter(getter(ArtifactSummary::artifactName)).setter(setter(Builder::artifactName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactName").build()).build();

    private static final SdkField<ArtifactSource> SOURCE_FIELD = SdkField.<ArtifactSource> builder(MarshallingType.SDK_POJO)
            .memberName("Source").getter(getter(ArtifactSummary::source)).setter(setter(Builder::source))
            .constructor(ArtifactSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> ARTIFACT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArtifactType").getter(getter(ArtifactSummary::artifactType)).setter(setter(Builder::artifactType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactType").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ArtifactSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(ArtifactSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARTIFACT_ARN_FIELD,
            ARTIFACT_NAME_FIELD, SOURCE_FIELD, ARTIFACT_TYPE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String artifactArn;

    private final String artifactName;

    private final ArtifactSource source;

    private final String artifactType;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private ArtifactSummary(BuilderImpl builder) {
        this.artifactArn = builder.artifactArn;
        this.artifactName = builder.artifactName;
        this.source = builder.source;
        this.artifactType = builder.artifactType;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the artifact.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the artifact.
     */
    public final String artifactArn() {
        return artifactArn;
    }

    /**
     * <p>
     * The name of the artifact.
     * </p>
     * 
     * @return The name of the artifact.
     */
    public final String artifactName() {
        return artifactName;
    }

    /**
     * <p>
     * The source of the artifact.
     * </p>
     * 
     * @return The source of the artifact.
     */
    public final ArtifactSource source() {
        return source;
    }

    /**
     * <p>
     * The type of the artifact.
     * </p>
     * 
     * @return The type of the artifact.
     */
    public final String artifactType() {
        return artifactType;
    }

    /**
     * <p>
     * When the artifact was created.
     * </p>
     * 
     * @return When the artifact was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * When the artifact was last modified.
     * </p>
     * 
     * @return When the artifact was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(artifactArn());
        hashCode = 31 * hashCode + Objects.hashCode(artifactName());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(artifactType());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArtifactSummary)) {
            return false;
        }
        ArtifactSummary other = (ArtifactSummary) obj;
        return Objects.equals(artifactArn(), other.artifactArn()) && Objects.equals(artifactName(), other.artifactName())
                && Objects.equals(source(), other.source()) && Objects.equals(artifactType(), other.artifactType())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArtifactSummary").add("ArtifactArn", artifactArn()).add("ArtifactName", artifactName())
                .add("Source", source()).add("ArtifactType", artifactType()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArtifactArn":
            return Optional.ofNullable(clazz.cast(artifactArn()));
        case "ArtifactName":
            return Optional.ofNullable(clazz.cast(artifactName()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "ArtifactType":
            return Optional.ofNullable(clazz.cast(artifactType()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArtifactSummary, T> g) {
        return obj -> g.apply((ArtifactSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArtifactSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the artifact.
         * </p>
         * 
         * @param artifactArn
         *        The Amazon Resource Name (ARN) of the artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactArn(String artifactArn);

        /**
         * <p>
         * The name of the artifact.
         * </p>
         * 
         * @param artifactName
         *        The name of the artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactName(String artifactName);

        /**
         * <p>
         * The source of the artifact.
         * </p>
         * 
         * @param source
         *        The source of the artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(ArtifactSource source);

        /**
         * <p>
         * The source of the artifact.
         * </p>
         * This is a convenience that creates an instance of the {@link ArtifactSource.Builder} avoiding the need to
         * create one manually via {@link ArtifactSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link ArtifactSource.Builder#build()} is called immediately and its
         * result is passed to {@link #source(ArtifactSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link ArtifactSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(ArtifactSource)
         */
        default Builder source(Consumer<ArtifactSource.Builder> source) {
            return source(ArtifactSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The type of the artifact.
         * </p>
         * 
         * @param artifactType
         *        The type of the artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactType(String artifactType);

        /**
         * <p>
         * When the artifact was created.
         * </p>
         * 
         * @param creationTime
         *        When the artifact was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * When the artifact was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        When the artifact was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String artifactArn;

        private String artifactName;

        private ArtifactSource source;

        private String artifactType;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ArtifactSummary model) {
            artifactArn(model.artifactArn);
            artifactName(model.artifactName);
            source(model.source);
            artifactType(model.artifactType);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getArtifactArn() {
            return artifactArn;
        }

        public final void setArtifactArn(String artifactArn) {
            this.artifactArn = artifactArn;
        }

        @Override
        @Transient
        public final Builder artifactArn(String artifactArn) {
            this.artifactArn = artifactArn;
            return this;
        }

        public final String getArtifactName() {
            return artifactName;
        }

        public final void setArtifactName(String artifactName) {
            this.artifactName = artifactName;
        }

        @Override
        @Transient
        public final Builder artifactName(String artifactName) {
            this.artifactName = artifactName;
            return this;
        }

        public final ArtifactSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(ArtifactSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        @Transient
        public final Builder source(ArtifactSource source) {
            this.source = source;
            return this;
        }

        public final String getArtifactType() {
            return artifactType;
        }

        public final void setArtifactType(String artifactType) {
            this.artifactType = artifactType;
        }

        @Override
        @Transient
        public final Builder artifactType(String artifactType) {
            this.artifactType = artifactType;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public ArtifactSummary build() {
            return new ArtifactSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
