/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of continuous hyperparameters to tune.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContinuousParameterRange implements SdkPojo, Serializable,
        ToCopyableBuilder<ContinuousParameterRange.Builder, ContinuousParameterRange> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ContinuousParameterRange::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> MIN_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MinValue").getter(getter(ContinuousParameterRange::minValue)).setter(setter(Builder::minValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinValue").build()).build();

    private static final SdkField<String> MAX_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxValue").getter(getter(ContinuousParameterRange::maxValue)).setter(setter(Builder::maxValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxValue").build()).build();

    private static final SdkField<String> SCALING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScalingType").getter(getter(ContinuousParameterRange::scalingTypeAsString))
            .setter(setter(Builder::scalingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MIN_VALUE_FIELD,
            MAX_VALUE_FIELD, SCALING_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String minValue;

    private final String maxValue;

    private final String scalingType;

    private ContinuousParameterRange(BuilderImpl builder) {
        this.name = builder.name;
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
        this.scalingType = builder.scalingType;
    }

    /**
     * <p>
     * The name of the continuous hyperparameter to tune.
     * </p>
     * 
     * @return The name of the continuous hyperparameter to tune.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The minimum value for the hyperparameter. The tuning job uses floating-point values between this value and
     * <code>MaxValue</code>for tuning.
     * </p>
     * 
     * @return The minimum value for the hyperparameter. The tuning job uses floating-point values between this value
     *         and <code>MaxValue</code>for tuning.
     */
    public final String minValue() {
        return minValue;
    }

    /**
     * <p>
     * The maximum value for the hyperparameter. The tuning job uses floating-point values between <code>MinValue</code>
     * value and this value for tuning.
     * </p>
     * 
     * @return The maximum value for the hyperparameter. The tuning job uses floating-point values between
     *         <code>MinValue</code> value and this value for tuning.
     */
    public final String maxValue() {
        return maxValue;
    }

    /**
     * <p>
     * The scale that hyperparameter tuning uses to search the hyperparameter range. For information about choosing a
     * hyperparameter scale, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type"
     * >Hyperparameter Scaling</a>. One of the following values:
     * </p>
     * <dl>
     * <dt>Auto</dt>
     * <dd>
     * <p>
     * Amazon SageMaker hyperparameter tuning chooses the best scale for the hyperparameter.
     * </p>
     * </dd>
     * <dt>Linear</dt>
     * <dd>
     * <p>
     * Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.
     * </p>
     * </dd>
     * <dt>Logarithmic</dt>
     * <dd>
     * <p>
     * Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.
     * </p>
     * <p>
     * Logarithmic scaling works only for ranges that have only values greater than 0.
     * </p>
     * </dd>
     * <dt>ReverseLogarithmic</dt>
     * <dd>
     * <p>
     * Hyperparameter tuning searches the values in the hyperparameter range by using a reverse logarithmic scale.
     * </p>
     * <p>
     * Reverse logarithmic scaling works only for ranges that are entirely within the range 0&lt;=x&lt;1.0.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalingType} will
     * return {@link HyperParameterScalingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #scalingTypeAsString}.
     * </p>
     * 
     * @return The scale that hyperparameter tuning uses to search the hyperparameter range. For information about
     *         choosing a hyperparameter scale, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type"
     *         >Hyperparameter Scaling</a>. One of the following values:</p>
     *         <dl>
     *         <dt>Auto</dt>
     *         <dd>
     *         <p>
     *         Amazon SageMaker hyperparameter tuning chooses the best scale for the hyperparameter.
     *         </p>
     *         </dd>
     *         <dt>Linear</dt>
     *         <dd>
     *         <p>
     *         Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.
     *         </p>
     *         </dd>
     *         <dt>Logarithmic</dt>
     *         <dd>
     *         <p>
     *         Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.
     *         </p>
     *         <p>
     *         Logarithmic scaling works only for ranges that have only values greater than 0.
     *         </p>
     *         </dd>
     *         <dt>ReverseLogarithmic</dt>
     *         <dd>
     *         <p>
     *         Hyperparameter tuning searches the values in the hyperparameter range by using a reverse logarithmic
     *         scale.
     *         </p>
     *         <p>
     *         Reverse logarithmic scaling works only for ranges that are entirely within the range 0&lt;=x&lt;1.0.
     *         </p>
     *         </dd>
     * @see HyperParameterScalingType
     */
    public final HyperParameterScalingType scalingType() {
        return HyperParameterScalingType.fromValue(scalingType);
    }

    /**
     * <p>
     * The scale that hyperparameter tuning uses to search the hyperparameter range. For information about choosing a
     * hyperparameter scale, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type"
     * >Hyperparameter Scaling</a>. One of the following values:
     * </p>
     * <dl>
     * <dt>Auto</dt>
     * <dd>
     * <p>
     * Amazon SageMaker hyperparameter tuning chooses the best scale for the hyperparameter.
     * </p>
     * </dd>
     * <dt>Linear</dt>
     * <dd>
     * <p>
     * Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.
     * </p>
     * </dd>
     * <dt>Logarithmic</dt>
     * <dd>
     * <p>
     * Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.
     * </p>
     * <p>
     * Logarithmic scaling works only for ranges that have only values greater than 0.
     * </p>
     * </dd>
     * <dt>ReverseLogarithmic</dt>
     * <dd>
     * <p>
     * Hyperparameter tuning searches the values in the hyperparameter range by using a reverse logarithmic scale.
     * </p>
     * <p>
     * Reverse logarithmic scaling works only for ranges that are entirely within the range 0&lt;=x&lt;1.0.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalingType} will
     * return {@link HyperParameterScalingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #scalingTypeAsString}.
     * </p>
     * 
     * @return The scale that hyperparameter tuning uses to search the hyperparameter range. For information about
     *         choosing a hyperparameter scale, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type"
     *         >Hyperparameter Scaling</a>. One of the following values:</p>
     *         <dl>
     *         <dt>Auto</dt>
     *         <dd>
     *         <p>
     *         Amazon SageMaker hyperparameter tuning chooses the best scale for the hyperparameter.
     *         </p>
     *         </dd>
     *         <dt>Linear</dt>
     *         <dd>
     *         <p>
     *         Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.
     *         </p>
     *         </dd>
     *         <dt>Logarithmic</dt>
     *         <dd>
     *         <p>
     *         Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.
     *         </p>
     *         <p>
     *         Logarithmic scaling works only for ranges that have only values greater than 0.
     *         </p>
     *         </dd>
     *         <dt>ReverseLogarithmic</dt>
     *         <dd>
     *         <p>
     *         Hyperparameter tuning searches the values in the hyperparameter range by using a reverse logarithmic
     *         scale.
     *         </p>
     *         <p>
     *         Reverse logarithmic scaling works only for ranges that are entirely within the range 0&lt;=x&lt;1.0.
     *         </p>
     *         </dd>
     * @see HyperParameterScalingType
     */
    public final String scalingTypeAsString() {
        return scalingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(minValue());
        hashCode = 31 * hashCode + Objects.hashCode(maxValue());
        hashCode = 31 * hashCode + Objects.hashCode(scalingTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContinuousParameterRange)) {
            return false;
        }
        ContinuousParameterRange other = (ContinuousParameterRange) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(minValue(), other.minValue())
                && Objects.equals(maxValue(), other.maxValue())
                && Objects.equals(scalingTypeAsString(), other.scalingTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContinuousParameterRange").add("Name", name()).add("MinValue", minValue())
                .add("MaxValue", maxValue()).add("ScalingType", scalingTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "MinValue":
            return Optional.ofNullable(clazz.cast(minValue()));
        case "MaxValue":
            return Optional.ofNullable(clazz.cast(maxValue()));
        case "ScalingType":
            return Optional.ofNullable(clazz.cast(scalingTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContinuousParameterRange, T> g) {
        return obj -> g.apply((ContinuousParameterRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContinuousParameterRange> {
        /**
         * <p>
         * The name of the continuous hyperparameter to tune.
         * </p>
         * 
         * @param name
         *        The name of the continuous hyperparameter to tune.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The minimum value for the hyperparameter. The tuning job uses floating-point values between this value and
         * <code>MaxValue</code>for tuning.
         * </p>
         * 
         * @param minValue
         *        The minimum value for the hyperparameter. The tuning job uses floating-point values between this value
         *        and <code>MaxValue</code>for tuning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minValue(String minValue);

        /**
         * <p>
         * The maximum value for the hyperparameter. The tuning job uses floating-point values between
         * <code>MinValue</code> value and this value for tuning.
         * </p>
         * 
         * @param maxValue
         *        The maximum value for the hyperparameter. The tuning job uses floating-point values between
         *        <code>MinValue</code> value and this value for tuning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxValue(String maxValue);

        /**
         * <p>
         * The scale that hyperparameter tuning uses to search the hyperparameter range. For information about choosing
         * a hyperparameter scale, see <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type"
         * >Hyperparameter Scaling</a>. One of the following values:
         * </p>
         * <dl>
         * <dt>Auto</dt>
         * <dd>
         * <p>
         * Amazon SageMaker hyperparameter tuning chooses the best scale for the hyperparameter.
         * </p>
         * </dd>
         * <dt>Linear</dt>
         * <dd>
         * <p>
         * Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.
         * </p>
         * </dd>
         * <dt>Logarithmic</dt>
         * <dd>
         * <p>
         * Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.
         * </p>
         * <p>
         * Logarithmic scaling works only for ranges that have only values greater than 0.
         * </p>
         * </dd>
         * <dt>ReverseLogarithmic</dt>
         * <dd>
         * <p>
         * Hyperparameter tuning searches the values in the hyperparameter range by using a reverse logarithmic scale.
         * </p>
         * <p>
         * Reverse logarithmic scaling works only for ranges that are entirely within the range 0&lt;=x&lt;1.0.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param scalingType
         *        The scale that hyperparameter tuning uses to search the hyperparameter range. For information about
         *        choosing a hyperparameter scale, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type"
         *        >Hyperparameter Scaling</a>. One of the following values:</p>
         *        <dl>
         *        <dt>Auto</dt>
         *        <dd>
         *        <p>
         *        Amazon SageMaker hyperparameter tuning chooses the best scale for the hyperparameter.
         *        </p>
         *        </dd>
         *        <dt>Linear</dt>
         *        <dd>
         *        <p>
         *        Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.
         *        </p>
         *        </dd>
         *        <dt>Logarithmic</dt>
         *        <dd>
         *        <p>
         *        Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.
         *        </p>
         *        <p>
         *        Logarithmic scaling works only for ranges that have only values greater than 0.
         *        </p>
         *        </dd>
         *        <dt>ReverseLogarithmic</dt>
         *        <dd>
         *        <p>
         *        Hyperparameter tuning searches the values in the hyperparameter range by using a reverse logarithmic
         *        scale.
         *        </p>
         *        <p>
         *        Reverse logarithmic scaling works only for ranges that are entirely within the range 0&lt;=x&lt;1.0.
         *        </p>
         *        </dd>
         * @see HyperParameterScalingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HyperParameterScalingType
         */
        Builder scalingType(String scalingType);

        /**
         * <p>
         * The scale that hyperparameter tuning uses to search the hyperparameter range. For information about choosing
         * a hyperparameter scale, see <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type"
         * >Hyperparameter Scaling</a>. One of the following values:
         * </p>
         * <dl>
         * <dt>Auto</dt>
         * <dd>
         * <p>
         * Amazon SageMaker hyperparameter tuning chooses the best scale for the hyperparameter.
         * </p>
         * </dd>
         * <dt>Linear</dt>
         * <dd>
         * <p>
         * Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.
         * </p>
         * </dd>
         * <dt>Logarithmic</dt>
         * <dd>
         * <p>
         * Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.
         * </p>
         * <p>
         * Logarithmic scaling works only for ranges that have only values greater than 0.
         * </p>
         * </dd>
         * <dt>ReverseLogarithmic</dt>
         * <dd>
         * <p>
         * Hyperparameter tuning searches the values in the hyperparameter range by using a reverse logarithmic scale.
         * </p>
         * <p>
         * Reverse logarithmic scaling works only for ranges that are entirely within the range 0&lt;=x&lt;1.0.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param scalingType
         *        The scale that hyperparameter tuning uses to search the hyperparameter range. For information about
         *        choosing a hyperparameter scale, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type"
         *        >Hyperparameter Scaling</a>. One of the following values:</p>
         *        <dl>
         *        <dt>Auto</dt>
         *        <dd>
         *        <p>
         *        Amazon SageMaker hyperparameter tuning chooses the best scale for the hyperparameter.
         *        </p>
         *        </dd>
         *        <dt>Linear</dt>
         *        <dd>
         *        <p>
         *        Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.
         *        </p>
         *        </dd>
         *        <dt>Logarithmic</dt>
         *        <dd>
         *        <p>
         *        Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.
         *        </p>
         *        <p>
         *        Logarithmic scaling works only for ranges that have only values greater than 0.
         *        </p>
         *        </dd>
         *        <dt>ReverseLogarithmic</dt>
         *        <dd>
         *        <p>
         *        Hyperparameter tuning searches the values in the hyperparameter range by using a reverse logarithmic
         *        scale.
         *        </p>
         *        <p>
         *        Reverse logarithmic scaling works only for ranges that are entirely within the range 0&lt;=x&lt;1.0.
         *        </p>
         *        </dd>
         * @see HyperParameterScalingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HyperParameterScalingType
         */
        Builder scalingType(HyperParameterScalingType scalingType);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String minValue;

        private String maxValue;

        private String scalingType;

        private BuilderImpl() {
        }

        private BuilderImpl(ContinuousParameterRange model) {
            name(model.name);
            minValue(model.minValue);
            maxValue(model.maxValue);
            scalingType(model.scalingType);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getMinValue() {
            return minValue;
        }

        public final void setMinValue(String minValue) {
            this.minValue = minValue;
        }

        @Override
        @Transient
        public final Builder minValue(String minValue) {
            this.minValue = minValue;
            return this;
        }

        public final String getMaxValue() {
            return maxValue;
        }

        public final void setMaxValue(String maxValue) {
            this.maxValue = maxValue;
        }

        @Override
        @Transient
        public final Builder maxValue(String maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public final String getScalingType() {
            return scalingType;
        }

        public final void setScalingType(String scalingType) {
            this.scalingType = scalingType;
        }

        @Override
        @Transient
        public final Builder scalingType(String scalingType) {
            this.scalingType = scalingType;
            return this;
        }

        @Override
        @Transient
        public final Builder scalingType(HyperParameterScalingType scalingType) {
            this.scalingType(scalingType == null ? null : scalingType.toString());
            return this;
        }

        @Override
        public ContinuousParameterRange build() {
            return new ContinuousParameterRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
