/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateArtifactRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateArtifactRequest.Builder, CreateArtifactRequest> {
    private static final SdkField<String> ARTIFACT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArtifactName").getter(getter(CreateArtifactRequest::artifactName)).setter(setter(Builder::artifactName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactName").build()).build();

    private static final SdkField<ArtifactSource> SOURCE_FIELD = SdkField.<ArtifactSource> builder(MarshallingType.SDK_POJO)
            .memberName("Source").getter(getter(CreateArtifactRequest::source)).setter(setter(Builder::source))
            .constructor(ArtifactSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> ARTIFACT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArtifactType").getter(getter(CreateArtifactRequest::artifactType)).setter(setter(Builder::artifactType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactType").build()).build();

    private static final SdkField<Map<String, String>> PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Properties")
            .getter(getter(CreateArtifactRequest::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<MetadataProperties> METADATA_PROPERTIES_FIELD = SdkField
            .<MetadataProperties> builder(MarshallingType.SDK_POJO).memberName("MetadataProperties")
            .getter(getter(CreateArtifactRequest::metadataProperties)).setter(setter(Builder::metadataProperties))
            .constructor(MetadataProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataProperties").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateArtifactRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARTIFACT_NAME_FIELD,
            SOURCE_FIELD, ARTIFACT_TYPE_FIELD, PROPERTIES_FIELD, METADATA_PROPERTIES_FIELD, TAGS_FIELD));

    private final String artifactName;

    private final ArtifactSource source;

    private final String artifactType;

    private final Map<String, String> properties;

    private final MetadataProperties metadataProperties;

    private final List<Tag> tags;

    private CreateArtifactRequest(BuilderImpl builder) {
        super(builder);
        this.artifactName = builder.artifactName;
        this.source = builder.source;
        this.artifactType = builder.artifactType;
        this.properties = builder.properties;
        this.metadataProperties = builder.metadataProperties;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the artifact. Must be unique to your account in an Amazon Web Services Region.
     * </p>
     * 
     * @return The name of the artifact. Must be unique to your account in an Amazon Web Services Region.
     */
    public final String artifactName() {
        return artifactName;
    }

    /**
     * <p>
     * The ID, ID type, and URI of the source.
     * </p>
     * 
     * @return The ID, ID type, and URI of the source.
     */
    public final ArtifactSource source() {
        return source;
    }

    /**
     * <p>
     * The artifact type.
     * </p>
     * 
     * @return The artifact type.
     */
    public final String artifactType() {
        return artifactType;
    }

    /**
     * Returns true if the Properties property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of properties to add to the artifact.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProperties()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of properties to add to the artifact.
     */
    public final Map<String, String> properties() {
        return properties;
    }

    /**
     * Returns the value of the MetadataProperties property for this object.
     * 
     * @return The value of the MetadataProperties property for this object.
     */
    public final MetadataProperties metadataProperties() {
        return metadataProperties;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags to apply to the artifact.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tags to apply to the artifact.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(artifactName());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(artifactType());
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(metadataProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateArtifactRequest)) {
            return false;
        }
        CreateArtifactRequest other = (CreateArtifactRequest) obj;
        return Objects.equals(artifactName(), other.artifactName()) && Objects.equals(source(), other.source())
                && Objects.equals(artifactType(), other.artifactType()) && hasProperties() == other.hasProperties()
                && Objects.equals(properties(), other.properties())
                && Objects.equals(metadataProperties(), other.metadataProperties()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateArtifactRequest").add("ArtifactName", artifactName()).add("Source", source())
                .add("ArtifactType", artifactType()).add("Properties", hasProperties() ? properties() : null)
                .add("MetadataProperties", metadataProperties()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArtifactName":
            return Optional.ofNullable(clazz.cast(artifactName()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "ArtifactType":
            return Optional.ofNullable(clazz.cast(artifactType()));
        case "Properties":
            return Optional.ofNullable(clazz.cast(properties()));
        case "MetadataProperties":
            return Optional.ofNullable(clazz.cast(metadataProperties()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateArtifactRequest, T> g) {
        return obj -> g.apply((CreateArtifactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateArtifactRequest> {
        /**
         * <p>
         * The name of the artifact. Must be unique to your account in an Amazon Web Services Region.
         * </p>
         * 
         * @param artifactName
         *        The name of the artifact. Must be unique to your account in an Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactName(String artifactName);

        /**
         * <p>
         * The ID, ID type, and URI of the source.
         * </p>
         * 
         * @param source
         *        The ID, ID type, and URI of the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(ArtifactSource source);

        /**
         * <p>
         * The ID, ID type, and URI of the source.
         * </p>
         * This is a convenience that creates an instance of the {@link ArtifactSource.Builder} avoiding the need to
         * create one manually via {@link ArtifactSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link ArtifactSource.Builder#build()} is called immediately and its
         * result is passed to {@link #source(ArtifactSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link ArtifactSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(ArtifactSource)
         */
        default Builder source(Consumer<ArtifactSource.Builder> source) {
            return source(ArtifactSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The artifact type.
         * </p>
         * 
         * @param artifactType
         *        The artifact type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactType(String artifactType);

        /**
         * <p>
         * A list of properties to add to the artifact.
         * </p>
         * 
         * @param properties
         *        A list of properties to add to the artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Map<String, String> properties);

        /**
         * Sets the value of the MetadataProperties property for this object.
         *
         * @param metadataProperties
         *        The new value for the MetadataProperties property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataProperties(MetadataProperties metadataProperties);

        /**
         * Sets the value of the MetadataProperties property for this object.
         *
         * This is a convenience that creates an instance of the {@link MetadataProperties.Builder} avoiding the need to
         * create one manually via {@link MetadataProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetadataProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #metadataProperties(MetadataProperties)}.
         * 
         * @param metadataProperties
         *        a consumer that will call methods on {@link MetadataProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataProperties(MetadataProperties)
         */
        default Builder metadataProperties(Consumer<MetadataProperties.Builder> metadataProperties) {
            return metadataProperties(MetadataProperties.builder().applyMutation(metadataProperties).build());
        }

        /**
         * <p>
         * A list of tags to apply to the artifact.
         * </p>
         * 
         * @param tags
         *        A list of tags to apply to the artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags to apply to the artifact.
         * </p>
         * 
         * @param tags
         *        A list of tags to apply to the artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags to apply to the artifact.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String artifactName;

        private ArtifactSource source;

        private String artifactType;

        private Map<String, String> properties = DefaultSdkAutoConstructMap.getInstance();

        private MetadataProperties metadataProperties;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateArtifactRequest model) {
            super(model);
            artifactName(model.artifactName);
            source(model.source);
            artifactType(model.artifactType);
            properties(model.properties);
            metadataProperties(model.metadataProperties);
            tags(model.tags);
        }

        public final String getArtifactName() {
            return artifactName;
        }

        public final void setArtifactName(String artifactName) {
            this.artifactName = artifactName;
        }

        @Override
        @Transient
        public final Builder artifactName(String artifactName) {
            this.artifactName = artifactName;
            return this;
        }

        public final ArtifactSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(ArtifactSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        @Transient
        public final Builder source(ArtifactSource source) {
            this.source = source;
            return this;
        }

        public final String getArtifactType() {
            return artifactType;
        }

        public final void setArtifactType(String artifactType) {
            this.artifactType = artifactType;
        }

        @Override
        @Transient
        public final Builder artifactType(String artifactType) {
            this.artifactType = artifactType;
            return this;
        }

        public final Map<String, String> getProperties() {
            if (properties instanceof SdkAutoConstructMap) {
                return null;
            }
            return properties;
        }

        public final void setProperties(Map<String, String> properties) {
            this.properties = LineageEntityParametersCopier.copy(properties);
        }

        @Override
        @Transient
        public final Builder properties(Map<String, String> properties) {
            this.properties = LineageEntityParametersCopier.copy(properties);
            return this;
        }

        public final MetadataProperties.Builder getMetadataProperties() {
            return metadataProperties != null ? metadataProperties.toBuilder() : null;
        }

        public final void setMetadataProperties(MetadataProperties.BuilderImpl metadataProperties) {
            this.metadataProperties = metadataProperties != null ? metadataProperties.build() : null;
        }

        @Override
        @Transient
        public final Builder metadataProperties(MetadataProperties metadataProperties) {
            this.metadataProperties = metadataProperties;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateArtifactRequest build() {
            return new CreateArtifactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
