/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNotebookInstanceRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateNotebookInstanceRequest.Builder, CreateNotebookInstanceRequest> {
    private static final SdkField<String> NOTEBOOK_INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotebookInstanceName").getter(getter(CreateNotebookInstanceRequest::notebookInstanceName))
            .setter(setter(Builder::notebookInstanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceName").build())
            .build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(CreateNotebookInstanceRequest::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(CreateNotebookInstanceRequest::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(CreateNotebookInstanceRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateNotebookInstanceRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CreateNotebookInstanceRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateNotebookInstanceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LIFECYCLE_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LifecycleConfigName").getter(getter(CreateNotebookInstanceRequest::lifecycleConfigName))
            .setter(setter(Builder::lifecycleConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleConfigName").build())
            .build();

    private static final SdkField<String> DIRECT_INTERNET_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectInternetAccess").getter(getter(CreateNotebookInstanceRequest::directInternetAccessAsString))
            .setter(setter(Builder::directInternetAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectInternetAccess").build())
            .build();

    private static final SdkField<Integer> VOLUME_SIZE_IN_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VolumeSizeInGB").getter(getter(CreateNotebookInstanceRequest::volumeSizeInGB))
            .setter(setter(Builder::volumeSizeInGB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSizeInGB").build()).build();

    private static final SdkField<List<String>> ACCELERATOR_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AcceleratorTypes")
            .getter(getter(CreateNotebookInstanceRequest::acceleratorTypesAsStrings))
            .setter(setter(Builder::acceleratorTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_CODE_REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultCodeRepository").getter(getter(CreateNotebookInstanceRequest::defaultCodeRepository))
            .setter(setter(Builder::defaultCodeRepository))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCodeRepository").build())
            .build();

    private static final SdkField<List<String>> ADDITIONAL_CODE_REPOSITORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdditionalCodeRepositories")
            .getter(getter(CreateNotebookInstanceRequest::additionalCodeRepositories))
            .setter(setter(Builder::additionalCodeRepositories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalCodeRepositories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROOT_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RootAccess").getter(getter(CreateNotebookInstanceRequest::rootAccessAsString))
            .setter(setter(Builder::rootAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootAccess").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_INSTANCE_NAME_FIELD,
            INSTANCE_TYPE_FIELD, SUBNET_ID_FIELD, SECURITY_GROUP_IDS_FIELD, ROLE_ARN_FIELD, KMS_KEY_ID_FIELD, TAGS_FIELD,
            LIFECYCLE_CONFIG_NAME_FIELD, DIRECT_INTERNET_ACCESS_FIELD, VOLUME_SIZE_IN_GB_FIELD, ACCELERATOR_TYPES_FIELD,
            DEFAULT_CODE_REPOSITORY_FIELD, ADDITIONAL_CODE_REPOSITORIES_FIELD, ROOT_ACCESS_FIELD));

    private final String notebookInstanceName;

    private final String instanceType;

    private final String subnetId;

    private final List<String> securityGroupIds;

    private final String roleArn;

    private final String kmsKeyId;

    private final List<Tag> tags;

    private final String lifecycleConfigName;

    private final String directInternetAccess;

    private final Integer volumeSizeInGB;

    private final List<String> acceleratorTypes;

    private final String defaultCodeRepository;

    private final List<String> additionalCodeRepositories;

    private final String rootAccess;

    private CreateNotebookInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.notebookInstanceName = builder.notebookInstanceName;
        this.instanceType = builder.instanceType;
        this.subnetId = builder.subnetId;
        this.securityGroupIds = builder.securityGroupIds;
        this.roleArn = builder.roleArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.tags = builder.tags;
        this.lifecycleConfigName = builder.lifecycleConfigName;
        this.directInternetAccess = builder.directInternetAccess;
        this.volumeSizeInGB = builder.volumeSizeInGB;
        this.acceleratorTypes = builder.acceleratorTypes;
        this.defaultCodeRepository = builder.defaultCodeRepository;
        this.additionalCodeRepositories = builder.additionalCodeRepositories;
        this.rootAccess = builder.rootAccess;
    }

    /**
     * <p>
     * The name of the new notebook instance.
     * </p>
     * 
     * @return The name of the new notebook instance.
     */
    public final String notebookInstanceName() {
        return notebookInstanceName;
    }

    /**
     * <p>
     * The type of ML compute instance to launch for the notebook instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The type of ML compute instance to launch for the notebook instance.
     * @see InstanceType
     */
    public final InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The type of ML compute instance to launch for the notebook instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The type of ML compute instance to launch for the notebook instance.
     * @see InstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The ID of the subnet in a VPC to which you would like to have a connectivity from your ML compute instance.
     * </p>
     * 
     * @return The ID of the subnet in a VPC to which you would like to have a connectivity from your ML compute
     *         instance.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * Returns true if the SecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The VPC security group IDs, in the form sg-xxxxxxxx. The security groups must be for the same VPC as specified in
     * the subnet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The VPC security group IDs, in the form sg-xxxxxxxx. The security groups must be for the same VPC as
     *         specified in the subnet.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * When you send any requests to Amazon Web Services resources from the notebook instance, Amazon SageMaker assumes
     * this role to perform tasks on your behalf. You must grant this role necessary permissions so Amazon SageMaker can
     * perform these tasks. The policy must allow the Amazon SageMaker service principal (sagemaker.amazonaws.com)
     * permissions to assume this role. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>.
     * </p>
     * <note>
     * <p>
     * To be able to pass this role to Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code>
     * permission.
     * </p>
     * </note>
     * 
     * @return When you send any requests to Amazon Web Services resources from the notebook instance, Amazon SageMaker
     *         assumes this role to perform tasks on your behalf. You must grant this role necessary permissions so
     *         Amazon SageMaker can perform these tasks. The policy must allow the Amazon SageMaker service principal
     *         (sagemaker.amazonaws.com) permissions to assume this role. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>.
     *         </p> <note>
     *         <p>
     *         To be able to pass this role to Amazon SageMaker, the caller of this API must have the
     *         <code>iam:PassRole</code> permission.
     *         </p>
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that Amazon SageMaker uses to
     * encrypt data on the storage volume attached to your notebook instance. The KMS key you provide must be enabled.
     * For information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html">Enabling
     * and Disabling Keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that Amazon SageMaker
     *         uses to encrypt data on the storage volume attached to your notebook instance. The KMS key you provide
     *         must be enabled. For information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html">Enabling and Disabling
     *         Keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways,
     * for example, by purpose, owner, or environment. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
     *         different ways, for example, by purpose, owner, or environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         Resources</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The name of a lifecycle configuration to associate with the notebook instance. For information about lifestyle
     * configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step
     * 2.1: (Optional) Customize a Notebook Instance</a>.
     * </p>
     * 
     * @return The name of a lifecycle configuration to associate with the notebook instance. For information about
     *         lifestyle configurations, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1:
     *         (Optional) Customize a Notebook Instance</a>.
     */
    public final String lifecycleConfigName() {
        return lifecycleConfigName;
    }

    /**
     * <p>
     * Sets whether Amazon SageMaker provides internet access to the notebook instance. If you set this to
     * <code>Disabled</code> this notebook instance is able to access resources only in your VPC, and is not be able to
     * connect to Amazon SageMaker training and endpoint services unless you configure a NAT Gateway in your VPC.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
     * >Notebook Instances Are Internet-Enabled by Default</a>. You can set the value of this parameter to
     * <code>Disabled</code> only if you set a value for the <code>SubnetId</code> parameter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #directInternetAccess} will return {@link DirectInternetAccess#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #directInternetAccessAsString}.
     * </p>
     * 
     * @return Sets whether Amazon SageMaker provides internet access to the notebook instance. If you set this to
     *         <code>Disabled</code> this notebook instance is able to access resources only in your VPC, and is not be
     *         able to connect to Amazon SageMaker training and endpoint services unless you configure a NAT Gateway in
     *         your VPC.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
     *         >Notebook Instances Are Internet-Enabled by Default</a>. You can set the value of this parameter to
     *         <code>Disabled</code> only if you set a value for the <code>SubnetId</code> parameter.
     * @see DirectInternetAccess
     */
    public final DirectInternetAccess directInternetAccess() {
        return DirectInternetAccess.fromValue(directInternetAccess);
    }

    /**
     * <p>
     * Sets whether Amazon SageMaker provides internet access to the notebook instance. If you set this to
     * <code>Disabled</code> this notebook instance is able to access resources only in your VPC, and is not be able to
     * connect to Amazon SageMaker training and endpoint services unless you configure a NAT Gateway in your VPC.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
     * >Notebook Instances Are Internet-Enabled by Default</a>. You can set the value of this parameter to
     * <code>Disabled</code> only if you set a value for the <code>SubnetId</code> parameter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #directInternetAccess} will return {@link DirectInternetAccess#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #directInternetAccessAsString}.
     * </p>
     * 
     * @return Sets whether Amazon SageMaker provides internet access to the notebook instance. If you set this to
     *         <code>Disabled</code> this notebook instance is able to access resources only in your VPC, and is not be
     *         able to connect to Amazon SageMaker training and endpoint services unless you configure a NAT Gateway in
     *         your VPC.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
     *         >Notebook Instances Are Internet-Enabled by Default</a>. You can set the value of this parameter to
     *         <code>Disabled</code> only if you set a value for the <code>SubnetId</code> parameter.
     * @see DirectInternetAccess
     */
    public final String directInternetAccessAsString() {
        return directInternetAccess;
    }

    /**
     * <p>
     * The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5 GB.
     * </p>
     * 
     * @return The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5 GB.
     */
    public final Integer volumeSizeInGB() {
        return volumeSizeInGB;
    }

    /**
     * <p>
     * A list of Elastic Inference (EI) instance types to associate with this notebook instance. Currently, only one
     * instance type can be associated with a notebook instance. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAcceleratorTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of Elastic Inference (EI) instance types to associate with this notebook instance. Currently, only
     *         one instance type can be associated with a notebook instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
     *         SageMaker</a>.
     */
    public final List<NotebookInstanceAcceleratorType> acceleratorTypes() {
        return NotebookInstanceAcceleratorTypesCopier.copyStringToEnum(acceleratorTypes);
    }

    /**
     * Returns true if the AcceleratorTypes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAcceleratorTypes() {
        return acceleratorTypes != null && !(acceleratorTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Elastic Inference (EI) instance types to associate with this notebook instance. Currently, only one
     * instance type can be associated with a notebook instance. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAcceleratorTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of Elastic Inference (EI) instance types to associate with this notebook instance. Currently, only
     *         one instance type can be associated with a notebook instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
     *         SageMaker</a>.
     */
    public final List<String> acceleratorTypesAsStrings() {
        return acceleratorTypes;
    }

    /**
     * <p>
     * A Git repository to associate with the notebook instance as its default code repository. This can be either the
     * name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or
     * in any other Git repository. When you open a notebook instance, it opens in the directory that contains this
     * repository. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon
     * SageMaker Notebook Instances</a>.
     * </p>
     * 
     * @return A Git repository to associate with the notebook instance as its default code repository. This can be
     *         either the name of a Git repository stored as a resource in your account, or the URL of a Git repository
     *         in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services
     *         CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the
     *         directory that contains this repository. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories
     *         with Amazon SageMaker Notebook Instances</a>.
     */
    public final String defaultCodeRepository() {
        return defaultCodeRepository;
    }

    /**
     * Returns true if the AdditionalCodeRepositories property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasAdditionalCodeRepositories() {
        return additionalCodeRepositories != null && !(additionalCodeRepositories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of up to three Git repositories to associate with the notebook instance. These can be either the names
     * of Git repositories stored as resources in your account, or the URL of Git repositories in <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or
     * in any other Git repository. These repositories are cloned at the same level as the default repository of your
     * notebook instance. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon
     * SageMaker Notebook Instances</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdditionalCodeRepositories()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of up to three Git repositories to associate with the notebook instance. These can be either the
     *         names of Git repositories stored as resources in your account, or the URL of Git repositories in <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services
     *         CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the
     *         default repository of your notebook instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories
     *         with Amazon SageMaker Notebook Instances</a>.
     */
    public final List<String> additionalCodeRepositories() {
        return additionalCodeRepositories;
    }

    /**
     * <p>
     * Whether root access is enabled or disabled for users of the notebook instance. The default value is
     * <code>Enabled</code>.
     * </p>
     * <note>
     * <p>
     * Lifecycle configurations need root access to be able to set up a notebook instance. Because of this, lifecycle
     * configurations associated with a notebook instance always run with root access even if you disable root access
     * for users.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rootAccess} will
     * return {@link RootAccess#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rootAccessAsString}.
     * </p>
     * 
     * @return Whether root access is enabled or disabled for users of the notebook instance. The default value is
     *         <code>Enabled</code>.</p> <note>
     *         <p>
     *         Lifecycle configurations need root access to be able to set up a notebook instance. Because of this,
     *         lifecycle configurations associated with a notebook instance always run with root access even if you
     *         disable root access for users.
     *         </p>
     * @see RootAccess
     */
    public final RootAccess rootAccess() {
        return RootAccess.fromValue(rootAccess);
    }

    /**
     * <p>
     * Whether root access is enabled or disabled for users of the notebook instance. The default value is
     * <code>Enabled</code>.
     * </p>
     * <note>
     * <p>
     * Lifecycle configurations need root access to be able to set up a notebook instance. Because of this, lifecycle
     * configurations associated with a notebook instance always run with root access even if you disable root access
     * for users.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rootAccess} will
     * return {@link RootAccess#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rootAccessAsString}.
     * </p>
     * 
     * @return Whether root access is enabled or disabled for users of the notebook instance. The default value is
     *         <code>Enabled</code>.</p> <note>
     *         <p>
     *         Lifecycle configurations need root access to be able to set up a notebook instance. Because of this,
     *         lifecycle configurations associated with a notebook instance always run with root access even if you
     *         disable root access for users.
     *         </p>
     * @see RootAccess
     */
    public final String rootAccessAsString() {
        return rootAccess;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(notebookInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(directInternetAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(hasAcceleratorTypes() ? acceleratorTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultCodeRepository());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalCodeRepositories() ? additionalCodeRepositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(rootAccessAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNotebookInstanceRequest)) {
            return false;
        }
        CreateNotebookInstanceRequest other = (CreateNotebookInstanceRequest) obj;
        return Objects.equals(notebookInstanceName(), other.notebookInstanceName())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(subnetId(), other.subnetId()) && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(lifecycleConfigName(), other.lifecycleConfigName())
                && Objects.equals(directInternetAccessAsString(), other.directInternetAccessAsString())
                && Objects.equals(volumeSizeInGB(), other.volumeSizeInGB())
                && hasAcceleratorTypes() == other.hasAcceleratorTypes()
                && Objects.equals(acceleratorTypesAsStrings(), other.acceleratorTypesAsStrings())
                && Objects.equals(defaultCodeRepository(), other.defaultCodeRepository())
                && hasAdditionalCodeRepositories() == other.hasAdditionalCodeRepositories()
                && Objects.equals(additionalCodeRepositories(), other.additionalCodeRepositories())
                && Objects.equals(rootAccessAsString(), other.rootAccessAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateNotebookInstanceRequest").add("NotebookInstanceName", notebookInstanceName())
                .add("InstanceType", instanceTypeAsString()).add("SubnetId", subnetId())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null).add("RoleArn", roleArn())
                .add("KmsKeyId", kmsKeyId()).add("Tags", hasTags() ? tags() : null)
                .add("LifecycleConfigName", lifecycleConfigName()).add("DirectInternetAccess", directInternetAccessAsString())
                .add("VolumeSizeInGB", volumeSizeInGB())
                .add("AcceleratorTypes", hasAcceleratorTypes() ? acceleratorTypesAsStrings() : null)
                .add("DefaultCodeRepository", defaultCodeRepository())
                .add("AdditionalCodeRepositories", hasAdditionalCodeRepositories() ? additionalCodeRepositories() : null)
                .add("RootAccess", rootAccessAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotebookInstanceName":
            return Optional.ofNullable(clazz.cast(notebookInstanceName()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "LifecycleConfigName":
            return Optional.ofNullable(clazz.cast(lifecycleConfigName()));
        case "DirectInternetAccess":
            return Optional.ofNullable(clazz.cast(directInternetAccessAsString()));
        case "VolumeSizeInGB":
            return Optional.ofNullable(clazz.cast(volumeSizeInGB()));
        case "AcceleratorTypes":
            return Optional.ofNullable(clazz.cast(acceleratorTypesAsStrings()));
        case "DefaultCodeRepository":
            return Optional.ofNullable(clazz.cast(defaultCodeRepository()));
        case "AdditionalCodeRepositories":
            return Optional.ofNullable(clazz.cast(additionalCodeRepositories()));
        case "RootAccess":
            return Optional.ofNullable(clazz.cast(rootAccessAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNotebookInstanceRequest, T> g) {
        return obj -> g.apply((CreateNotebookInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateNotebookInstanceRequest> {
        /**
         * <p>
         * The name of the new notebook instance.
         * </p>
         * 
         * @param notebookInstanceName
         *        The name of the new notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstanceName(String notebookInstanceName);

        /**
         * <p>
         * The type of ML compute instance to launch for the notebook instance.
         * </p>
         * 
         * @param instanceType
         *        The type of ML compute instance to launch for the notebook instance.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The type of ML compute instance to launch for the notebook instance.
         * </p>
         * 
         * @param instanceType
         *        The type of ML compute instance to launch for the notebook instance.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The ID of the subnet in a VPC to which you would like to have a connectivity from your ML compute instance.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet in a VPC to which you would like to have a connectivity from your ML compute
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The VPC security group IDs, in the form sg-xxxxxxxx. The security groups must be for the same VPC as
         * specified in the subnet.
         * </p>
         * 
         * @param securityGroupIds
         *        The VPC security group IDs, in the form sg-xxxxxxxx. The security groups must be for the same VPC as
         *        specified in the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The VPC security group IDs, in the form sg-xxxxxxxx. The security groups must be for the same VPC as
         * specified in the subnet.
         * </p>
         * 
         * @param securityGroupIds
         *        The VPC security group IDs, in the form sg-xxxxxxxx. The security groups must be for the same VPC as
         *        specified in the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * When you send any requests to Amazon Web Services resources from the notebook instance, Amazon SageMaker
         * assumes this role to perform tasks on your behalf. You must grant this role necessary permissions so Amazon
         * SageMaker can perform these tasks. The policy must allow the Amazon SageMaker service principal
         * (sagemaker.amazonaws.com) permissions to assume this role. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>.
         * </p>
         * <note>
         * <p>
         * To be able to pass this role to Amazon SageMaker, the caller of this API must have the
         * <code>iam:PassRole</code> permission.
         * </p>
         * </note>
         * 
         * @param roleArn
         *        When you send any requests to Amazon Web Services resources from the notebook instance, Amazon
         *        SageMaker assumes this role to perform tasks on your behalf. You must grant this role necessary
         *        permissions so Amazon SageMaker can perform these tasks. The policy must allow the Amazon SageMaker
         *        service principal (sagemaker.amazonaws.com) permissions to assume this role. For more information, see
         *        <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker
         *        Roles</a>. </p> <note>
         *        <p>
         *        To be able to pass this role to Amazon SageMaker, the caller of this API must have the
         *        <code>iam:PassRole</code> permission.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that Amazon SageMaker uses
         * to encrypt data on the storage volume attached to your notebook instance. The KMS key you provide must be
         * enabled. For information, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html">Enabling and Disabling
         * Keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that Amazon
         *        SageMaker uses to encrypt data on the storage volume attached to your notebook instance. The KMS key
         *        you provide must be enabled. For information, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html">Enabling and Disabling
         *        Keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
         *        different ways, for example, by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
         *        different ways, for example, by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The name of a lifecycle configuration to associate with the notebook instance. For information about
         * lifestyle configurations, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
         * Customize a Notebook Instance</a>.
         * </p>
         * 
         * @param lifecycleConfigName
         *        The name of a lifecycle configuration to associate with the notebook instance. For information about
         *        lifestyle configurations, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1:
         *        (Optional) Customize a Notebook Instance</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleConfigName(String lifecycleConfigName);

        /**
         * <p>
         * Sets whether Amazon SageMaker provides internet access to the notebook instance. If you set this to
         * <code>Disabled</code> this notebook instance is able to access resources only in your VPC, and is not be able
         * to connect to Amazon SageMaker training and endpoint services unless you configure a NAT Gateway in your VPC.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
         * >Notebook Instances Are Internet-Enabled by Default</a>. You can set the value of this parameter to
         * <code>Disabled</code> only if you set a value for the <code>SubnetId</code> parameter.
         * </p>
         * 
         * @param directInternetAccess
         *        Sets whether Amazon SageMaker provides internet access to the notebook instance. If you set this to
         *        <code>Disabled</code> this notebook instance is able to access resources only in your VPC, and is not
         *        be able to connect to Amazon SageMaker training and endpoint services unless you configure a NAT
         *        Gateway in your VPC.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
         *        >Notebook Instances Are Internet-Enabled by Default</a>. You can set the value of this parameter to
         *        <code>Disabled</code> only if you set a value for the <code>SubnetId</code> parameter.
         * @see DirectInternetAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectInternetAccess
         */
        Builder directInternetAccess(String directInternetAccess);

        /**
         * <p>
         * Sets whether Amazon SageMaker provides internet access to the notebook instance. If you set this to
         * <code>Disabled</code> this notebook instance is able to access resources only in your VPC, and is not be able
         * to connect to Amazon SageMaker training and endpoint services unless you configure a NAT Gateway in your VPC.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
         * >Notebook Instances Are Internet-Enabled by Default</a>. You can set the value of this parameter to
         * <code>Disabled</code> only if you set a value for the <code>SubnetId</code> parameter.
         * </p>
         * 
         * @param directInternetAccess
         *        Sets whether Amazon SageMaker provides internet access to the notebook instance. If you set this to
         *        <code>Disabled</code> this notebook instance is able to access resources only in your VPC, and is not
         *        be able to connect to Amazon SageMaker training and endpoint services unless you configure a NAT
         *        Gateway in your VPC.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
         *        >Notebook Instances Are Internet-Enabled by Default</a>. You can set the value of this parameter to
         *        <code>Disabled</code> only if you set a value for the <code>SubnetId</code> parameter.
         * @see DirectInternetAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectInternetAccess
         */
        Builder directInternetAccess(DirectInternetAccess directInternetAccess);

        /**
         * <p>
         * The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5 GB.
         * </p>
         * 
         * @param volumeSizeInGB
         *        The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5
         *        GB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSizeInGB(Integer volumeSizeInGB);

        /**
         * <p>
         * A list of Elastic Inference (EI) instance types to associate with this notebook instance. Currently, only one
         * instance type can be associated with a notebook instance. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
         * SageMaker</a>.
         * </p>
         * 
         * @param acceleratorTypes
         *        A list of Elastic Inference (EI) instance types to associate with this notebook instance. Currently,
         *        only one instance type can be associated with a notebook instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
         *        SageMaker</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypesWithStrings(Collection<String> acceleratorTypes);

        /**
         * <p>
         * A list of Elastic Inference (EI) instance types to associate with this notebook instance. Currently, only one
         * instance type can be associated with a notebook instance. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
         * SageMaker</a>.
         * </p>
         * 
         * @param acceleratorTypes
         *        A list of Elastic Inference (EI) instance types to associate with this notebook instance. Currently,
         *        only one instance type can be associated with a notebook instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
         *        SageMaker</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypesWithStrings(String... acceleratorTypes);

        /**
         * <p>
         * A list of Elastic Inference (EI) instance types to associate with this notebook instance. Currently, only one
         * instance type can be associated with a notebook instance. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
         * SageMaker</a>.
         * </p>
         * 
         * @param acceleratorTypes
         *        A list of Elastic Inference (EI) instance types to associate with this notebook instance. Currently,
         *        only one instance type can be associated with a notebook instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
         *        SageMaker</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypes(Collection<NotebookInstanceAcceleratorType> acceleratorTypes);

        /**
         * <p>
         * A list of Elastic Inference (EI) instance types to associate with this notebook instance. Currently, only one
         * instance type can be associated with a notebook instance. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
         * SageMaker</a>.
         * </p>
         * 
         * @param acceleratorTypes
         *        A list of Elastic Inference (EI) instance types to associate with this notebook instance. Currently,
         *        only one instance type can be associated with a notebook instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
         *        SageMaker</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypes(NotebookInstanceAcceleratorType... acceleratorTypes);

        /**
         * <p>
         * A Git repository to associate with the notebook instance as its default code repository. This can be either
         * the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a
         * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services
         * CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory
         * that contains this repository. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with
         * Amazon SageMaker Notebook Instances</a>.
         * </p>
         * 
         * @param defaultCodeRepository
         *        A Git repository to associate with the notebook instance as its default code repository. This can be
         *        either the name of a Git repository stored as a resource in your account, or the URL of a Git
         *        repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon
         *        Web Services CodeCommit</a> or in any other Git repository. When you open a notebook instance, it
         *        opens in the directory that contains this repository. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories
         *        with Amazon SageMaker Notebook Instances</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCodeRepository(String defaultCodeRepository);

        /**
         * <p>
         * An array of up to three Git repositories to associate with the notebook instance. These can be either the
         * names of Git repositories stored as resources in your account, or the URL of Git repositories in <a
         * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services
         * CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default
         * repository of your notebook instance. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with
         * Amazon SageMaker Notebook Instances</a>.
         * </p>
         * 
         * @param additionalCodeRepositories
         *        An array of up to three Git repositories to associate with the notebook instance. These can be either
         *        the names of Git repositories stored as resources in your account, or the URL of Git repositories in
         *        <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services
         *        CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the
         *        default repository of your notebook instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories
         *        with Amazon SageMaker Notebook Instances</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalCodeRepositories(Collection<String> additionalCodeRepositories);

        /**
         * <p>
         * An array of up to three Git repositories to associate with the notebook instance. These can be either the
         * names of Git repositories stored as resources in your account, or the URL of Git repositories in <a
         * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services
         * CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default
         * repository of your notebook instance. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with
         * Amazon SageMaker Notebook Instances</a>.
         * </p>
         * 
         * @param additionalCodeRepositories
         *        An array of up to three Git repositories to associate with the notebook instance. These can be either
         *        the names of Git repositories stored as resources in your account, or the URL of Git repositories in
         *        <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services
         *        CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the
         *        default repository of your notebook instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories
         *        with Amazon SageMaker Notebook Instances</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalCodeRepositories(String... additionalCodeRepositories);

        /**
         * <p>
         * Whether root access is enabled or disabled for users of the notebook instance. The default value is
         * <code>Enabled</code>.
         * </p>
         * <note>
         * <p>
         * Lifecycle configurations need root access to be able to set up a notebook instance. Because of this,
         * lifecycle configurations associated with a notebook instance always run with root access even if you disable
         * root access for users.
         * </p>
         * </note>
         * 
         * @param rootAccess
         *        Whether root access is enabled or disabled for users of the notebook instance. The default value is
         *        <code>Enabled</code>.</p> <note>
         *        <p>
         *        Lifecycle configurations need root access to be able to set up a notebook instance. Because of this,
         *        lifecycle configurations associated with a notebook instance always run with root access even if you
         *        disable root access for users.
         *        </p>
         * @see RootAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RootAccess
         */
        Builder rootAccess(String rootAccess);

        /**
         * <p>
         * Whether root access is enabled or disabled for users of the notebook instance. The default value is
         * <code>Enabled</code>.
         * </p>
         * <note>
         * <p>
         * Lifecycle configurations need root access to be able to set up a notebook instance. Because of this,
         * lifecycle configurations associated with a notebook instance always run with root access even if you disable
         * root access for users.
         * </p>
         * </note>
         * 
         * @param rootAccess
         *        Whether root access is enabled or disabled for users of the notebook instance. The default value is
         *        <code>Enabled</code>.</p> <note>
         *        <p>
         *        Lifecycle configurations need root access to be able to set up a notebook instance. Because of this,
         *        lifecycle configurations associated with a notebook instance always run with root access even if you
         *        disable root access for users.
         *        </p>
         * @see RootAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RootAccess
         */
        Builder rootAccess(RootAccess rootAccess);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String notebookInstanceName;

        private String instanceType;

        private String subnetId;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String roleArn;

        private String kmsKeyId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String lifecycleConfigName;

        private String directInternetAccess;

        private Integer volumeSizeInGB;

        private List<String> acceleratorTypes = DefaultSdkAutoConstructList.getInstance();

        private String defaultCodeRepository;

        private List<String> additionalCodeRepositories = DefaultSdkAutoConstructList.getInstance();

        private String rootAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNotebookInstanceRequest model) {
            super(model);
            notebookInstanceName(model.notebookInstanceName);
            instanceType(model.instanceType);
            subnetId(model.subnetId);
            securityGroupIds(model.securityGroupIds);
            roleArn(model.roleArn);
            kmsKeyId(model.kmsKeyId);
            tags(model.tags);
            lifecycleConfigName(model.lifecycleConfigName);
            directInternetAccess(model.directInternetAccess);
            volumeSizeInGB(model.volumeSizeInGB);
            acceleratorTypesWithStrings(model.acceleratorTypes);
            defaultCodeRepository(model.defaultCodeRepository);
            additionalCodeRepositories(model.additionalCodeRepositories);
            rootAccess(model.rootAccess);
        }

        public final String getNotebookInstanceName() {
            return notebookInstanceName;
        }

        public final void setNotebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
        }

        @Override
        @Transient
        public final Builder notebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        @Transient
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        @Transient
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        @Transient
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        @Override
        @Transient
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLifecycleConfigName() {
            return lifecycleConfigName;
        }

        public final void setLifecycleConfigName(String lifecycleConfigName) {
            this.lifecycleConfigName = lifecycleConfigName;
        }

        @Override
        @Transient
        public final Builder lifecycleConfigName(String lifecycleConfigName) {
            this.lifecycleConfigName = lifecycleConfigName;
            return this;
        }

        public final String getDirectInternetAccess() {
            return directInternetAccess;
        }

        public final void setDirectInternetAccess(String directInternetAccess) {
            this.directInternetAccess = directInternetAccess;
        }

        @Override
        @Transient
        public final Builder directInternetAccess(String directInternetAccess) {
            this.directInternetAccess = directInternetAccess;
            return this;
        }

        @Override
        @Transient
        public final Builder directInternetAccess(DirectInternetAccess directInternetAccess) {
            this.directInternetAccess(directInternetAccess == null ? null : directInternetAccess.toString());
            return this;
        }

        public final Integer getVolumeSizeInGB() {
            return volumeSizeInGB;
        }

        public final void setVolumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
        }

        @Override
        @Transient
        public final Builder volumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
            return this;
        }

        public final Collection<String> getAcceleratorTypes() {
            if (acceleratorTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return acceleratorTypes;
        }

        public final void setAcceleratorTypes(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = NotebookInstanceAcceleratorTypesCopier.copy(acceleratorTypes);
        }

        @Override
        @Transient
        public final Builder acceleratorTypesWithStrings(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = NotebookInstanceAcceleratorTypesCopier.copy(acceleratorTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder acceleratorTypesWithStrings(String... acceleratorTypes) {
            acceleratorTypesWithStrings(Arrays.asList(acceleratorTypes));
            return this;
        }

        @Override
        @Transient
        public final Builder acceleratorTypes(Collection<NotebookInstanceAcceleratorType> acceleratorTypes) {
            this.acceleratorTypes = NotebookInstanceAcceleratorTypesCopier.copyEnumToString(acceleratorTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder acceleratorTypes(NotebookInstanceAcceleratorType... acceleratorTypes) {
            acceleratorTypes(Arrays.asList(acceleratorTypes));
            return this;
        }

        public final String getDefaultCodeRepository() {
            return defaultCodeRepository;
        }

        public final void setDefaultCodeRepository(String defaultCodeRepository) {
            this.defaultCodeRepository = defaultCodeRepository;
        }

        @Override
        @Transient
        public final Builder defaultCodeRepository(String defaultCodeRepository) {
            this.defaultCodeRepository = defaultCodeRepository;
            return this;
        }

        public final Collection<String> getAdditionalCodeRepositories() {
            if (additionalCodeRepositories instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalCodeRepositories;
        }

        public final void setAdditionalCodeRepositories(Collection<String> additionalCodeRepositories) {
            this.additionalCodeRepositories = AdditionalCodeRepositoryNamesOrUrlsCopier.copy(additionalCodeRepositories);
        }

        @Override
        @Transient
        public final Builder additionalCodeRepositories(Collection<String> additionalCodeRepositories) {
            this.additionalCodeRepositories = AdditionalCodeRepositoryNamesOrUrlsCopier.copy(additionalCodeRepositories);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder additionalCodeRepositories(String... additionalCodeRepositories) {
            additionalCodeRepositories(Arrays.asList(additionalCodeRepositories));
            return this;
        }

        public final String getRootAccess() {
            return rootAccess;
        }

        public final void setRootAccess(String rootAccess) {
            this.rootAccess = rootAccess;
        }

        @Override
        @Transient
        public final Builder rootAccess(String rootAccess) {
            this.rootAccess = rootAccess;
            return this;
        }

        @Override
        @Transient
        public final Builder rootAccess(RootAccess rootAccess) {
            this.rootAccess(rootAccess == null ? null : rootAccess.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNotebookInstanceRequest build() {
            return new CreateNotebookInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
