/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWorkforcesResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListWorkforcesResponse.Builder, ListWorkforcesResponse> {
    private static final SdkField<List<Workforce>> WORKFORCES_FIELD = SdkField
            .<List<Workforce>> builder(MarshallingType.LIST)
            .memberName("Workforces")
            .getter(getter(ListWorkforcesResponse::workforces))
            .setter(setter(Builder::workforces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Workforces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Workforce> builder(MarshallingType.SDK_POJO)
                                            .constructor(Workforce::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListWorkforcesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFORCES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Workforce> workforces;

    private final String nextToken;

    private ListWorkforcesResponse(BuilderImpl builder) {
        super(builder);
        this.workforces = builder.workforces;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Workforces property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasWorkforces() {
        return workforces != null && !(workforces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list containing information about your workforce.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWorkforces()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list containing information about your workforce.
     */
    public final List<Workforce> workforces() {
        return workforces;
    }

    /**
     * <p>
     * A token to resume pagination.
     * </p>
     * 
     * @return A token to resume pagination.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkforces() ? workforces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkforcesResponse)) {
            return false;
        }
        ListWorkforcesResponse other = (ListWorkforcesResponse) obj;
        return hasWorkforces() == other.hasWorkforces() && Objects.equals(workforces(), other.workforces())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWorkforcesResponse").add("Workforces", hasWorkforces() ? workforces() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Workforces":
            return Optional.ofNullable(clazz.cast(workforces()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkforcesResponse, T> g) {
        return obj -> g.apply((ListWorkforcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListWorkforcesResponse> {
        /**
         * <p>
         * A list containing information about your workforce.
         * </p>
         * 
         * @param workforces
         *        A list containing information about your workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workforces(Collection<Workforce> workforces);

        /**
         * <p>
         * A list containing information about your workforce.
         * </p>
         * 
         * @param workforces
         *        A list containing information about your workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workforces(Workforce... workforces);

        /**
         * <p>
         * A list containing information about your workforce.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Workforce>.Builder} avoiding the need to
         * create one manually via {@link List<Workforce>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Workforce>.Builder#build()} is called immediately and its
         * result is passed to {@link #workforces(List<Workforce>)}.
         * 
         * @param workforces
         *        a consumer that will call methods on {@link List<Workforce>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workforces(List<Workforce>)
         */
        Builder workforces(Consumer<Workforce.Builder>... workforces);

        /**
         * <p>
         * A token to resume pagination.
         * </p>
         * 
         * @param nextToken
         *        A token to resume pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<Workforce> workforces = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkforcesResponse model) {
            super(model);
            workforces(model.workforces);
            nextToken(model.nextToken);
        }

        public final List<Workforce.Builder> getWorkforces() {
            List<Workforce.Builder> result = WorkforcesCopier.copyToBuilder(this.workforces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkforces(Collection<Workforce.BuilderImpl> workforces) {
            this.workforces = WorkforcesCopier.copyFromBuilder(workforces);
        }

        @Override
        @Transient
        public final Builder workforces(Collection<Workforce> workforces) {
            this.workforces = WorkforcesCopier.copy(workforces);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder workforces(Workforce... workforces) {
            workforces(Arrays.asList(workforces));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder workforces(Consumer<Workforce.Builder>... workforces) {
            workforces(Stream.of(workforces).map(c -> Workforce.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWorkforcesResponse build() {
            return new ListWorkforcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
