/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The reason for a partial failure of an AutoML job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoMLPartialFailureReason implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoMLPartialFailureReason.Builder, AutoMLPartialFailureReason> {
    private static final SdkField<String> PARTIAL_FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PartialFailureMessage").getter(getter(AutoMLPartialFailureReason::partialFailureMessage))
            .setter(setter(Builder::partialFailureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartialFailureMessage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(PARTIAL_FAILURE_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String partialFailureMessage;

    private AutoMLPartialFailureReason(BuilderImpl builder) {
        this.partialFailureMessage = builder.partialFailureMessage;
    }

    /**
     * <p>
     * The message containing the reason for a partial failure of an AutoML job.
     * </p>
     * 
     * @return The message containing the reason for a partial failure of an AutoML job.
     */
    public final String partialFailureMessage() {
        return partialFailureMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(partialFailureMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLPartialFailureReason)) {
            return false;
        }
        AutoMLPartialFailureReason other = (AutoMLPartialFailureReason) obj;
        return Objects.equals(partialFailureMessage(), other.partialFailureMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoMLPartialFailureReason").add("PartialFailureMessage", partialFailureMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PartialFailureMessage":
            return Optional.ofNullable(clazz.cast(partialFailureMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoMLPartialFailureReason, T> g) {
        return obj -> g.apply((AutoMLPartialFailureReason) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoMLPartialFailureReason> {
        /**
         * <p>
         * The message containing the reason for a partial failure of an AutoML job.
         * </p>
         * 
         * @param partialFailureMessage
         *        The message containing the reason for a partial failure of an AutoML job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partialFailureMessage(String partialFailureMessage);
    }

    static final class BuilderImpl implements Builder {
        private String partialFailureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLPartialFailureReason model) {
            partialFailureMessage(model.partialFailureMessage);
        }

        public final String getPartialFailureMessage() {
            return partialFailureMessage;
        }

        public final void setPartialFailureMessage(String partialFailureMessage) {
            this.partialFailureMessage = partialFailureMessage;
        }

        @Override
        @Transient
        public final Builder partialFailureMessage(String partialFailureMessage) {
            this.partialFailureMessage = partialFailureMessage;
            return this;
        }

        @Override
        public AutoMLPartialFailureReason build() {
            return new AutoMLPartialFailureReason(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
