/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the S3 data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransformS3DataSource implements SdkPojo, Serializable,
        ToCopyableBuilder<TransformS3DataSource.Builder, TransformS3DataSource> {
    private static final SdkField<String> S3_DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3DataType").getter(getter(TransformS3DataSource::s3DataTypeAsString))
            .setter(setter(Builder::s3DataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataType").build()).build();

    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Uri")
            .getter(getter(TransformS3DataSource::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_DATA_TYPE_FIELD,
            S3_URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3DataType;

    private final String s3Uri;

    private TransformS3DataSource(BuilderImpl builder) {
        this.s3DataType = builder.s3DataType;
        this.s3Uri = builder.s3Uri;
    }

    /**
     * <p>
     * If you choose <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker uses all
     * objects with the specified key name prefix for batch transform.
     * </p>
     * <p>
     * If you choose <code>ManifestFile</code>, <code>S3Uri</code> identifies an object that is a manifest file
     * containing a list of object keys that you want Amazon SageMaker to use for batch transform.
     * </p>
     * <p>
     * The following values are compatible: <code>ManifestFile</code>, <code>S3Prefix</code>
     * </p>
     * <p>
     * The following value is not compatible: <code>AugmentedManifestFile</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3DataType} will
     * return {@link S3DataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #s3DataTypeAsString}.
     * </p>
     * 
     * @return If you choose <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker
     *         uses all objects with the specified key name prefix for batch transform. </p>
     *         <p>
     *         If you choose <code>ManifestFile</code>, <code>S3Uri</code> identifies an object that is a manifest file
     *         containing a list of object keys that you want Amazon SageMaker to use for batch transform.
     *         </p>
     *         <p>
     *         The following values are compatible: <code>ManifestFile</code>, <code>S3Prefix</code>
     *         </p>
     *         <p>
     *         The following value is not compatible: <code>AugmentedManifestFile</code>
     * @see S3DataType
     */
    public final S3DataType s3DataType() {
        return S3DataType.fromValue(s3DataType);
    }

    /**
     * <p>
     * If you choose <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker uses all
     * objects with the specified key name prefix for batch transform.
     * </p>
     * <p>
     * If you choose <code>ManifestFile</code>, <code>S3Uri</code> identifies an object that is a manifest file
     * containing a list of object keys that you want Amazon SageMaker to use for batch transform.
     * </p>
     * <p>
     * The following values are compatible: <code>ManifestFile</code>, <code>S3Prefix</code>
     * </p>
     * <p>
     * The following value is not compatible: <code>AugmentedManifestFile</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3DataType} will
     * return {@link S3DataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #s3DataTypeAsString}.
     * </p>
     * 
     * @return If you choose <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker
     *         uses all objects with the specified key name prefix for batch transform. </p>
     *         <p>
     *         If you choose <code>ManifestFile</code>, <code>S3Uri</code> identifies an object that is a manifest file
     *         containing a list of object keys that you want Amazon SageMaker to use for batch transform.
     *         </p>
     *         <p>
     *         The following values are compatible: <code>ManifestFile</code>, <code>S3Prefix</code>
     *         </p>
     *         <p>
     *         The following value is not compatible: <code>AugmentedManifestFile</code>
     * @see S3DataType
     */
    public final String s3DataTypeAsString() {
        return s3DataType;
    }

    /**
     * <p>
     * Depending on the value specified for the <code>S3DataType</code>, identifies either a key name prefix or a
     * manifest. For example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A key name prefix might look like this: <code>s3://bucketname/exampleprefix</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * A manifest might look like this: <code>s3://bucketname/example.manifest</code>
     * </p>
     * <p>
     * The manifest is an S3 object which is a JSON file with the following format:
     * </p>
     * <p>
     * <code>[ {"prefix": "s3://customer_bucket/some/prefix/"},</code>
     * </p>
     * <p>
     * <code>"relative/path/to/custdata-1",</code>
     * </p>
     * <p>
     * <code>"relative/path/custdata-2",</code>
     * </p>
     * <p>
     * <code>...</code>
     * </p>
     * <p>
     * <code>"relative/path/custdata-N"</code>
     * </p>
     * <p>
     * <code>]</code>
     * </p>
     * <p>
     * The preceding JSON matches the following <code>S3Uris</code>:
     * </p>
     * <p>
     * <code>s3://customer_bucket/some/prefix/relative/path/to/custdata-1</code>
     * </p>
     * <p>
     * <code>s3://customer_bucket/some/prefix/relative/path/custdata-2</code>
     * </p>
     * <p>
     * <code>...</code>
     * </p>
     * <p>
     * <code>s3://customer_bucket/some/prefix/relative/path/custdata-N</code>
     * </p>
     * <p>
     * The complete set of <code>S3Uris</code> in this manifest constitutes the input data for the channel for this
     * datasource. The object that each <code>S3Uris</code> points to must be readable by the IAM role that Amazon
     * SageMaker uses to perform tasks on your behalf.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Depending on the value specified for the <code>S3DataType</code>, identifies either a key name prefix or
     *         a manifest. For example:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         A key name prefix might look like this: <code>s3://bucketname/exampleprefix</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A manifest might look like this: <code>s3://bucketname/example.manifest</code>
     *         </p>
     *         <p>
     *         The manifest is an S3 object which is a JSON file with the following format:
     *         </p>
     *         <p>
     *         <code>[ {"prefix": "s3://customer_bucket/some/prefix/"},</code>
     *         </p>
     *         <p>
     *         <code>"relative/path/to/custdata-1",</code>
     *         </p>
     *         <p>
     *         <code>"relative/path/custdata-2",</code>
     *         </p>
     *         <p>
     *         <code>...</code>
     *         </p>
     *         <p>
     *         <code>"relative/path/custdata-N"</code>
     *         </p>
     *         <p>
     *         <code>]</code>
     *         </p>
     *         <p>
     *         The preceding JSON matches the following <code>S3Uris</code>:
     *         </p>
     *         <p>
     *         <code>s3://customer_bucket/some/prefix/relative/path/to/custdata-1</code>
     *         </p>
     *         <p>
     *         <code>s3://customer_bucket/some/prefix/relative/path/custdata-2</code>
     *         </p>
     *         <p>
     *         <code>...</code>
     *         </p>
     *         <p>
     *         <code>s3://customer_bucket/some/prefix/relative/path/custdata-N</code>
     *         </p>
     *         <p>
     *         The complete set of <code>S3Uris</code> in this manifest constitutes the input data for the channel for
     *         this datasource. The object that each <code>S3Uris</code> points to must be readable by the IAM role that
     *         Amazon SageMaker uses to perform tasks on your behalf.
     *         </p>
     *         </li>
     */
    public final String s3Uri() {
        return s3Uri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3DataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformS3DataSource)) {
            return false;
        }
        TransformS3DataSource other = (TransformS3DataSource) obj;
        return Objects.equals(s3DataTypeAsString(), other.s3DataTypeAsString()) && Objects.equals(s3Uri(), other.s3Uri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransformS3DataSource").add("S3DataType", s3DataTypeAsString()).add("S3Uri", s3Uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3DataType":
            return Optional.ofNullable(clazz.cast(s3DataTypeAsString()));
        case "S3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransformS3DataSource, T> g) {
        return obj -> g.apply((TransformS3DataSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransformS3DataSource> {
        /**
         * <p>
         * If you choose <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker uses
         * all objects with the specified key name prefix for batch transform.
         * </p>
         * <p>
         * If you choose <code>ManifestFile</code>, <code>S3Uri</code> identifies an object that is a manifest file
         * containing a list of object keys that you want Amazon SageMaker to use for batch transform.
         * </p>
         * <p>
         * The following values are compatible: <code>ManifestFile</code>, <code>S3Prefix</code>
         * </p>
         * <p>
         * The following value is not compatible: <code>AugmentedManifestFile</code>
         * </p>
         * 
         * @param s3DataType
         *        If you choose <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker
         *        uses all objects with the specified key name prefix for batch transform. </p>
         *        <p>
         *        If you choose <code>ManifestFile</code>, <code>S3Uri</code> identifies an object that is a manifest
         *        file containing a list of object keys that you want Amazon SageMaker to use for batch transform.
         *        </p>
         *        <p>
         *        The following values are compatible: <code>ManifestFile</code>, <code>S3Prefix</code>
         *        </p>
         *        <p>
         *        The following value is not compatible: <code>AugmentedManifestFile</code>
         * @see S3DataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3DataType
         */
        Builder s3DataType(String s3DataType);

        /**
         * <p>
         * If you choose <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker uses
         * all objects with the specified key name prefix for batch transform.
         * </p>
         * <p>
         * If you choose <code>ManifestFile</code>, <code>S3Uri</code> identifies an object that is a manifest file
         * containing a list of object keys that you want Amazon SageMaker to use for batch transform.
         * </p>
         * <p>
         * The following values are compatible: <code>ManifestFile</code>, <code>S3Prefix</code>
         * </p>
         * <p>
         * The following value is not compatible: <code>AugmentedManifestFile</code>
         * </p>
         * 
         * @param s3DataType
         *        If you choose <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker
         *        uses all objects with the specified key name prefix for batch transform. </p>
         *        <p>
         *        If you choose <code>ManifestFile</code>, <code>S3Uri</code> identifies an object that is a manifest
         *        file containing a list of object keys that you want Amazon SageMaker to use for batch transform.
         *        </p>
         *        <p>
         *        The following values are compatible: <code>ManifestFile</code>, <code>S3Prefix</code>
         *        </p>
         *        <p>
         *        The following value is not compatible: <code>AugmentedManifestFile</code>
         * @see S3DataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3DataType
         */
        Builder s3DataType(S3DataType s3DataType);

        /**
         * <p>
         * Depending on the value specified for the <code>S3DataType</code>, identifies either a key name prefix or a
         * manifest. For example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * A key name prefix might look like this: <code>s3://bucketname/exampleprefix</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * A manifest might look like this: <code>s3://bucketname/example.manifest</code>
         * </p>
         * <p>
         * The manifest is an S3 object which is a JSON file with the following format:
         * </p>
         * <p>
         * <code>[ {"prefix": "s3://customer_bucket/some/prefix/"},</code>
         * </p>
         * <p>
         * <code>"relative/path/to/custdata-1",</code>
         * </p>
         * <p>
         * <code>"relative/path/custdata-2",</code>
         * </p>
         * <p>
         * <code>...</code>
         * </p>
         * <p>
         * <code>"relative/path/custdata-N"</code>
         * </p>
         * <p>
         * <code>]</code>
         * </p>
         * <p>
         * The preceding JSON matches the following <code>S3Uris</code>:
         * </p>
         * <p>
         * <code>s3://customer_bucket/some/prefix/relative/path/to/custdata-1</code>
         * </p>
         * <p>
         * <code>s3://customer_bucket/some/prefix/relative/path/custdata-2</code>
         * </p>
         * <p>
         * <code>...</code>
         * </p>
         * <p>
         * <code>s3://customer_bucket/some/prefix/relative/path/custdata-N</code>
         * </p>
         * <p>
         * The complete set of <code>S3Uris</code> in this manifest constitutes the input data for the channel for this
         * datasource. The object that each <code>S3Uris</code> points to must be readable by the IAM role that Amazon
         * SageMaker uses to perform tasks on your behalf.
         * </p>
         * </li>
         * </ul>
         * 
         * @param s3Uri
         *        Depending on the value specified for the <code>S3DataType</code>, identifies either a key name prefix
         *        or a manifest. For example:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        A key name prefix might look like this: <code>s3://bucketname/exampleprefix</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A manifest might look like this: <code>s3://bucketname/example.manifest</code>
         *        </p>
         *        <p>
         *        The manifest is an S3 object which is a JSON file with the following format:
         *        </p>
         *        <p>
         *        <code>[ {"prefix": "s3://customer_bucket/some/prefix/"},</code>
         *        </p>
         *        <p>
         *        <code>"relative/path/to/custdata-1",</code>
         *        </p>
         *        <p>
         *        <code>"relative/path/custdata-2",</code>
         *        </p>
         *        <p>
         *        <code>...</code>
         *        </p>
         *        <p>
         *        <code>"relative/path/custdata-N"</code>
         *        </p>
         *        <p>
         *        <code>]</code>
         *        </p>
         *        <p>
         *        The preceding JSON matches the following <code>S3Uris</code>:
         *        </p>
         *        <p>
         *        <code>s3://customer_bucket/some/prefix/relative/path/to/custdata-1</code>
         *        </p>
         *        <p>
         *        <code>s3://customer_bucket/some/prefix/relative/path/custdata-2</code>
         *        </p>
         *        <p>
         *        <code>...</code>
         *        </p>
         *        <p>
         *        <code>s3://customer_bucket/some/prefix/relative/path/custdata-N</code>
         *        </p>
         *        <p>
         *        The complete set of <code>S3Uris</code> in this manifest constitutes the input data for the channel
         *        for this datasource. The object that each <code>S3Uris</code> points to must be readable by the IAM
         *        role that Amazon SageMaker uses to perform tasks on your behalf.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);
    }

    static final class BuilderImpl implements Builder {
        private String s3DataType;

        private String s3Uri;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformS3DataSource model) {
            s3DataType(model.s3DataType);
            s3Uri(model.s3Uri);
        }

        public final String getS3DataType() {
            return s3DataType;
        }

        public final void setS3DataType(String s3DataType) {
            this.s3DataType = s3DataType;
        }

        @Override
        @Transient
        public final Builder s3DataType(String s3DataType) {
            this.s3DataType = s3DataType;
            return this;
        }

        @Override
        @Transient
        public final Builder s3DataType(S3DataType s3DataType) {
            this.s3DataType(s3DataType == null ? null : s3DataType.toString());
            return this;
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        @Transient
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        @Override
        public TransformS3DataSource build() {
            return new TransformS3DataSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
