/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileSystemConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<FileSystemConfig.Builder, FileSystemConfig> {
    private static final SdkField<String> MOUNT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MountPath").getter(getter(FileSystemConfig::mountPath)).setter(setter(Builder::mountPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountPath").build()).build();

    private static final SdkField<Integer> DEFAULT_UID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DefaultUid").getter(getter(FileSystemConfig::defaultUid)).setter(setter(Builder::defaultUid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultUid").build()).build();

    private static final SdkField<Integer> DEFAULT_GID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DefaultGid").getter(getter(FileSystemConfig::defaultGid)).setter(setter(Builder::defaultGid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultGid").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MOUNT_PATH_FIELD,
            DEFAULT_UID_FIELD, DEFAULT_GID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mountPath;

    private final Integer defaultUid;

    private final Integer defaultGid;

    private FileSystemConfig(BuilderImpl builder) {
        this.mountPath = builder.mountPath;
        this.defaultUid = builder.defaultUid;
        this.defaultGid = builder.defaultGid;
    }

    /**
     * <p>
     * The path within the image to mount the user's EFS home directory. The directory should be empty. If not
     * specified, defaults to <i>/home/sagemaker-user</i>.
     * </p>
     * 
     * @return The path within the image to mount the user's EFS home directory. The directory should be empty. If not
     *         specified, defaults to <i>/home/sagemaker-user</i>.
     */
    public final String mountPath() {
        return mountPath;
    }

    /**
     * <p>
     * The default POSIX user ID (UID). If not specified, defaults to <code>1000</code>.
     * </p>
     * 
     * @return The default POSIX user ID (UID). If not specified, defaults to <code>1000</code>.
     */
    public final Integer defaultUid() {
        return defaultUid;
    }

    /**
     * <p>
     * The default POSIX group ID (GID). If not specified, defaults to <code>100</code>.
     * </p>
     * 
     * @return The default POSIX group ID (GID). If not specified, defaults to <code>100</code>.
     */
    public final Integer defaultGid() {
        return defaultGid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mountPath());
        hashCode = 31 * hashCode + Objects.hashCode(defaultUid());
        hashCode = 31 * hashCode + Objects.hashCode(defaultGid());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSystemConfig)) {
            return false;
        }
        FileSystemConfig other = (FileSystemConfig) obj;
        return Objects.equals(mountPath(), other.mountPath()) && Objects.equals(defaultUid(), other.defaultUid())
                && Objects.equals(defaultGid(), other.defaultGid());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileSystemConfig").add("MountPath", mountPath()).add("DefaultUid", defaultUid())
                .add("DefaultGid", defaultGid()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MountPath":
            return Optional.ofNullable(clazz.cast(mountPath()));
        case "DefaultUid":
            return Optional.ofNullable(clazz.cast(defaultUid()));
        case "DefaultGid":
            return Optional.ofNullable(clazz.cast(defaultGid()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileSystemConfig, T> g) {
        return obj -> g.apply((FileSystemConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileSystemConfig> {
        /**
         * <p>
         * The path within the image to mount the user's EFS home directory. The directory should be empty. If not
         * specified, defaults to <i>/home/sagemaker-user</i>.
         * </p>
         * 
         * @param mountPath
         *        The path within the image to mount the user's EFS home directory. The directory should be empty. If
         *        not specified, defaults to <i>/home/sagemaker-user</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountPath(String mountPath);

        /**
         * <p>
         * The default POSIX user ID (UID). If not specified, defaults to <code>1000</code>.
         * </p>
         * 
         * @param defaultUid
         *        The default POSIX user ID (UID). If not specified, defaults to <code>1000</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultUid(Integer defaultUid);

        /**
         * <p>
         * The default POSIX group ID (GID). If not specified, defaults to <code>100</code>.
         * </p>
         * 
         * @param defaultGid
         *        The default POSIX group ID (GID). If not specified, defaults to <code>100</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultGid(Integer defaultGid);
    }

    static final class BuilderImpl implements Builder {
        private String mountPath;

        private Integer defaultUid;

        private Integer defaultGid;

        private BuilderImpl() {
        }

        private BuilderImpl(FileSystemConfig model) {
            mountPath(model.mountPath);
            defaultUid(model.defaultUid);
            defaultGid(model.defaultGid);
        }

        public final String getMountPath() {
            return mountPath;
        }

        public final void setMountPath(String mountPath) {
            this.mountPath = mountPath;
        }

        @Override
        @Transient
        public final Builder mountPath(String mountPath) {
            this.mountPath = mountPath;
            return this;
        }

        public final Integer getDefaultUid() {
            return defaultUid;
        }

        public final void setDefaultUid(Integer defaultUid) {
            this.defaultUid = defaultUid;
        }

        @Override
        @Transient
        public final Builder defaultUid(Integer defaultUid) {
            this.defaultUid = defaultUid;
            return this;
        }

        public final Integer getDefaultGid() {
            return defaultGid;
        }

        public final void setDefaultGid(Integer defaultGid) {
            this.defaultGid = defaultGid;
        }

        @Override
        @Transient
        public final Builder defaultGid(Integer defaultGid) {
            this.defaultGid = defaultGid;
            return this;
        }

        @Override
        public FileSystemConfig build() {
            return new FileSystemConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
