/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration for asynchronous inference invocation outputs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AsyncInferenceOutputConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AsyncInferenceOutputConfig.Builder, AsyncInferenceOutputConfig> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(AsyncInferenceOutputConfig::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> S3_OUTPUT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3OutputPath").getter(getter(AsyncInferenceOutputConfig::s3OutputPath))
            .setter(setter(Builder::s3OutputPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputPath").build()).build();

    private static final SdkField<AsyncInferenceNotificationConfig> NOTIFICATION_CONFIG_FIELD = SdkField
            .<AsyncInferenceNotificationConfig> builder(MarshallingType.SDK_POJO).memberName("NotificationConfig")
            .getter(getter(AsyncInferenceOutputConfig::notificationConfig)).setter(setter(Builder::notificationConfig))
            .constructor(AsyncInferenceNotificationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD,
            S3_OUTPUT_PATH_FIELD, NOTIFICATION_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String kmsKeyId;

    private final String s3OutputPath;

    private final AsyncInferenceNotificationConfig notificationConfig;

    private AsyncInferenceOutputConfig(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
        this.s3OutputPath = builder.s3OutputPath;
        this.notificationConfig = builder.notificationConfig;
    }

    /**
     * <p>
     * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to
     * encrypt the asynchronous inference output in Amazon S3.
     * </p>
     * <p/>
     * 
     * @return The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses
     *         to encrypt the asynchronous inference output in Amazon S3.
     *         </p>
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The Amazon S3 location to upload inference responses to.
     * </p>
     * 
     * @return The Amazon S3 location to upload inference responses to.
     */
    public final String s3OutputPath() {
        return s3OutputPath;
    }

    /**
     * <p>
     * Specifies the configuration for notifications of inference results for asynchronous inference.
     * </p>
     * 
     * @return Specifies the configuration for notifications of inference results for asynchronous inference.
     */
    public final AsyncInferenceNotificationConfig notificationConfig() {
        return notificationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(s3OutputPath());
        hashCode = 31 * hashCode + Objects.hashCode(notificationConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AsyncInferenceOutputConfig)) {
            return false;
        }
        AsyncInferenceOutputConfig other = (AsyncInferenceOutputConfig) obj;
        return Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(s3OutputPath(), other.s3OutputPath())
                && Objects.equals(notificationConfig(), other.notificationConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AsyncInferenceOutputConfig").add("KmsKeyId", kmsKeyId()).add("S3OutputPath", s3OutputPath())
                .add("NotificationConfig", notificationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "S3OutputPath":
            return Optional.ofNullable(clazz.cast(s3OutputPath()));
        case "NotificationConfig":
            return Optional.ofNullable(clazz.cast(notificationConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AsyncInferenceOutputConfig, T> g) {
        return obj -> g.apply((AsyncInferenceOutputConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AsyncInferenceOutputConfig> {
        /**
         * <p>
         * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to
         * encrypt the asynchronous inference output in Amazon S3.
         * </p>
         * <p/>
         * 
         * @param kmsKeyId
         *        The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker
         *        uses to encrypt the asynchronous inference output in Amazon S3.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The Amazon S3 location to upload inference responses to.
         * </p>
         * 
         * @param s3OutputPath
         *        The Amazon S3 location to upload inference responses to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3OutputPath(String s3OutputPath);

        /**
         * <p>
         * Specifies the configuration for notifications of inference results for asynchronous inference.
         * </p>
         * 
         * @param notificationConfig
         *        Specifies the configuration for notifications of inference results for asynchronous inference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfig(AsyncInferenceNotificationConfig notificationConfig);

        /**
         * <p>
         * Specifies the configuration for notifications of inference results for asynchronous inference.
         * </p>
         * This is a convenience method that creates an instance of the {@link AsyncInferenceNotificationConfig.Builder}
         * avoiding the need to create one manually via {@link AsyncInferenceNotificationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AsyncInferenceNotificationConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #notificationConfig(AsyncInferenceNotificationConfig)}.
         * 
         * @param notificationConfig
         *        a consumer that will call methods on {@link AsyncInferenceNotificationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationConfig(AsyncInferenceNotificationConfig)
         */
        default Builder notificationConfig(Consumer<AsyncInferenceNotificationConfig.Builder> notificationConfig) {
            return notificationConfig(AsyncInferenceNotificationConfig.builder().applyMutation(notificationConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String kmsKeyId;

        private String s3OutputPath;

        private AsyncInferenceNotificationConfig notificationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AsyncInferenceOutputConfig model) {
            kmsKeyId(model.kmsKeyId);
            s3OutputPath(model.s3OutputPath);
            notificationConfig(model.notificationConfig);
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getS3OutputPath() {
            return s3OutputPath;
        }

        public final void setS3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
        }

        @Override
        @Transient
        public final Builder s3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
            return this;
        }

        public final AsyncInferenceNotificationConfig.Builder getNotificationConfig() {
            return notificationConfig != null ? notificationConfig.toBuilder() : null;
        }

        public final void setNotificationConfig(AsyncInferenceNotificationConfig.BuilderImpl notificationConfig) {
            this.notificationConfig = notificationConfig != null ? notificationConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder notificationConfig(AsyncInferenceNotificationConfig notificationConfig) {
            this.notificationConfig = notificationConfig;
            return this;
        }

        @Override
        public AsyncInferenceOutputConfig build() {
            return new AsyncInferenceOutputConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
