/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of settings used for an AutoML job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoMLJobConfig implements SdkPojo, Serializable, ToCopyableBuilder<AutoMLJobConfig.Builder, AutoMLJobConfig> {
    private static final SdkField<AutoMLJobCompletionCriteria> COMPLETION_CRITERIA_FIELD = SdkField
            .<AutoMLJobCompletionCriteria> builder(MarshallingType.SDK_POJO).memberName("CompletionCriteria")
            .getter(getter(AutoMLJobConfig::completionCriteria)).setter(setter(Builder::completionCriteria))
            .constructor(AutoMLJobCompletionCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionCriteria").build())
            .build();

    private static final SdkField<AutoMLSecurityConfig> SECURITY_CONFIG_FIELD = SdkField
            .<AutoMLSecurityConfig> builder(MarshallingType.SDK_POJO).memberName("SecurityConfig")
            .getter(getter(AutoMLJobConfig::securityConfig)).setter(setter(Builder::securityConfig))
            .constructor(AutoMLSecurityConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_CRITERIA_FIELD,
            SECURITY_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final AutoMLJobCompletionCriteria completionCriteria;

    private final AutoMLSecurityConfig securityConfig;

    private AutoMLJobConfig(BuilderImpl builder) {
        this.completionCriteria = builder.completionCriteria;
        this.securityConfig = builder.securityConfig;
    }

    /**
     * <p>
     * How long an AutoML job is allowed to run, or how many candidates a job is allowed to generate.
     * </p>
     * 
     * @return How long an AutoML job is allowed to run, or how many candidates a job is allowed to generate.
     */
    public final AutoMLJobCompletionCriteria completionCriteria() {
        return completionCriteria;
    }

    /**
     * <p>
     * The security configuration for traffic encryption or Amazon VPC settings.
     * </p>
     * 
     * @return The security configuration for traffic encryption or Amazon VPC settings.
     */
    public final AutoMLSecurityConfig securityConfig() {
        return securityConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(completionCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(securityConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLJobConfig)) {
            return false;
        }
        AutoMLJobConfig other = (AutoMLJobConfig) obj;
        return Objects.equals(completionCriteria(), other.completionCriteria())
                && Objects.equals(securityConfig(), other.securityConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoMLJobConfig").add("CompletionCriteria", completionCriteria())
                .add("SecurityConfig", securityConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompletionCriteria":
            return Optional.ofNullable(clazz.cast(completionCriteria()));
        case "SecurityConfig":
            return Optional.ofNullable(clazz.cast(securityConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoMLJobConfig, T> g) {
        return obj -> g.apply((AutoMLJobConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoMLJobConfig> {
        /**
         * <p>
         * How long an AutoML job is allowed to run, or how many candidates a job is allowed to generate.
         * </p>
         * 
         * @param completionCriteria
         *        How long an AutoML job is allowed to run, or how many candidates a job is allowed to generate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionCriteria(AutoMLJobCompletionCriteria completionCriteria);

        /**
         * <p>
         * How long an AutoML job is allowed to run, or how many candidates a job is allowed to generate.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoMLJobCompletionCriteria.Builder}
         * avoiding the need to create one manually via {@link AutoMLJobCompletionCriteria#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoMLJobCompletionCriteria.Builder#build()} is called
         * immediately and its result is passed to {@link #completionCriteria(AutoMLJobCompletionCriteria)}.
         * 
         * @param completionCriteria
         *        a consumer that will call methods on {@link AutoMLJobCompletionCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #completionCriteria(AutoMLJobCompletionCriteria)
         */
        default Builder completionCriteria(Consumer<AutoMLJobCompletionCriteria.Builder> completionCriteria) {
            return completionCriteria(AutoMLJobCompletionCriteria.builder().applyMutation(completionCriteria).build());
        }

        /**
         * <p>
         * The security configuration for traffic encryption or Amazon VPC settings.
         * </p>
         * 
         * @param securityConfig
         *        The security configuration for traffic encryption or Amazon VPC settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfig(AutoMLSecurityConfig securityConfig);

        /**
         * <p>
         * The security configuration for traffic encryption or Amazon VPC settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoMLSecurityConfig.Builder} avoiding
         * the need to create one manually via {@link AutoMLSecurityConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoMLSecurityConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #securityConfig(AutoMLSecurityConfig)}.
         * 
         * @param securityConfig
         *        a consumer that will call methods on {@link AutoMLSecurityConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityConfig(AutoMLSecurityConfig)
         */
        default Builder securityConfig(Consumer<AutoMLSecurityConfig.Builder> securityConfig) {
            return securityConfig(AutoMLSecurityConfig.builder().applyMutation(securityConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutoMLJobCompletionCriteria completionCriteria;

        private AutoMLSecurityConfig securityConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLJobConfig model) {
            completionCriteria(model.completionCriteria);
            securityConfig(model.securityConfig);
        }

        public final AutoMLJobCompletionCriteria.Builder getCompletionCriteria() {
            return completionCriteria != null ? completionCriteria.toBuilder() : null;
        }

        public final void setCompletionCriteria(AutoMLJobCompletionCriteria.BuilderImpl completionCriteria) {
            this.completionCriteria = completionCriteria != null ? completionCriteria.build() : null;
        }

        @Override
        @Transient
        public final Builder completionCriteria(AutoMLJobCompletionCriteria completionCriteria) {
            this.completionCriteria = completionCriteria;
            return this;
        }

        public final AutoMLSecurityConfig.Builder getSecurityConfig() {
            return securityConfig != null ? securityConfig.toBuilder() : null;
        }

        public final void setSecurityConfig(AutoMLSecurityConfig.BuilderImpl securityConfig) {
            this.securityConfig = securityConfig != null ? securityConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder securityConfig(AutoMLSecurityConfig securityConfig) {
            this.securityConfig = securityConfig;
            return this;
        }

        @Override
        public AutoMLJobConfig build() {
            return new AutoMLJobConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
