/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains bias metrics for a model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Bias implements SdkPojo, Serializable, ToCopyableBuilder<Bias.Builder, Bias> {
    private static final SdkField<MetricsSource> REPORT_FIELD = SdkField.<MetricsSource> builder(MarshallingType.SDK_POJO)
            .memberName("Report").getter(getter(Bias::report)).setter(setter(Builder::report))
            .constructor(MetricsSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Report").build()).build();

    private static final SdkField<MetricsSource> PRE_TRAINING_REPORT_FIELD = SdkField
            .<MetricsSource> builder(MarshallingType.SDK_POJO).memberName("PreTrainingReport")
            .getter(getter(Bias::preTrainingReport)).setter(setter(Builder::preTrainingReport))
            .constructor(MetricsSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreTrainingReport").build()).build();

    private static final SdkField<MetricsSource> POST_TRAINING_REPORT_FIELD = SdkField
            .<MetricsSource> builder(MarshallingType.SDK_POJO).memberName("PostTrainingReport")
            .getter(getter(Bias::postTrainingReport)).setter(setter(Builder::postTrainingReport))
            .constructor(MetricsSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostTrainingReport").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_FIELD,
            PRE_TRAINING_REPORT_FIELD, POST_TRAINING_REPORT_FIELD));

    private static final long serialVersionUID = 1L;

    private final MetricsSource report;

    private final MetricsSource preTrainingReport;

    private final MetricsSource postTrainingReport;

    private Bias(BuilderImpl builder) {
        this.report = builder.report;
        this.preTrainingReport = builder.preTrainingReport;
        this.postTrainingReport = builder.postTrainingReport;
    }

    /**
     * <p>
     * The bias report for a model
     * </p>
     * 
     * @return The bias report for a model
     */
    public final MetricsSource report() {
        return report;
    }

    /**
     * Returns the value of the PreTrainingReport property for this object.
     * 
     * @return The value of the PreTrainingReport property for this object.
     */
    public final MetricsSource preTrainingReport() {
        return preTrainingReport;
    }

    /**
     * Returns the value of the PostTrainingReport property for this object.
     * 
     * @return The value of the PostTrainingReport property for this object.
     */
    public final MetricsSource postTrainingReport() {
        return postTrainingReport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(report());
        hashCode = 31 * hashCode + Objects.hashCode(preTrainingReport());
        hashCode = 31 * hashCode + Objects.hashCode(postTrainingReport());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Bias)) {
            return false;
        }
        Bias other = (Bias) obj;
        return Objects.equals(report(), other.report()) && Objects.equals(preTrainingReport(), other.preTrainingReport())
                && Objects.equals(postTrainingReport(), other.postTrainingReport());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Bias").add("Report", report()).add("PreTrainingReport", preTrainingReport())
                .add("PostTrainingReport", postTrainingReport()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Report":
            return Optional.ofNullable(clazz.cast(report()));
        case "PreTrainingReport":
            return Optional.ofNullable(clazz.cast(preTrainingReport()));
        case "PostTrainingReport":
            return Optional.ofNullable(clazz.cast(postTrainingReport()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Bias, T> g) {
        return obj -> g.apply((Bias) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Bias> {
        /**
         * <p>
         * The bias report for a model
         * </p>
         * 
         * @param report
         *        The bias report for a model
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder report(MetricsSource report);

        /**
         * <p>
         * The bias report for a model
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricsSource.Builder} avoiding the need
         * to create one manually via {@link MetricsSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetricsSource.Builder#build()} is called immediately and its
         * result is passed to {@link #report(MetricsSource)}.
         * 
         * @param report
         *        a consumer that will call methods on {@link MetricsSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #report(MetricsSource)
         */
        default Builder report(Consumer<MetricsSource.Builder> report) {
            return report(MetricsSource.builder().applyMutation(report).build());
        }

        /**
         * Sets the value of the PreTrainingReport property for this object.
         *
         * @param preTrainingReport
         *        The new value for the PreTrainingReport property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preTrainingReport(MetricsSource preTrainingReport);

        /**
         * Sets the value of the PreTrainingReport property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MetricsSource.Builder} avoiding the need
         * to create one manually via {@link MetricsSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetricsSource.Builder#build()} is called immediately and its
         * result is passed to {@link #preTrainingReport(MetricsSource)}.
         * 
         * @param preTrainingReport
         *        a consumer that will call methods on {@link MetricsSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preTrainingReport(MetricsSource)
         */
        default Builder preTrainingReport(Consumer<MetricsSource.Builder> preTrainingReport) {
            return preTrainingReport(MetricsSource.builder().applyMutation(preTrainingReport).build());
        }

        /**
         * Sets the value of the PostTrainingReport property for this object.
         *
         * @param postTrainingReport
         *        The new value for the PostTrainingReport property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postTrainingReport(MetricsSource postTrainingReport);

        /**
         * Sets the value of the PostTrainingReport property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MetricsSource.Builder} avoiding the need
         * to create one manually via {@link MetricsSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetricsSource.Builder#build()} is called immediately and its
         * result is passed to {@link #postTrainingReport(MetricsSource)}.
         * 
         * @param postTrainingReport
         *        a consumer that will call methods on {@link MetricsSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postTrainingReport(MetricsSource)
         */
        default Builder postTrainingReport(Consumer<MetricsSource.Builder> postTrainingReport) {
            return postTrainingReport(MetricsSource.builder().applyMutation(postTrainingReport).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MetricsSource report;

        private MetricsSource preTrainingReport;

        private MetricsSource postTrainingReport;

        private BuilderImpl() {
        }

        private BuilderImpl(Bias model) {
            report(model.report);
            preTrainingReport(model.preTrainingReport);
            postTrainingReport(model.postTrainingReport);
        }

        public final MetricsSource.Builder getReport() {
            return report != null ? report.toBuilder() : null;
        }

        public final void setReport(MetricsSource.BuilderImpl report) {
            this.report = report != null ? report.build() : null;
        }

        @Override
        @Transient
        public final Builder report(MetricsSource report) {
            this.report = report;
            return this;
        }

        public final MetricsSource.Builder getPreTrainingReport() {
            return preTrainingReport != null ? preTrainingReport.toBuilder() : null;
        }

        public final void setPreTrainingReport(MetricsSource.BuilderImpl preTrainingReport) {
            this.preTrainingReport = preTrainingReport != null ? preTrainingReport.build() : null;
        }

        @Override
        @Transient
        public final Builder preTrainingReport(MetricsSource preTrainingReport) {
            this.preTrainingReport = preTrainingReport;
            return this;
        }

        public final MetricsSource.Builder getPostTrainingReport() {
            return postTrainingReport != null ? postTrainingReport.toBuilder() : null;
        }

        public final void setPostTrainingReport(MetricsSource.BuilderImpl postTrainingReport) {
            this.postTrainingReport = postTrainingReport != null ? postTrainingReport.build() : null;
        }

        @Override
        @Transient
        public final Builder postTrainingReport(MetricsSource postTrainingReport) {
            this.postTrainingReport = postTrainingReport;
            return this;
        }

        @Override
        public Bias build() {
            return new Bias(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
