/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEdgePackagingJobRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateEdgePackagingJobRequest.Builder, CreateEdgePackagingJobRequest> {
    private static final SdkField<String> EDGE_PACKAGING_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EdgePackagingJobName").getter(getter(CreateEdgePackagingJobRequest::edgePackagingJobName))
            .setter(setter(Builder::edgePackagingJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgePackagingJobName").build())
            .build();

    private static final SdkField<String> COMPILATION_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompilationJobName").getter(getter(CreateEdgePackagingJobRequest::compilationJobName))
            .setter(setter(Builder::compilationJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobName").build())
            .build();

    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(CreateEdgePackagingJobRequest::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelVersion").getter(getter(CreateEdgePackagingJobRequest::modelVersion))
            .setter(setter(Builder::modelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateEdgePackagingJobRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<EdgeOutputConfig> OUTPUT_CONFIG_FIELD = SdkField
            .<EdgeOutputConfig> builder(MarshallingType.SDK_POJO).memberName("OutputConfig")
            .getter(getter(CreateEdgePackagingJobRequest::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(EdgeOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<String> RESOURCE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceKey").getter(getter(CreateEdgePackagingJobRequest::resourceKey))
            .setter(setter(Builder::resourceKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceKey").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateEdgePackagingJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDGE_PACKAGING_JOB_NAME_FIELD,
            COMPILATION_JOB_NAME_FIELD, MODEL_NAME_FIELD, MODEL_VERSION_FIELD, ROLE_ARN_FIELD, OUTPUT_CONFIG_FIELD,
            RESOURCE_KEY_FIELD, TAGS_FIELD));

    private final String edgePackagingJobName;

    private final String compilationJobName;

    private final String modelName;

    private final String modelVersion;

    private final String roleArn;

    private final EdgeOutputConfig outputConfig;

    private final String resourceKey;

    private final List<Tag> tags;

    private CreateEdgePackagingJobRequest(BuilderImpl builder) {
        super(builder);
        this.edgePackagingJobName = builder.edgePackagingJobName;
        this.compilationJobName = builder.compilationJobName;
        this.modelName = builder.modelName;
        this.modelVersion = builder.modelVersion;
        this.roleArn = builder.roleArn;
        this.outputConfig = builder.outputConfig;
        this.resourceKey = builder.resourceKey;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the edge packaging job.
     * </p>
     * 
     * @return The name of the edge packaging job.
     */
    public final String edgePackagingJobName() {
        return edgePackagingJobName;
    }

    /**
     * <p>
     * The name of the SageMaker Neo compilation job that will be used to locate model artifacts for packaging.
     * </p>
     * 
     * @return The name of the SageMaker Neo compilation job that will be used to locate model artifacts for packaging.
     */
    public final String compilationJobName() {
        return compilationJobName;
    }

    /**
     * <p>
     * The name of the model.
     * </p>
     * 
     * @return The name of the model.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The version of the model.
     * </p>
     * 
     * @return The version of the model.
     */
    public final String modelVersion() {
        return modelVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to download and upload the model, and
     * to contact SageMaker Neo.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to download and upload the
     *         model, and to contact SageMaker Neo.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Provides information about the output location for the packaged model.
     * </p>
     * 
     * @return Provides information about the output location for the packaged model.
     */
    public final EdgeOutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key to use when encrypting the EBS volume the edge packaging job runs on.
     * </p>
     * 
     * @return The Amazon Web Services KMS key to use when encrypting the EBS volume the edge packaging job runs on.
     */
    public final String resourceKey() {
        return resourceKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Creates tags for the packaging job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Creates tags for the packaging job.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(edgePackagingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(compilationJobName());
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(resourceKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEdgePackagingJobRequest)) {
            return false;
        }
        CreateEdgePackagingJobRequest other = (CreateEdgePackagingJobRequest) obj;
        return Objects.equals(edgePackagingJobName(), other.edgePackagingJobName())
                && Objects.equals(compilationJobName(), other.compilationJobName())
                && Objects.equals(modelName(), other.modelName()) && Objects.equals(modelVersion(), other.modelVersion())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(outputConfig(), other.outputConfig())
                && Objects.equals(resourceKey(), other.resourceKey()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEdgePackagingJobRequest").add("EdgePackagingJobName", edgePackagingJobName())
                .add("CompilationJobName", compilationJobName()).add("ModelName", modelName())
                .add("ModelVersion", modelVersion()).add("RoleArn", roleArn()).add("OutputConfig", outputConfig())
                .add("ResourceKey", resourceKey()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EdgePackagingJobName":
            return Optional.ofNullable(clazz.cast(edgePackagingJobName()));
        case "CompilationJobName":
            return Optional.ofNullable(clazz.cast(compilationJobName()));
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "ModelVersion":
            return Optional.ofNullable(clazz.cast(modelVersion()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "ResourceKey":
            return Optional.ofNullable(clazz.cast(resourceKey()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEdgePackagingJobRequest, T> g) {
        return obj -> g.apply((CreateEdgePackagingJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateEdgePackagingJobRequest> {
        /**
         * <p>
         * The name of the edge packaging job.
         * </p>
         * 
         * @param edgePackagingJobName
         *        The name of the edge packaging job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgePackagingJobName(String edgePackagingJobName);

        /**
         * <p>
         * The name of the SageMaker Neo compilation job that will be used to locate model artifacts for packaging.
         * </p>
         * 
         * @param compilationJobName
         *        The name of the SageMaker Neo compilation job that will be used to locate model artifacts for
         *        packaging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compilationJobName(String compilationJobName);

        /**
         * <p>
         * The name of the model.
         * </p>
         * 
         * @param modelName
         *        The name of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The version of the model.
         * </p>
         * 
         * @param modelVersion
         *        The version of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersion(String modelVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to download and upload the model,
         * and to contact SageMaker Neo.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to download and upload the
         *        model, and to contact SageMaker Neo.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Provides information about the output location for the packaged model.
         * </p>
         * 
         * @param outputConfig
         *        Provides information about the output location for the packaged model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(EdgeOutputConfig outputConfig);

        /**
         * <p>
         * Provides information about the output location for the packaged model.
         * </p>
         * This is a convenience method that creates an instance of the {@link EdgeOutputConfig.Builder} avoiding the
         * need to create one manually via {@link EdgeOutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link EdgeOutputConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputConfig(EdgeOutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link EdgeOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(EdgeOutputConfig)
         */
        default Builder outputConfig(Consumer<EdgeOutputConfig.Builder> outputConfig) {
            return outputConfig(EdgeOutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * The Amazon Web Services KMS key to use when encrypting the EBS volume the edge packaging job runs on.
         * </p>
         * 
         * @param resourceKey
         *        The Amazon Web Services KMS key to use when encrypting the EBS volume the edge packaging job runs on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceKey(String resourceKey);

        /**
         * <p>
         * Creates tags for the packaging job.
         * </p>
         * 
         * @param tags
         *        Creates tags for the packaging job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Creates tags for the packaging job.
         * </p>
         * 
         * @param tags
         *        Creates tags for the packaging job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Creates tags for the packaging job.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String edgePackagingJobName;

        private String compilationJobName;

        private String modelName;

        private String modelVersion;

        private String roleArn;

        private EdgeOutputConfig outputConfig;

        private String resourceKey;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEdgePackagingJobRequest model) {
            super(model);
            edgePackagingJobName(model.edgePackagingJobName);
            compilationJobName(model.compilationJobName);
            modelName(model.modelName);
            modelVersion(model.modelVersion);
            roleArn(model.roleArn);
            outputConfig(model.outputConfig);
            resourceKey(model.resourceKey);
            tags(model.tags);
        }

        public final String getEdgePackagingJobName() {
            return edgePackagingJobName;
        }

        public final void setEdgePackagingJobName(String edgePackagingJobName) {
            this.edgePackagingJobName = edgePackagingJobName;
        }

        @Override
        @Transient
        public final Builder edgePackagingJobName(String edgePackagingJobName) {
            this.edgePackagingJobName = edgePackagingJobName;
            return this;
        }

        public final String getCompilationJobName() {
            return compilationJobName;
        }

        public final void setCompilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
        }

        @Override
        @Transient
        public final Builder compilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
            return this;
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        @Transient
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelVersion() {
            return modelVersion;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        @Transient
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final EdgeOutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(EdgeOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder outputConfig(EdgeOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final String getResourceKey() {
            return resourceKey;
        }

        public final void setResourceKey(String resourceKey) {
            this.resourceKey = resourceKey;
        }

        @Override
        @Transient
        public final Builder resourceKey(String resourceKey) {
            this.resourceKey = resourceKey;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEdgePackagingJobRequest build() {
            return new CreateEdgePackagingJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
