/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStudioLifecycleConfigRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateStudioLifecycleConfigRequest.Builder, CreateStudioLifecycleConfigRequest> {
    private static final SdkField<String> STUDIO_LIFECYCLE_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StudioLifecycleConfigName")
            .getter(getter(CreateStudioLifecycleConfigRequest::studioLifecycleConfigName))
            .setter(setter(Builder::studioLifecycleConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StudioLifecycleConfigName").build())
            .build();

    private static final SdkField<String> STUDIO_LIFECYCLE_CONFIG_CONTENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StudioLifecycleConfigContent")
            .getter(getter(CreateStudioLifecycleConfigRequest::studioLifecycleConfigContent))
            .setter(setter(Builder::studioLifecycleConfigContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StudioLifecycleConfigContent")
                    .build()).build();

    private static final SdkField<String> STUDIO_LIFECYCLE_CONFIG_APP_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StudioLifecycleConfigAppType")
            .getter(getter(CreateStudioLifecycleConfigRequest::studioLifecycleConfigAppTypeAsString))
            .setter(setter(Builder::studioLifecycleConfigAppType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StudioLifecycleConfigAppType")
                    .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateStudioLifecycleConfigRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STUDIO_LIFECYCLE_CONFIG_NAME_FIELD, STUDIO_LIFECYCLE_CONFIG_CONTENT_FIELD, STUDIO_LIFECYCLE_CONFIG_APP_TYPE_FIELD,
            TAGS_FIELD));

    private final String studioLifecycleConfigName;

    private final String studioLifecycleConfigContent;

    private final String studioLifecycleConfigAppType;

    private final List<Tag> tags;

    private CreateStudioLifecycleConfigRequest(BuilderImpl builder) {
        super(builder);
        this.studioLifecycleConfigName = builder.studioLifecycleConfigName;
        this.studioLifecycleConfigContent = builder.studioLifecycleConfigContent;
        this.studioLifecycleConfigAppType = builder.studioLifecycleConfigAppType;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the Studio Lifecycle Configuration to create.
     * </p>
     * 
     * @return The name of the Studio Lifecycle Configuration to create.
     */
    public final String studioLifecycleConfigName() {
        return studioLifecycleConfigName;
    }

    /**
     * <p>
     * The content of your Studio Lifecycle Configuration script. This content must be base64 encoded.
     * </p>
     * 
     * @return The content of your Studio Lifecycle Configuration script. This content must be base64 encoded.
     */
    public final String studioLifecycleConfigContent() {
        return studioLifecycleConfigContent;
    }

    /**
     * <p>
     * The App type that the Lifecycle Configuration is attached to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #studioLifecycleConfigAppType} will return {@link StudioLifecycleConfigAppType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #studioLifecycleConfigAppTypeAsString}.
     * </p>
     * 
     * @return The App type that the Lifecycle Configuration is attached to.
     * @see StudioLifecycleConfigAppType
     */
    public final StudioLifecycleConfigAppType studioLifecycleConfigAppType() {
        return StudioLifecycleConfigAppType.fromValue(studioLifecycleConfigAppType);
    }

    /**
     * <p>
     * The App type that the Lifecycle Configuration is attached to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #studioLifecycleConfigAppType} will return {@link StudioLifecycleConfigAppType#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #studioLifecycleConfigAppTypeAsString}.
     * </p>
     * 
     * @return The App type that the Lifecycle Configuration is attached to.
     * @see StudioLifecycleConfigAppType
     */
    public final String studioLifecycleConfigAppTypeAsString() {
        return studioLifecycleConfigAppType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags to be associated with the Lifecycle Configuration. Each tag consists of a key and an optional value. Tag
     * keys must be unique per resource. Tags are searchable using the Search API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags to be associated with the Lifecycle Configuration. Each tag consists of a key and an optional value.
     *         Tag keys must be unique per resource. Tags are searchable using the Search API.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(studioLifecycleConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(studioLifecycleConfigContent());
        hashCode = 31 * hashCode + Objects.hashCode(studioLifecycleConfigAppTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStudioLifecycleConfigRequest)) {
            return false;
        }
        CreateStudioLifecycleConfigRequest other = (CreateStudioLifecycleConfigRequest) obj;
        return Objects.equals(studioLifecycleConfigName(), other.studioLifecycleConfigName())
                && Objects.equals(studioLifecycleConfigContent(), other.studioLifecycleConfigContent())
                && Objects.equals(studioLifecycleConfigAppTypeAsString(), other.studioLifecycleConfigAppTypeAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStudioLifecycleConfigRequest")
                .add("StudioLifecycleConfigName", studioLifecycleConfigName())
                .add("StudioLifecycleConfigContent", studioLifecycleConfigContent())
                .add("StudioLifecycleConfigAppType", studioLifecycleConfigAppTypeAsString())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StudioLifecycleConfigName":
            return Optional.ofNullable(clazz.cast(studioLifecycleConfigName()));
        case "StudioLifecycleConfigContent":
            return Optional.ofNullable(clazz.cast(studioLifecycleConfigContent()));
        case "StudioLifecycleConfigAppType":
            return Optional.ofNullable(clazz.cast(studioLifecycleConfigAppTypeAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStudioLifecycleConfigRequest, T> g) {
        return obj -> g.apply((CreateStudioLifecycleConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateStudioLifecycleConfigRequest> {
        /**
         * <p>
         * The name of the Studio Lifecycle Configuration to create.
         * </p>
         * 
         * @param studioLifecycleConfigName
         *        The name of the Studio Lifecycle Configuration to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioLifecycleConfigName(String studioLifecycleConfigName);

        /**
         * <p>
         * The content of your Studio Lifecycle Configuration script. This content must be base64 encoded.
         * </p>
         * 
         * @param studioLifecycleConfigContent
         *        The content of your Studio Lifecycle Configuration script. This content must be base64 encoded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioLifecycleConfigContent(String studioLifecycleConfigContent);

        /**
         * <p>
         * The App type that the Lifecycle Configuration is attached to.
         * </p>
         * 
         * @param studioLifecycleConfigAppType
         *        The App type that the Lifecycle Configuration is attached to.
         * @see StudioLifecycleConfigAppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StudioLifecycleConfigAppType
         */
        Builder studioLifecycleConfigAppType(String studioLifecycleConfigAppType);

        /**
         * <p>
         * The App type that the Lifecycle Configuration is attached to.
         * </p>
         * 
         * @param studioLifecycleConfigAppType
         *        The App type that the Lifecycle Configuration is attached to.
         * @see StudioLifecycleConfigAppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StudioLifecycleConfigAppType
         */
        Builder studioLifecycleConfigAppType(StudioLifecycleConfigAppType studioLifecycleConfigAppType);

        /**
         * <p>
         * Tags to be associated with the Lifecycle Configuration. Each tag consists of a key and an optional value. Tag
         * keys must be unique per resource. Tags are searchable using the Search API.
         * </p>
         * 
         * @param tags
         *        Tags to be associated with the Lifecycle Configuration. Each tag consists of a key and an optional
         *        value. Tag keys must be unique per resource. Tags are searchable using the Search API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags to be associated with the Lifecycle Configuration. Each tag consists of a key and an optional value. Tag
         * keys must be unique per resource. Tags are searchable using the Search API.
         * </p>
         * 
         * @param tags
         *        Tags to be associated with the Lifecycle Configuration. Each tag consists of a key and an optional
         *        value. Tag keys must be unique per resource. Tags are searchable using the Search API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags to be associated with the Lifecycle Configuration. Each tag consists of a key and an optional value. Tag
         * keys must be unique per resource. Tags are searchable using the Search API.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String studioLifecycleConfigName;

        private String studioLifecycleConfigContent;

        private String studioLifecycleConfigAppType;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStudioLifecycleConfigRequest model) {
            super(model);
            studioLifecycleConfigName(model.studioLifecycleConfigName);
            studioLifecycleConfigContent(model.studioLifecycleConfigContent);
            studioLifecycleConfigAppType(model.studioLifecycleConfigAppType);
            tags(model.tags);
        }

        public final String getStudioLifecycleConfigName() {
            return studioLifecycleConfigName;
        }

        public final void setStudioLifecycleConfigName(String studioLifecycleConfigName) {
            this.studioLifecycleConfigName = studioLifecycleConfigName;
        }

        @Override
        @Transient
        public final Builder studioLifecycleConfigName(String studioLifecycleConfigName) {
            this.studioLifecycleConfigName = studioLifecycleConfigName;
            return this;
        }

        public final String getStudioLifecycleConfigContent() {
            return studioLifecycleConfigContent;
        }

        public final void setStudioLifecycleConfigContent(String studioLifecycleConfigContent) {
            this.studioLifecycleConfigContent = studioLifecycleConfigContent;
        }

        @Override
        @Transient
        public final Builder studioLifecycleConfigContent(String studioLifecycleConfigContent) {
            this.studioLifecycleConfigContent = studioLifecycleConfigContent;
            return this;
        }

        public final String getStudioLifecycleConfigAppType() {
            return studioLifecycleConfigAppType;
        }

        public final void setStudioLifecycleConfigAppType(String studioLifecycleConfigAppType) {
            this.studioLifecycleConfigAppType = studioLifecycleConfigAppType;
        }

        @Override
        @Transient
        public final Builder studioLifecycleConfigAppType(String studioLifecycleConfigAppType) {
            this.studioLifecycleConfigAppType = studioLifecycleConfigAppType;
            return this;
        }

        @Override
        @Transient
        public final Builder studioLifecycleConfigAppType(StudioLifecycleConfigAppType studioLifecycleConfigAppType) {
            this.studioLifecycleConfigAppType(studioLifecycleConfigAppType == null ? null : studioLifecycleConfigAppType
                    .toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStudioLifecycleConfigRequest build() {
            return new CreateStudioLifecycleConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
