/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDomainRequest extends SageMakerRequest implements
        ToCopyableBuilder<DeleteDomainRequest.Builder, DeleteDomainRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(DeleteDomainRequest::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<RetentionPolicy> RETENTION_POLICY_FIELD = SdkField
            .<RetentionPolicy> builder(MarshallingType.SDK_POJO).memberName("RetentionPolicy")
            .getter(getter(DeleteDomainRequest::retentionPolicy)).setter(setter(Builder::retentionPolicy))
            .constructor(RetentionPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            RETENTION_POLICY_FIELD));

    private final String domainId;

    private final RetentionPolicy retentionPolicy;

    private DeleteDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.retentionPolicy = builder.retentionPolicy;
    }

    /**
     * <p>
     * The domain ID.
     * </p>
     * 
     * @return The domain ID.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The retention policy for this domain, which specifies whether resources will be retained after the Domain is
     * deleted. By default, all resources are retained (not automatically deleted).
     * </p>
     * 
     * @return The retention policy for this domain, which specifies whether resources will be retained after the Domain
     *         is deleted. By default, all resources are retained (not automatically deleted).
     */
    public final RetentionPolicy retentionPolicy() {
        return retentionPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDomainRequest)) {
            return false;
        }
        DeleteDomainRequest other = (DeleteDomainRequest) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(retentionPolicy(), other.retentionPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteDomainRequest").add("DomainId", domainId()).add("RetentionPolicy", retentionPolicy())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "RetentionPolicy":
            return Optional.ofNullable(clazz.cast(retentionPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDomainRequest, T> g) {
        return obj -> g.apply((DeleteDomainRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteDomainRequest> {
        /**
         * <p>
         * The domain ID.
         * </p>
         * 
         * @param domainId
         *        The domain ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The retention policy for this domain, which specifies whether resources will be retained after the Domain is
         * deleted. By default, all resources are retained (not automatically deleted).
         * </p>
         * 
         * @param retentionPolicy
         *        The retention policy for this domain, which specifies whether resources will be retained after the
         *        Domain is deleted. By default, all resources are retained (not automatically deleted).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPolicy(RetentionPolicy retentionPolicy);

        /**
         * <p>
         * The retention policy for this domain, which specifies whether resources will be retained after the Domain is
         * deleted. By default, all resources are retained (not automatically deleted).
         * </p>
         * This is a convenience method that creates an instance of the {@link RetentionPolicy.Builder} avoiding the
         * need to create one manually via {@link RetentionPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link RetentionPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #retentionPolicy(RetentionPolicy)}.
         * 
         * @param retentionPolicy
         *        a consumer that will call methods on {@link RetentionPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionPolicy(RetentionPolicy)
         */
        default Builder retentionPolicy(Consumer<RetentionPolicy.Builder> retentionPolicy) {
            return retentionPolicy(RetentionPolicy.builder().applyMutation(retentionPolicy).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String domainId;

        private RetentionPolicy retentionPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDomainRequest model) {
            super(model);
            domainId(model.domainId);
            retentionPolicy(model.retentionPolicy);
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        @Transient
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final RetentionPolicy.Builder getRetentionPolicy() {
            return retentionPolicy != null ? retentionPolicy.toBuilder() : null;
        }

        public final void setRetentionPolicy(RetentionPolicy.BuilderImpl retentionPolicy) {
            this.retentionPolicy = retentionPolicy != null ? retentionPolicy.build() : null;
        }

        @Override
        @Transient
        public final Builder retentionPolicy(RetentionPolicy retentionPolicy) {
            this.retentionPolicy = retentionPolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDomainRequest build() {
            return new DeleteDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
