/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWorkteamResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeWorkteamResponse.Builder, DescribeWorkteamResponse> {
    private static final SdkField<Workteam> WORKTEAM_FIELD = SdkField.<Workteam> builder(MarshallingType.SDK_POJO)
            .memberName("Workteam").getter(getter(DescribeWorkteamResponse::workteam)).setter(setter(Builder::workteam))
            .constructor(Workteam::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Workteam").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKTEAM_FIELD));

    private final Workteam workteam;

    private DescribeWorkteamResponse(BuilderImpl builder) {
        super(builder);
        this.workteam = builder.workteam;
    }

    /**
     * <p>
     * A <code>Workteam</code> instance that contains information about the work team.
     * </p>
     * 
     * @return A <code>Workteam</code> instance that contains information about the work team.
     */
    public final Workteam workteam() {
        return workteam;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workteam());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkteamResponse)) {
            return false;
        }
        DescribeWorkteamResponse other = (DescribeWorkteamResponse) obj;
        return Objects.equals(workteam(), other.workteam());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWorkteamResponse").add("Workteam", workteam()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Workteam":
            return Optional.ofNullable(clazz.cast(workteam()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkteamResponse, T> g) {
        return obj -> g.apply((DescribeWorkteamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeWorkteamResponse> {
        /**
         * <p>
         * A <code>Workteam</code> instance that contains information about the work team.
         * </p>
         * 
         * @param workteam
         *        A <code>Workteam</code> instance that contains information about the work team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workteam(Workteam workteam);

        /**
         * <p>
         * A <code>Workteam</code> instance that contains information about the work team.
         * </p>
         * This is a convenience method that creates an instance of the {@link Workteam.Builder} avoiding the need to
         * create one manually via {@link Workteam#builder()}.
         *
         * When the {@link Consumer} completes, {@link Workteam.Builder#build()} is called immediately and its result is
         * passed to {@link #workteam(Workteam)}.
         * 
         * @param workteam
         *        a consumer that will call methods on {@link Workteam.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workteam(Workteam)
         */
        default Builder workteam(Consumer<Workteam.Builder> workteam) {
            return workteam(Workteam.builder().applyMutation(workteam).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private Workteam workteam;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkteamResponse model) {
            super(model);
            workteam(model.workteam);
        }

        public final Workteam.Builder getWorkteam() {
            return workteam != null ? workteam.toBuilder() : null;
        }

        public final void setWorkteam(Workteam.BuilderImpl workteam) {
            this.workteam = workteam != null ? workteam.build() : null;
        }

        @Override
        @Transient
        public final Builder workteam(Workteam workteam) {
            this.workteam = workteam;
            return this;
        }

        @Override
        public DescribeWorkteamResponse build() {
            return new DescribeWorkteamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
