/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the range of environment parameters
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentParameterRanges implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentParameterRanges.Builder, EnvironmentParameterRanges> {
    private static final SdkField<List<CategoricalParameter>> CATEGORICAL_PARAMETER_RANGES_FIELD = SdkField
            .<List<CategoricalParameter>> builder(MarshallingType.LIST)
            .memberName("CategoricalParameterRanges")
            .getter(getter(EnvironmentParameterRanges::categoricalParameterRanges))
            .setter(setter(Builder::categoricalParameterRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoricalParameterRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CategoricalParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CategoricalParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CATEGORICAL_PARAMETER_RANGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<CategoricalParameter> categoricalParameterRanges;

    private EnvironmentParameterRanges(BuilderImpl builder) {
        this.categoricalParameterRanges = builder.categoricalParameterRanges;
    }

    /**
     * For responses, this returns true if the service returned a value for the CategoricalParameterRanges property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCategoricalParameterRanges() {
        return categoricalParameterRanges != null && !(categoricalParameterRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specified a list of parameters for each category.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategoricalParameterRanges} method.
     * </p>
     * 
     * @return Specified a list of parameters for each category.
     */
    public final List<CategoricalParameter> categoricalParameterRanges() {
        return categoricalParameterRanges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCategoricalParameterRanges() ? categoricalParameterRanges() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentParameterRanges)) {
            return false;
        }
        EnvironmentParameterRanges other = (EnvironmentParameterRanges) obj;
        return hasCategoricalParameterRanges() == other.hasCategoricalParameterRanges()
                && Objects.equals(categoricalParameterRanges(), other.categoricalParameterRanges());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentParameterRanges")
                .add("CategoricalParameterRanges", hasCategoricalParameterRanges() ? categoricalParameterRanges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CategoricalParameterRanges":
            return Optional.ofNullable(clazz.cast(categoricalParameterRanges()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentParameterRanges, T> g) {
        return obj -> g.apply((EnvironmentParameterRanges) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentParameterRanges> {
        /**
         * <p>
         * Specified a list of parameters for each category.
         * </p>
         * 
         * @param categoricalParameterRanges
         *        Specified a list of parameters for each category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoricalParameterRanges(Collection<CategoricalParameter> categoricalParameterRanges);

        /**
         * <p>
         * Specified a list of parameters for each category.
         * </p>
         * 
         * @param categoricalParameterRanges
         *        Specified a list of parameters for each category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoricalParameterRanges(CategoricalParameter... categoricalParameterRanges);

        /**
         * <p>
         * Specified a list of parameters for each category.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<CategoricalParameter>.Builder}
         * avoiding the need to create one manually via {@link List<CategoricalParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CategoricalParameter>.Builder#build()} is called immediately
         * and its result is passed to {@link #categoricalParameterRanges(List<CategoricalParameter>)}.
         * 
         * @param categoricalParameterRanges
         *        a consumer that will call methods on {@link List<CategoricalParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoricalParameterRanges(List<CategoricalParameter>)
         */
        Builder categoricalParameterRanges(Consumer<CategoricalParameter.Builder>... categoricalParameterRanges);
    }

    static final class BuilderImpl implements Builder {
        private List<CategoricalParameter> categoricalParameterRanges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentParameterRanges model) {
            categoricalParameterRanges(model.categoricalParameterRanges);
        }

        public final List<CategoricalParameter.Builder> getCategoricalParameterRanges() {
            List<CategoricalParameter.Builder> result = CategoricalParametersCopier
                    .copyToBuilder(this.categoricalParameterRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategoricalParameterRanges(Collection<CategoricalParameter.BuilderImpl> categoricalParameterRanges) {
            this.categoricalParameterRanges = CategoricalParametersCopier.copyFromBuilder(categoricalParameterRanges);
        }

        @Override
        @Transient
        public final Builder categoricalParameterRanges(Collection<CategoricalParameter> categoricalParameterRanges) {
            this.categoricalParameterRanges = CategoricalParametersCopier.copy(categoricalParameterRanges);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder categoricalParameterRanges(CategoricalParameter... categoricalParameterRanges) {
            categoricalParameterRanges(Arrays.asList(categoricalParameterRanges));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder categoricalParameterRanges(Consumer<CategoricalParameter.Builder>... categoricalParameterRanges) {
            categoricalParameterRanges(Stream.of(categoricalParameterRanges)
                    .map(c -> CategoricalParameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public EnvironmentParameterRanges build() {
            return new EnvironmentParameterRanges(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
