/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeviceFleetReportResponse extends SageMakerResponse implements
        ToCopyableBuilder<GetDeviceFleetReportResponse.Builder, GetDeviceFleetReportResponse> {
    private static final SdkField<String> DEVICE_FLEET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceFleetArn").getter(getter(GetDeviceFleetReportResponse::deviceFleetArn))
            .setter(setter(Builder::deviceFleetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetArn").build()).build();

    private static final SdkField<String> DEVICE_FLEET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceFleetName").getter(getter(GetDeviceFleetReportResponse::deviceFleetName))
            .setter(setter(Builder::deviceFleetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetName").build()).build();

    private static final SdkField<EdgeOutputConfig> OUTPUT_CONFIG_FIELD = SdkField
            .<EdgeOutputConfig> builder(MarshallingType.SDK_POJO).memberName("OutputConfig")
            .getter(getter(GetDeviceFleetReportResponse::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(EdgeOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetDeviceFleetReportResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> REPORT_GENERATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReportGenerated").getter(getter(GetDeviceFleetReportResponse::reportGenerated))
            .setter(setter(Builder::reportGenerated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportGenerated").build()).build();

    private static final SdkField<DeviceStats> DEVICE_STATS_FIELD = SdkField.<DeviceStats> builder(MarshallingType.SDK_POJO)
            .memberName("DeviceStats").getter(getter(GetDeviceFleetReportResponse::deviceStats))
            .setter(setter(Builder::deviceStats)).constructor(DeviceStats::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceStats").build()).build();

    private static final SdkField<List<AgentVersion>> AGENT_VERSIONS_FIELD = SdkField
            .<List<AgentVersion>> builder(MarshallingType.LIST)
            .memberName("AgentVersions")
            .getter(getter(GetDeviceFleetReportResponse::agentVersions))
            .setter(setter(Builder::agentVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AgentVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(AgentVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EdgeModelStat>> MODEL_STATS_FIELD = SdkField
            .<List<EdgeModelStat>> builder(MarshallingType.LIST)
            .memberName("ModelStats")
            .getter(getter(GetDeviceFleetReportResponse::modelStats))
            .setter(setter(Builder::modelStats))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelStats").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EdgeModelStat> builder(MarshallingType.SDK_POJO)
                                            .constructor(EdgeModelStat::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_FLEET_ARN_FIELD,
            DEVICE_FLEET_NAME_FIELD, OUTPUT_CONFIG_FIELD, DESCRIPTION_FIELD, REPORT_GENERATED_FIELD, DEVICE_STATS_FIELD,
            AGENT_VERSIONS_FIELD, MODEL_STATS_FIELD));

    private final String deviceFleetArn;

    private final String deviceFleetName;

    private final EdgeOutputConfig outputConfig;

    private final String description;

    private final Instant reportGenerated;

    private final DeviceStats deviceStats;

    private final List<AgentVersion> agentVersions;

    private final List<EdgeModelStat> modelStats;

    private GetDeviceFleetReportResponse(BuilderImpl builder) {
        super(builder);
        this.deviceFleetArn = builder.deviceFleetArn;
        this.deviceFleetName = builder.deviceFleetName;
        this.outputConfig = builder.outputConfig;
        this.description = builder.description;
        this.reportGenerated = builder.reportGenerated;
        this.deviceStats = builder.deviceStats;
        this.agentVersions = builder.agentVersions;
        this.modelStats = builder.modelStats;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the device.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the device.
     */
    public final String deviceFleetArn() {
        return deviceFleetArn;
    }

    /**
     * <p>
     * The name of the fleet.
     * </p>
     * 
     * @return The name of the fleet.
     */
    public final String deviceFleetName() {
        return deviceFleetName;
    }

    /**
     * <p>
     * The output configuration for storing sample data collected by the fleet.
     * </p>
     * 
     * @return The output configuration for storing sample data collected by the fleet.
     */
    public final EdgeOutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * Description of the fleet.
     * </p>
     * 
     * @return Description of the fleet.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Timestamp of when the report was generated.
     * </p>
     * 
     * @return Timestamp of when the report was generated.
     */
    public final Instant reportGenerated() {
        return reportGenerated;
    }

    /**
     * <p>
     * Status of devices.
     * </p>
     * 
     * @return Status of devices.
     */
    public final DeviceStats deviceStats() {
        return deviceStats;
    }

    /**
     * For responses, this returns true if the service returned a value for the AgentVersions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAgentVersions() {
        return agentVersions != null && !(agentVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The versions of Edge Manager agent deployed on the fleet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgentVersions} method.
     * </p>
     * 
     * @return The versions of Edge Manager agent deployed on the fleet.
     */
    public final List<AgentVersion> agentVersions() {
        return agentVersions;
    }

    /**
     * For responses, this returns true if the service returned a value for the ModelStats property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasModelStats() {
        return modelStats != null && !(modelStats instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Status of model on device.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModelStats} method.
     * </p>
     * 
     * @return Status of model on device.
     */
    public final List<EdgeModelStat> modelStats() {
        return modelStats;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceFleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceFleetName());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(reportGenerated());
        hashCode = 31 * hashCode + Objects.hashCode(deviceStats());
        hashCode = 31 * hashCode + Objects.hashCode(hasAgentVersions() ? agentVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasModelStats() ? modelStats() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeviceFleetReportResponse)) {
            return false;
        }
        GetDeviceFleetReportResponse other = (GetDeviceFleetReportResponse) obj;
        return Objects.equals(deviceFleetArn(), other.deviceFleetArn())
                && Objects.equals(deviceFleetName(), other.deviceFleetName())
                && Objects.equals(outputConfig(), other.outputConfig()) && Objects.equals(description(), other.description())
                && Objects.equals(reportGenerated(), other.reportGenerated())
                && Objects.equals(deviceStats(), other.deviceStats()) && hasAgentVersions() == other.hasAgentVersions()
                && Objects.equals(agentVersions(), other.agentVersions()) && hasModelStats() == other.hasModelStats()
                && Objects.equals(modelStats(), other.modelStats());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDeviceFleetReportResponse").add("DeviceFleetArn", deviceFleetArn())
                .add("DeviceFleetName", deviceFleetName()).add("OutputConfig", outputConfig()).add("Description", description())
                .add("ReportGenerated", reportGenerated()).add("DeviceStats", deviceStats())
                .add("AgentVersions", hasAgentVersions() ? agentVersions() : null)
                .add("ModelStats", hasModelStats() ? modelStats() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceFleetArn":
            return Optional.ofNullable(clazz.cast(deviceFleetArn()));
        case "DeviceFleetName":
            return Optional.ofNullable(clazz.cast(deviceFleetName()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ReportGenerated":
            return Optional.ofNullable(clazz.cast(reportGenerated()));
        case "DeviceStats":
            return Optional.ofNullable(clazz.cast(deviceStats()));
        case "AgentVersions":
            return Optional.ofNullable(clazz.cast(agentVersions()));
        case "ModelStats":
            return Optional.ofNullable(clazz.cast(modelStats()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDeviceFleetReportResponse, T> g) {
        return obj -> g.apply((GetDeviceFleetReportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDeviceFleetReportResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the device.
         * </p>
         * 
         * @param deviceFleetArn
         *        The Amazon Resource Name (ARN) of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceFleetArn(String deviceFleetArn);

        /**
         * <p>
         * The name of the fleet.
         * </p>
         * 
         * @param deviceFleetName
         *        The name of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceFleetName(String deviceFleetName);

        /**
         * <p>
         * The output configuration for storing sample data collected by the fleet.
         * </p>
         * 
         * @param outputConfig
         *        The output configuration for storing sample data collected by the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(EdgeOutputConfig outputConfig);

        /**
         * <p>
         * The output configuration for storing sample data collected by the fleet.
         * </p>
         * This is a convenience method that creates an instance of the {@link EdgeOutputConfig.Builder} avoiding the
         * need to create one manually via {@link EdgeOutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link EdgeOutputConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputConfig(EdgeOutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link EdgeOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(EdgeOutputConfig)
         */
        default Builder outputConfig(Consumer<EdgeOutputConfig.Builder> outputConfig) {
            return outputConfig(EdgeOutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * Description of the fleet.
         * </p>
         * 
         * @param description
         *        Description of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Timestamp of when the report was generated.
         * </p>
         * 
         * @param reportGenerated
         *        Timestamp of when the report was generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportGenerated(Instant reportGenerated);

        /**
         * <p>
         * Status of devices.
         * </p>
         * 
         * @param deviceStats
         *        Status of devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceStats(DeviceStats deviceStats);

        /**
         * <p>
         * Status of devices.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeviceStats.Builder} avoiding the need to
         * create one manually via {@link DeviceStats#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeviceStats.Builder#build()} is called immediately and its result
         * is passed to {@link #deviceStats(DeviceStats)}.
         * 
         * @param deviceStats
         *        a consumer that will call methods on {@link DeviceStats.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceStats(DeviceStats)
         */
        default Builder deviceStats(Consumer<DeviceStats.Builder> deviceStats) {
            return deviceStats(DeviceStats.builder().applyMutation(deviceStats).build());
        }

        /**
         * <p>
         * The versions of Edge Manager agent deployed on the fleet.
         * </p>
         * 
         * @param agentVersions
         *        The versions of Edge Manager agent deployed on the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersions(Collection<AgentVersion> agentVersions);

        /**
         * <p>
         * The versions of Edge Manager agent deployed on the fleet.
         * </p>
         * 
         * @param agentVersions
         *        The versions of Edge Manager agent deployed on the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersions(AgentVersion... agentVersions);

        /**
         * <p>
         * The versions of Edge Manager agent deployed on the fleet.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AgentVersion>.Builder} avoiding the
         * need to create one manually via {@link List<AgentVersion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AgentVersion>.Builder#build()} is called immediately and its
         * result is passed to {@link #agentVersions(List<AgentVersion>)}.
         * 
         * @param agentVersions
         *        a consumer that will call methods on {@link List<AgentVersion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentVersions(List<AgentVersion>)
         */
        Builder agentVersions(Consumer<AgentVersion.Builder>... agentVersions);

        /**
         * <p>
         * Status of model on device.
         * </p>
         * 
         * @param modelStats
         *        Status of model on device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelStats(Collection<EdgeModelStat> modelStats);

        /**
         * <p>
         * Status of model on device.
         * </p>
         * 
         * @param modelStats
         *        Status of model on device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelStats(EdgeModelStat... modelStats);

        /**
         * <p>
         * Status of model on device.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<EdgeModelStat>.Builder} avoiding the
         * need to create one manually via {@link List<EdgeModelStat>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EdgeModelStat>.Builder#build()} is called immediately and
         * its result is passed to {@link #modelStats(List<EdgeModelStat>)}.
         * 
         * @param modelStats
         *        a consumer that will call methods on {@link List<EdgeModelStat>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelStats(List<EdgeModelStat>)
         */
        Builder modelStats(Consumer<EdgeModelStat.Builder>... modelStats);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String deviceFleetArn;

        private String deviceFleetName;

        private EdgeOutputConfig outputConfig;

        private String description;

        private Instant reportGenerated;

        private DeviceStats deviceStats;

        private List<AgentVersion> agentVersions = DefaultSdkAutoConstructList.getInstance();

        private List<EdgeModelStat> modelStats = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeviceFleetReportResponse model) {
            super(model);
            deviceFleetArn(model.deviceFleetArn);
            deviceFleetName(model.deviceFleetName);
            outputConfig(model.outputConfig);
            description(model.description);
            reportGenerated(model.reportGenerated);
            deviceStats(model.deviceStats);
            agentVersions(model.agentVersions);
            modelStats(model.modelStats);
        }

        public final String getDeviceFleetArn() {
            return deviceFleetArn;
        }

        public final void setDeviceFleetArn(String deviceFleetArn) {
            this.deviceFleetArn = deviceFleetArn;
        }

        @Override
        @Transient
        public final Builder deviceFleetArn(String deviceFleetArn) {
            this.deviceFleetArn = deviceFleetArn;
            return this;
        }

        public final String getDeviceFleetName() {
            return deviceFleetName;
        }

        public final void setDeviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
        }

        @Override
        @Transient
        public final Builder deviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
            return this;
        }

        public final EdgeOutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(EdgeOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder outputConfig(EdgeOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getReportGenerated() {
            return reportGenerated;
        }

        public final void setReportGenerated(Instant reportGenerated) {
            this.reportGenerated = reportGenerated;
        }

        @Override
        @Transient
        public final Builder reportGenerated(Instant reportGenerated) {
            this.reportGenerated = reportGenerated;
            return this;
        }

        public final DeviceStats.Builder getDeviceStats() {
            return deviceStats != null ? deviceStats.toBuilder() : null;
        }

        public final void setDeviceStats(DeviceStats.BuilderImpl deviceStats) {
            this.deviceStats = deviceStats != null ? deviceStats.build() : null;
        }

        @Override
        @Transient
        public final Builder deviceStats(DeviceStats deviceStats) {
            this.deviceStats = deviceStats;
            return this;
        }

        public final List<AgentVersion.Builder> getAgentVersions() {
            List<AgentVersion.Builder> result = AgentVersionsCopier.copyToBuilder(this.agentVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgentVersions(Collection<AgentVersion.BuilderImpl> agentVersions) {
            this.agentVersions = AgentVersionsCopier.copyFromBuilder(agentVersions);
        }

        @Override
        @Transient
        public final Builder agentVersions(Collection<AgentVersion> agentVersions) {
            this.agentVersions = AgentVersionsCopier.copy(agentVersions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder agentVersions(AgentVersion... agentVersions) {
            agentVersions(Arrays.asList(agentVersions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder agentVersions(Consumer<AgentVersion.Builder>... agentVersions) {
            agentVersions(Stream.of(agentVersions).map(c -> AgentVersion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<EdgeModelStat.Builder> getModelStats() {
            List<EdgeModelStat.Builder> result = EdgeModelStatsCopier.copyToBuilder(this.modelStats);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelStats(Collection<EdgeModelStat.BuilderImpl> modelStats) {
            this.modelStats = EdgeModelStatsCopier.copyFromBuilder(modelStats);
        }

        @Override
        @Transient
        public final Builder modelStats(Collection<EdgeModelStat> modelStats) {
            this.modelStats = EdgeModelStatsCopier.copy(modelStats);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder modelStats(EdgeModelStat... modelStats) {
            modelStats(Arrays.asList(modelStats));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder modelStats(Consumer<EdgeModelStat.Builder>... modelStats) {
            modelStats(Stream.of(modelStats).map(c -> EdgeModelStat.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetDeviceFleetReportResponse build() {
            return new GetDeviceFleetReportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
