/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input configuration information for a labeling job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LabelingJobInputConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<LabelingJobInputConfig.Builder, LabelingJobInputConfig> {
    private static final SdkField<LabelingJobDataSource> DATA_SOURCE_FIELD = SdkField
            .<LabelingJobDataSource> builder(MarshallingType.SDK_POJO).memberName("DataSource")
            .getter(getter(LabelingJobInputConfig::dataSource)).setter(setter(Builder::dataSource))
            .constructor(LabelingJobDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<LabelingJobDataAttributes> DATA_ATTRIBUTES_FIELD = SdkField
            .<LabelingJobDataAttributes> builder(MarshallingType.SDK_POJO).memberName("DataAttributes")
            .getter(getter(LabelingJobInputConfig::dataAttributes)).setter(setter(Builder::dataAttributes))
            .constructor(LabelingJobDataAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAttributes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD,
            DATA_ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final LabelingJobDataSource dataSource;

    private final LabelingJobDataAttributes dataAttributes;

    private LabelingJobInputConfig(BuilderImpl builder) {
        this.dataSource = builder.dataSource;
        this.dataAttributes = builder.dataAttributes;
    }

    /**
     * <p>
     * The location of the input data.
     * </p>
     * 
     * @return The location of the input data.
     */
    public final LabelingJobDataSource dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * Attributes of the data specified by the customer.
     * </p>
     * 
     * @return Attributes of the data specified by the customer.
     */
    public final LabelingJobDataAttributes dataAttributes() {
        return dataAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(dataAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelingJobInputConfig)) {
            return false;
        }
        LabelingJobInputConfig other = (LabelingJobInputConfig) obj;
        return Objects.equals(dataSource(), other.dataSource()) && Objects.equals(dataAttributes(), other.dataAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LabelingJobInputConfig").add("DataSource", dataSource()).add("DataAttributes", dataAttributes())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "DataAttributes":
            return Optional.ofNullable(clazz.cast(dataAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelingJobInputConfig, T> g) {
        return obj -> g.apply((LabelingJobInputConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LabelingJobInputConfig> {
        /**
         * <p>
         * The location of the input data.
         * </p>
         * 
         * @param dataSource
         *        The location of the input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(LabelingJobDataSource dataSource);

        /**
         * <p>
         * The location of the input data.
         * </p>
         * This is a convenience method that creates an instance of the {@link LabelingJobDataSource.Builder} avoiding
         * the need to create one manually via {@link LabelingJobDataSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link LabelingJobDataSource.Builder#build()} is called immediately and
         * its result is passed to {@link #dataSource(LabelingJobDataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link LabelingJobDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(LabelingJobDataSource)
         */
        default Builder dataSource(Consumer<LabelingJobDataSource.Builder> dataSource) {
            return dataSource(LabelingJobDataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * <p>
         * Attributes of the data specified by the customer.
         * </p>
         * 
         * @param dataAttributes
         *        Attributes of the data specified by the customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAttributes(LabelingJobDataAttributes dataAttributes);

        /**
         * <p>
         * Attributes of the data specified by the customer.
         * </p>
         * This is a convenience method that creates an instance of the {@link LabelingJobDataAttributes.Builder}
         * avoiding the need to create one manually via {@link LabelingJobDataAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link LabelingJobDataAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #dataAttributes(LabelingJobDataAttributes)}.
         * 
         * @param dataAttributes
         *        a consumer that will call methods on {@link LabelingJobDataAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataAttributes(LabelingJobDataAttributes)
         */
        default Builder dataAttributes(Consumer<LabelingJobDataAttributes.Builder> dataAttributes) {
            return dataAttributes(LabelingJobDataAttributes.builder().applyMutation(dataAttributes).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LabelingJobDataSource dataSource;

        private LabelingJobDataAttributes dataAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelingJobInputConfig model) {
            dataSource(model.dataSource);
            dataAttributes(model.dataAttributes);
        }

        public final LabelingJobDataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        public final void setDataSource(LabelingJobDataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        @Transient
        public final Builder dataSource(LabelingJobDataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final LabelingJobDataAttributes.Builder getDataAttributes() {
            return dataAttributes != null ? dataAttributes.toBuilder() : null;
        }

        public final void setDataAttributes(LabelingJobDataAttributes.BuilderImpl dataAttributes) {
            this.dataAttributes = dataAttributes != null ? dataAttributes.build() : null;
        }

        @Override
        @Transient
        public final Builder dataAttributes(LabelingJobDataAttributes dataAttributes) {
            this.dataAttributes = dataAttributes;
            return this;
        }

        @Override
        public LabelingJobInputConfig build() {
            return new LabelingJobInputConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
