/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata for a Lambda step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaStepMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaStepMetadata.Builder, LambdaStepMetadata> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(LambdaStepMetadata::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<List<OutputParameter>> OUTPUT_PARAMETERS_FIELD = SdkField
            .<List<OutputParameter>> builder(MarshallingType.LIST)
            .memberName("OutputParameters")
            .getter(getter(LambdaStepMetadata::outputParameters))
            .setter(setter(Builder::outputParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            OUTPUT_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final List<OutputParameter> outputParameters;

    private LambdaStepMetadata(BuilderImpl builder) {
        this.arn = builder.arn;
        this.outputParameters = builder.outputParameters;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda function that was run by this step execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Lambda function that was run by this step execution.
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputParameters() {
        return outputParameters != null && !(outputParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the output parameters of the Lambda step.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputParameters} method.
     * </p>
     * 
     * @return A list of the output parameters of the Lambda step.
     */
    public final List<OutputParameter> outputParameters() {
        return outputParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputParameters() ? outputParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaStepMetadata)) {
            return false;
        }
        LambdaStepMetadata other = (LambdaStepMetadata) obj;
        return Objects.equals(arn(), other.arn()) && hasOutputParameters() == other.hasOutputParameters()
                && Objects.equals(outputParameters(), other.outputParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaStepMetadata").add("Arn", arn())
                .add("OutputParameters", hasOutputParameters() ? outputParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "OutputParameters":
            return Optional.ofNullable(clazz.cast(outputParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaStepMetadata, T> g) {
        return obj -> g.apply((LambdaStepMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaStepMetadata> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Lambda function that was run by this step execution.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the Lambda function that was run by this step execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A list of the output parameters of the Lambda step.
         * </p>
         * 
         * @param outputParameters
         *        A list of the output parameters of the Lambda step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputParameters(Collection<OutputParameter> outputParameters);

        /**
         * <p>
         * A list of the output parameters of the Lambda step.
         * </p>
         * 
         * @param outputParameters
         *        A list of the output parameters of the Lambda step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputParameters(OutputParameter... outputParameters);

        /**
         * <p>
         * A list of the output parameters of the Lambda step.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<OutputParameter>.Builder} avoiding
         * the need to create one manually via {@link List<OutputParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OutputParameter>.Builder#build()} is called immediately and
         * its result is passed to {@link #outputParameters(List<OutputParameter>)}.
         * 
         * @param outputParameters
         *        a consumer that will call methods on {@link List<OutputParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputParameters(List<OutputParameter>)
         */
        Builder outputParameters(Consumer<OutputParameter.Builder>... outputParameters);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private List<OutputParameter> outputParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaStepMetadata model) {
            arn(model.arn);
            outputParameters(model.outputParameters);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final List<OutputParameter.Builder> getOutputParameters() {
            List<OutputParameter.Builder> result = OutputParameterListCopier.copyToBuilder(this.outputParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputParameters(Collection<OutputParameter.BuilderImpl> outputParameters) {
            this.outputParameters = OutputParameterListCopier.copyFromBuilder(outputParameters);
        }

        @Override
        @Transient
        public final Builder outputParameters(Collection<OutputParameter> outputParameters) {
            this.outputParameters = OutputParameterListCopier.copy(outputParameters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outputParameters(OutputParameter... outputParameters) {
            outputParameters(Arrays.asList(outputParameters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outputParameters(Consumer<OutputParameter.Builder>... outputParameters) {
            outputParameters(Stream.of(outputParameters).map(c -> OutputParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public LambdaStepMetadata build() {
            return new LambdaStepMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
