/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFeatureGroupsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListFeatureGroupsResponse.Builder, ListFeatureGroupsResponse> {
    private static final SdkField<List<FeatureGroupSummary>> FEATURE_GROUP_SUMMARIES_FIELD = SdkField
            .<List<FeatureGroupSummary>> builder(MarshallingType.LIST)
            .memberName("FeatureGroupSummaries")
            .getter(getter(ListFeatureGroupsResponse::featureGroupSummaries))
            .setter(setter(Builder::featureGroupSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FeatureGroupSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(FeatureGroupSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFeatureGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<FeatureGroupSummary> featureGroupSummaries;

    private final String nextToken;

    private ListFeatureGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.featureGroupSummaries = builder.featureGroupSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the FeatureGroupSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFeatureGroupSummaries() {
        return featureGroupSummaries != null && !(featureGroupSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A summary of feature groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatureGroupSummaries} method.
     * </p>
     * 
     * @return A summary of feature groups.
     */
    public final List<FeatureGroupSummary> featureGroupSummaries() {
        return featureGroupSummaries;
    }

    /**
     * <p>
     * A token to resume pagination of <code>ListFeatureGroups</code> results.
     * </p>
     * 
     * @return A token to resume pagination of <code>ListFeatureGroups</code> results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFeatureGroupSummaries() ? featureGroupSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFeatureGroupsResponse)) {
            return false;
        }
        ListFeatureGroupsResponse other = (ListFeatureGroupsResponse) obj;
        return hasFeatureGroupSummaries() == other.hasFeatureGroupSummaries()
                && Objects.equals(featureGroupSummaries(), other.featureGroupSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFeatureGroupsResponse")
                .add("FeatureGroupSummaries", hasFeatureGroupSummaries() ? featureGroupSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FeatureGroupSummaries":
            return Optional.ofNullable(clazz.cast(featureGroupSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFeatureGroupsResponse, T> g) {
        return obj -> g.apply((ListFeatureGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFeatureGroupsResponse> {
        /**
         * <p>
         * A summary of feature groups.
         * </p>
         * 
         * @param featureGroupSummaries
         *        A summary of feature groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureGroupSummaries(Collection<FeatureGroupSummary> featureGroupSummaries);

        /**
         * <p>
         * A summary of feature groups.
         * </p>
         * 
         * @param featureGroupSummaries
         *        A summary of feature groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureGroupSummaries(FeatureGroupSummary... featureGroupSummaries);

        /**
         * <p>
         * A summary of feature groups.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<FeatureGroupSummary>.Builder}
         * avoiding the need to create one manually via {@link List<FeatureGroupSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FeatureGroupSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #featureGroupSummaries(List<FeatureGroupSummary>)}.
         * 
         * @param featureGroupSummaries
         *        a consumer that will call methods on {@link List<FeatureGroupSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #featureGroupSummaries(List<FeatureGroupSummary>)
         */
        Builder featureGroupSummaries(Consumer<FeatureGroupSummary.Builder>... featureGroupSummaries);

        /**
         * <p>
         * A token to resume pagination of <code>ListFeatureGroups</code> results.
         * </p>
         * 
         * @param nextToken
         *        A token to resume pagination of <code>ListFeatureGroups</code> results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<FeatureGroupSummary> featureGroupSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFeatureGroupsResponse model) {
            super(model);
            featureGroupSummaries(model.featureGroupSummaries);
            nextToken(model.nextToken);
        }

        public final List<FeatureGroupSummary.Builder> getFeatureGroupSummaries() {
            List<FeatureGroupSummary.Builder> result = FeatureGroupSummariesCopier.copyToBuilder(this.featureGroupSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeatureGroupSummaries(Collection<FeatureGroupSummary.BuilderImpl> featureGroupSummaries) {
            this.featureGroupSummaries = FeatureGroupSummariesCopier.copyFromBuilder(featureGroupSummaries);
        }

        @Override
        @Transient
        public final Builder featureGroupSummaries(Collection<FeatureGroupSummary> featureGroupSummaries) {
            this.featureGroupSummaries = FeatureGroupSummariesCopier.copy(featureGroupSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder featureGroupSummaries(FeatureGroupSummary... featureGroupSummaries) {
            featureGroupSummaries(Arrays.asList(featureGroupSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder featureGroupSummaries(Consumer<FeatureGroupSummary.Builder>... featureGroupSummaries) {
            featureGroupSummaries(Stream.of(featureGroupSummaries)
                    .map(c -> FeatureGroupSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFeatureGroupsResponse build() {
            return new ListFeatureGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
