/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTrainingJobsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListTrainingJobsResponse.Builder, ListTrainingJobsResponse> {
    private static final SdkField<List<TrainingJobSummary>> TRAINING_JOB_SUMMARIES_FIELD = SdkField
            .<List<TrainingJobSummary>> builder(MarshallingType.LIST)
            .memberName("TrainingJobSummaries")
            .getter(getter(ListTrainingJobsResponse::trainingJobSummaries))
            .setter(setter(Builder::trainingJobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrainingJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrainingJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTrainingJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_JOB_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TrainingJobSummary> trainingJobSummaries;

    private final String nextToken;

    private ListTrainingJobsResponse(BuilderImpl builder) {
        super(builder);
        this.trainingJobSummaries = builder.trainingJobSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrainingJobSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTrainingJobSummaries() {
        return trainingJobSummaries != null && !(trainingJobSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>TrainingJobSummary</code> objects, each listing a training job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrainingJobSummaries} method.
     * </p>
     * 
     * @return An array of <code>TrainingJobSummary</code> objects, each listing a training job.
     */
    public final List<TrainingJobSummary> trainingJobSummaries() {
        return trainingJobSummaries;
    }

    /**
     * <p>
     * If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of training jobs, use
     * it in the subsequent request.
     * </p>
     * 
     * @return If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of training
     *         jobs, use it in the subsequent request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTrainingJobSummaries() ? trainingJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrainingJobsResponse)) {
            return false;
        }
        ListTrainingJobsResponse other = (ListTrainingJobsResponse) obj;
        return hasTrainingJobSummaries() == other.hasTrainingJobSummaries()
                && Objects.equals(trainingJobSummaries(), other.trainingJobSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTrainingJobsResponse")
                .add("TrainingJobSummaries", hasTrainingJobSummaries() ? trainingJobSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrainingJobSummaries":
            return Optional.ofNullable(clazz.cast(trainingJobSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrainingJobsResponse, T> g) {
        return obj -> g.apply((ListTrainingJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTrainingJobsResponse> {
        /**
         * <p>
         * An array of <code>TrainingJobSummary</code> objects, each listing a training job.
         * </p>
         * 
         * @param trainingJobSummaries
         *        An array of <code>TrainingJobSummary</code> objects, each listing a training job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJobSummaries(Collection<TrainingJobSummary> trainingJobSummaries);

        /**
         * <p>
         * An array of <code>TrainingJobSummary</code> objects, each listing a training job.
         * </p>
         * 
         * @param trainingJobSummaries
         *        An array of <code>TrainingJobSummary</code> objects, each listing a training job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJobSummaries(TrainingJobSummary... trainingJobSummaries);

        /**
         * <p>
         * An array of <code>TrainingJobSummary</code> objects, each listing a training job.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<TrainingJobSummary>.Builder}
         * avoiding the need to create one manually via {@link List<TrainingJobSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TrainingJobSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #trainingJobSummaries(List<TrainingJobSummary>)}.
         * 
         * @param trainingJobSummaries
         *        a consumer that will call methods on {@link List<TrainingJobSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingJobSummaries(List<TrainingJobSummary>)
         */
        Builder trainingJobSummaries(Consumer<TrainingJobSummary.Builder>... trainingJobSummaries);

        /**
         * <p>
         * If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of training jobs,
         * use it in the subsequent request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of
         *        training jobs, use it in the subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<TrainingJobSummary> trainingJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrainingJobsResponse model) {
            super(model);
            trainingJobSummaries(model.trainingJobSummaries);
            nextToken(model.nextToken);
        }

        public final List<TrainingJobSummary.Builder> getTrainingJobSummaries() {
            List<TrainingJobSummary.Builder> result = TrainingJobSummariesCopier.copyToBuilder(this.trainingJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrainingJobSummaries(Collection<TrainingJobSummary.BuilderImpl> trainingJobSummaries) {
            this.trainingJobSummaries = TrainingJobSummariesCopier.copyFromBuilder(trainingJobSummaries);
        }

        @Override
        @Transient
        public final Builder trainingJobSummaries(Collection<TrainingJobSummary> trainingJobSummaries) {
            this.trainingJobSummaries = TrainingJobSummariesCopier.copy(trainingJobSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder trainingJobSummaries(TrainingJobSummary... trainingJobSummaries) {
            trainingJobSummaries(Arrays.asList(trainingJobSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder trainingJobSummaries(Consumer<TrainingJobSummary.Builder>... trainingJobSummaries) {
            trainingJobSummaries(Stream.of(trainingJobSummaries).map(c -> TrainingJobSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTrainingJobsResponse build() {
            return new ListTrainingJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
