/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTransformJobsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListTransformJobsResponse.Builder, ListTransformJobsResponse> {
    private static final SdkField<List<TransformJobSummary>> TRANSFORM_JOB_SUMMARIES_FIELD = SdkField
            .<List<TransformJobSummary>> builder(MarshallingType.LIST)
            .memberName("TransformJobSummaries")
            .getter(getter(ListTransformJobsResponse::transformJobSummaries))
            .setter(setter(Builder::transformJobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformJobSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TransformJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TransformJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTransformJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_JOB_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TransformJobSummary> transformJobSummaries;

    private final String nextToken;

    private ListTransformJobsResponse(BuilderImpl builder) {
        super(builder);
        this.transformJobSummaries = builder.transformJobSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TransformJobSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTransformJobSummaries() {
        return transformJobSummaries != null && !(transformJobSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>TransformJobSummary</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTransformJobSummaries} method.
     * </p>
     * 
     * @return An array of <code>TransformJobSummary</code> objects.
     */
    public final List<TransformJobSummary> transformJobSummaries() {
        return transformJobSummaries;
    }

    /**
     * <p>
     * If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of transform jobs,
     * use it in the next request.
     * </p>
     * 
     * @return If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of transform
     *         jobs, use it in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTransformJobSummaries() ? transformJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTransformJobsResponse)) {
            return false;
        }
        ListTransformJobsResponse other = (ListTransformJobsResponse) obj;
        return hasTransformJobSummaries() == other.hasTransformJobSummaries()
                && Objects.equals(transformJobSummaries(), other.transformJobSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTransformJobsResponse")
                .add("TransformJobSummaries", hasTransformJobSummaries() ? transformJobSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransformJobSummaries":
            return Optional.ofNullable(clazz.cast(transformJobSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTransformJobsResponse, T> g) {
        return obj -> g.apply((ListTransformJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTransformJobsResponse> {
        /**
         * <p>
         * An array of <code>TransformJobSummary</code> objects.
         * </p>
         * 
         * @param transformJobSummaries
         *        An array of <code>TransformJobSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformJobSummaries(Collection<TransformJobSummary> transformJobSummaries);

        /**
         * <p>
         * An array of <code>TransformJobSummary</code> objects.
         * </p>
         * 
         * @param transformJobSummaries
         *        An array of <code>TransformJobSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformJobSummaries(TransformJobSummary... transformJobSummaries);

        /**
         * <p>
         * An array of <code>TransformJobSummary</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<TransformJobSummary>.Builder}
         * avoiding the need to create one manually via {@link List<TransformJobSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TransformJobSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #transformJobSummaries(List<TransformJobSummary>)}.
         * 
         * @param transformJobSummaries
         *        a consumer that will call methods on {@link List<TransformJobSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transformJobSummaries(List<TransformJobSummary>)
         */
        Builder transformJobSummaries(Consumer<TransformJobSummary.Builder>... transformJobSummaries);

        /**
         * <p>
         * If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of transform
         * jobs, use it in the next request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of
         *        transform jobs, use it in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<TransformJobSummary> transformJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTransformJobsResponse model) {
            super(model);
            transformJobSummaries(model.transformJobSummaries);
            nextToken(model.nextToken);
        }

        public final List<TransformJobSummary.Builder> getTransformJobSummaries() {
            List<TransformJobSummary.Builder> result = TransformJobSummariesCopier.copyToBuilder(this.transformJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransformJobSummaries(Collection<TransformJobSummary.BuilderImpl> transformJobSummaries) {
            this.transformJobSummaries = TransformJobSummariesCopier.copyFromBuilder(transformJobSummaries);
        }

        @Override
        @Transient
        public final Builder transformJobSummaries(Collection<TransformJobSummary> transformJobSummaries) {
            this.transformJobSummaries = TransformJobSummariesCopier.copy(transformJobSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder transformJobSummaries(TransformJobSummary... transformJobSummaries) {
            transformJobSummaries(Arrays.asList(transformJobSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder transformJobSummaries(Consumer<TransformJobSummary.Builder>... transformJobSummaries) {
            transformJobSummaries(Stream.of(transformJobSummaries)
                    .map(c -> TransformJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTransformJobsResponse build() {
            return new ListTransformJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
