/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains metrics captured from a model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelMetrics implements SdkPojo, Serializable, ToCopyableBuilder<ModelMetrics.Builder, ModelMetrics> {
    private static final SdkField<ModelQuality> MODEL_QUALITY_FIELD = SdkField.<ModelQuality> builder(MarshallingType.SDK_POJO)
            .memberName("ModelQuality").getter(getter(ModelMetrics::modelQuality)).setter(setter(Builder::modelQuality))
            .constructor(ModelQuality::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQuality").build()).build();

    private static final SdkField<ModelDataQuality> MODEL_DATA_QUALITY_FIELD = SdkField
            .<ModelDataQuality> builder(MarshallingType.SDK_POJO).memberName("ModelDataQuality")
            .getter(getter(ModelMetrics::modelDataQuality)).setter(setter(Builder::modelDataQuality))
            .constructor(ModelDataQuality::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDataQuality").build()).build();

    private static final SdkField<Bias> BIAS_FIELD = SdkField.<Bias> builder(MarshallingType.SDK_POJO).memberName("Bias")
            .getter(getter(ModelMetrics::bias)).setter(setter(Builder::bias)).constructor(Bias::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bias").build()).build();

    private static final SdkField<Explainability> EXPLAINABILITY_FIELD = SdkField
            .<Explainability> builder(MarshallingType.SDK_POJO).memberName("Explainability")
            .getter(getter(ModelMetrics::explainability)).setter(setter(Builder::explainability))
            .constructor(Explainability::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Explainability").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_QUALITY_FIELD,
            MODEL_DATA_QUALITY_FIELD, BIAS_FIELD, EXPLAINABILITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final ModelQuality modelQuality;

    private final ModelDataQuality modelDataQuality;

    private final Bias bias;

    private final Explainability explainability;

    private ModelMetrics(BuilderImpl builder) {
        this.modelQuality = builder.modelQuality;
        this.modelDataQuality = builder.modelDataQuality;
        this.bias = builder.bias;
        this.explainability = builder.explainability;
    }

    /**
     * <p>
     * Metrics that measure the quality of a model.
     * </p>
     * 
     * @return Metrics that measure the quality of a model.
     */
    public final ModelQuality modelQuality() {
        return modelQuality;
    }

    /**
     * <p>
     * Metrics that measure the quality of the input data for a model.
     * </p>
     * 
     * @return Metrics that measure the quality of the input data for a model.
     */
    public final ModelDataQuality modelDataQuality() {
        return modelDataQuality;
    }

    /**
     * <p>
     * Metrics that measure bais in a model.
     * </p>
     * 
     * @return Metrics that measure bais in a model.
     */
    public final Bias bias() {
        return bias;
    }

    /**
     * <p>
     * Metrics that help explain a model.
     * </p>
     * 
     * @return Metrics that help explain a model.
     */
    public final Explainability explainability() {
        return explainability;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelQuality());
        hashCode = 31 * hashCode + Objects.hashCode(modelDataQuality());
        hashCode = 31 * hashCode + Objects.hashCode(bias());
        hashCode = 31 * hashCode + Objects.hashCode(explainability());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelMetrics)) {
            return false;
        }
        ModelMetrics other = (ModelMetrics) obj;
        return Objects.equals(modelQuality(), other.modelQuality())
                && Objects.equals(modelDataQuality(), other.modelDataQuality()) && Objects.equals(bias(), other.bias())
                && Objects.equals(explainability(), other.explainability());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelMetrics").add("ModelQuality", modelQuality()).add("ModelDataQuality", modelDataQuality())
                .add("Bias", bias()).add("Explainability", explainability()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelQuality":
            return Optional.ofNullable(clazz.cast(modelQuality()));
        case "ModelDataQuality":
            return Optional.ofNullable(clazz.cast(modelDataQuality()));
        case "Bias":
            return Optional.ofNullable(clazz.cast(bias()));
        case "Explainability":
            return Optional.ofNullable(clazz.cast(explainability()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelMetrics, T> g) {
        return obj -> g.apply((ModelMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelMetrics> {
        /**
         * <p>
         * Metrics that measure the quality of a model.
         * </p>
         * 
         * @param modelQuality
         *        Metrics that measure the quality of a model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelQuality(ModelQuality modelQuality);

        /**
         * <p>
         * Metrics that measure the quality of a model.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelQuality.Builder} avoiding the need
         * to create one manually via {@link ModelQuality#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelQuality.Builder#build()} is called immediately and its
         * result is passed to {@link #modelQuality(ModelQuality)}.
         * 
         * @param modelQuality
         *        a consumer that will call methods on {@link ModelQuality.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelQuality(ModelQuality)
         */
        default Builder modelQuality(Consumer<ModelQuality.Builder> modelQuality) {
            return modelQuality(ModelQuality.builder().applyMutation(modelQuality).build());
        }

        /**
         * <p>
         * Metrics that measure the quality of the input data for a model.
         * </p>
         * 
         * @param modelDataQuality
         *        Metrics that measure the quality of the input data for a model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelDataQuality(ModelDataQuality modelDataQuality);

        /**
         * <p>
         * Metrics that measure the quality of the input data for a model.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelDataQuality.Builder} avoiding the
         * need to create one manually via {@link ModelDataQuality#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelDataQuality.Builder#build()} is called immediately and its
         * result is passed to {@link #modelDataQuality(ModelDataQuality)}.
         * 
         * @param modelDataQuality
         *        a consumer that will call methods on {@link ModelDataQuality.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelDataQuality(ModelDataQuality)
         */
        default Builder modelDataQuality(Consumer<ModelDataQuality.Builder> modelDataQuality) {
            return modelDataQuality(ModelDataQuality.builder().applyMutation(modelDataQuality).build());
        }

        /**
         * <p>
         * Metrics that measure bais in a model.
         * </p>
         * 
         * @param bias
         *        Metrics that measure bais in a model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bias(Bias bias);

        /**
         * <p>
         * Metrics that measure bais in a model.
         * </p>
         * This is a convenience method that creates an instance of the {@link Bias.Builder} avoiding the need to create
         * one manually via {@link Bias#builder()}.
         *
         * When the {@link Consumer} completes, {@link Bias.Builder#build()} is called immediately and its result is
         * passed to {@link #bias(Bias)}.
         * 
         * @param bias
         *        a consumer that will call methods on {@link Bias.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bias(Bias)
         */
        default Builder bias(Consumer<Bias.Builder> bias) {
            return bias(Bias.builder().applyMutation(bias).build());
        }

        /**
         * <p>
         * Metrics that help explain a model.
         * </p>
         * 
         * @param explainability
         *        Metrics that help explain a model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explainability(Explainability explainability);

        /**
         * <p>
         * Metrics that help explain a model.
         * </p>
         * This is a convenience method that creates an instance of the {@link Explainability.Builder} avoiding the need
         * to create one manually via {@link Explainability#builder()}.
         *
         * When the {@link Consumer} completes, {@link Explainability.Builder#build()} is called immediately and its
         * result is passed to {@link #explainability(Explainability)}.
         * 
         * @param explainability
         *        a consumer that will call methods on {@link Explainability.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #explainability(Explainability)
         */
        default Builder explainability(Consumer<Explainability.Builder> explainability) {
            return explainability(Explainability.builder().applyMutation(explainability).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ModelQuality modelQuality;

        private ModelDataQuality modelDataQuality;

        private Bias bias;

        private Explainability explainability;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelMetrics model) {
            modelQuality(model.modelQuality);
            modelDataQuality(model.modelDataQuality);
            bias(model.bias);
            explainability(model.explainability);
        }

        public final ModelQuality.Builder getModelQuality() {
            return modelQuality != null ? modelQuality.toBuilder() : null;
        }

        public final void setModelQuality(ModelQuality.BuilderImpl modelQuality) {
            this.modelQuality = modelQuality != null ? modelQuality.build() : null;
        }

        @Override
        @Transient
        public final Builder modelQuality(ModelQuality modelQuality) {
            this.modelQuality = modelQuality;
            return this;
        }

        public final ModelDataQuality.Builder getModelDataQuality() {
            return modelDataQuality != null ? modelDataQuality.toBuilder() : null;
        }

        public final void setModelDataQuality(ModelDataQuality.BuilderImpl modelDataQuality) {
            this.modelDataQuality = modelDataQuality != null ? modelDataQuality.build() : null;
        }

        @Override
        @Transient
        public final Builder modelDataQuality(ModelDataQuality modelDataQuality) {
            this.modelDataQuality = modelDataQuality;
            return this;
        }

        public final Bias.Builder getBias() {
            return bias != null ? bias.toBuilder() : null;
        }

        public final void setBias(Bias.BuilderImpl bias) {
            this.bias = bias != null ? bias.build() : null;
        }

        @Override
        @Transient
        public final Builder bias(Bias bias) {
            this.bias = bias;
            return this;
        }

        public final Explainability.Builder getExplainability() {
            return explainability != null ? explainability.toBuilder() : null;
        }

        public final void setExplainability(Explainability.BuilderImpl explainability) {
            this.explainability = explainability != null ? explainability.build() : null;
        }

        @Override
        @Transient
        public final Builder explainability(Explainability explainability) {
            this.explainability = explainability;
            return this;
        }

        @Override
        public ModelMetrics build() {
            return new ModelMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
