/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output configuration for monitoring jobs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoringOutputConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoringOutputConfig.Builder, MonitoringOutputConfig> {
    private static final SdkField<List<MonitoringOutput>> MONITORING_OUTPUTS_FIELD = SdkField
            .<List<MonitoringOutput>> builder(MarshallingType.LIST)
            .memberName("MonitoringOutputs")
            .getter(getter(MonitoringOutputConfig::monitoringOutputs))
            .setter(setter(Builder::monitoringOutputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringOutputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MonitoringOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(MonitoringOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(MonitoringOutputConfig::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITORING_OUTPUTS_FIELD,
            KMS_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<MonitoringOutput> monitoringOutputs;

    private final String kmsKeyId;

    private MonitoringOutputConfig(BuilderImpl builder) {
        this.monitoringOutputs = builder.monitoringOutputs;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the MonitoringOutputs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMonitoringOutputs() {
        return monitoringOutputs != null && !(monitoringOutputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMonitoringOutputs} method.
     * </p>
     * 
     * @return Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is
     *         uploaded.
     */
    public final List<MonitoringOutput> monitoringOutputs() {
        return monitoringOutputs;
    }

    /**
     * <p>
     * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to
     * encrypt the model artifacts at rest using Amazon S3 server-side encryption.
     * </p>
     * 
     * @return The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses
     *         to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMonitoringOutputs() ? monitoringOutputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringOutputConfig)) {
            return false;
        }
        MonitoringOutputConfig other = (MonitoringOutputConfig) obj;
        return hasMonitoringOutputs() == other.hasMonitoringOutputs()
                && Objects.equals(monitoringOutputs(), other.monitoringOutputs()) && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitoringOutputConfig")
                .add("MonitoringOutputs", hasMonitoringOutputs() ? monitoringOutputs() : null).add("KmsKeyId", kmsKeyId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitoringOutputs":
            return Optional.ofNullable(clazz.cast(monitoringOutputs()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringOutputConfig, T> g) {
        return obj -> g.apply((MonitoringOutputConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoringOutputConfig> {
        /**
         * <p>
         * Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
         * </p>
         * 
         * @param monitoringOutputs
         *        Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is
         *        uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringOutputs(Collection<MonitoringOutput> monitoringOutputs);

        /**
         * <p>
         * Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
         * </p>
         * 
         * @param monitoringOutputs
         *        Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is
         *        uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringOutputs(MonitoringOutput... monitoringOutputs);

        /**
         * <p>
         * Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<MonitoringOutput>.Builder} avoiding
         * the need to create one manually via {@link List<MonitoringOutput>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MonitoringOutput>.Builder#build()} is called immediately and
         * its result is passed to {@link #monitoringOutputs(List<MonitoringOutput>)}.
         * 
         * @param monitoringOutputs
         *        a consumer that will call methods on {@link List<MonitoringOutput>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringOutputs(List<MonitoringOutput>)
         */
        Builder monitoringOutputs(Consumer<MonitoringOutput.Builder>... monitoringOutputs);

        /**
         * <p>
         * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to
         * encrypt the model artifacts at rest using Amazon S3 server-side encryption.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker
         *        uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private List<MonitoringOutput> monitoringOutputs = DefaultSdkAutoConstructList.getInstance();

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringOutputConfig model) {
            monitoringOutputs(model.monitoringOutputs);
            kmsKeyId(model.kmsKeyId);
        }

        public final List<MonitoringOutput.Builder> getMonitoringOutputs() {
            List<MonitoringOutput.Builder> result = MonitoringOutputsCopier.copyToBuilder(this.monitoringOutputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMonitoringOutputs(Collection<MonitoringOutput.BuilderImpl> monitoringOutputs) {
            this.monitoringOutputs = MonitoringOutputsCopier.copyFromBuilder(monitoringOutputs);
        }

        @Override
        @Transient
        public final Builder monitoringOutputs(Collection<MonitoringOutput> monitoringOutputs) {
            this.monitoringOutputs = MonitoringOutputsCopier.copy(monitoringOutputs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder monitoringOutputs(MonitoringOutput... monitoringOutputs) {
            monitoringOutputs(Arrays.asList(monitoringOutputs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder monitoringOutputs(Consumer<MonitoringOutput.Builder>... monitoringOutputs) {
            monitoringOutputs(Stream.of(monitoringOutputs).map(c -> MonitoringOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public MonitoringOutputConfig build() {
            return new MonitoringOutputConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
