/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of an <code>OfflineStore</code>.
 * </p>
 * <p>
 * Provide an <code>OfflineStoreConfig</code> in a request to <code>CreateFeatureGroup</code> to create an
 * <code>OfflineStore</code>.
 * </p>
 * <p>
 * To encrypt an <code>OfflineStore</code> using at rest data encryption, specify Amazon Web Services Key Management
 * Service (KMS) key ID, or <code>KMSKeyId</code>, in <code>S3StorageConfig</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OfflineStoreConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<OfflineStoreConfig.Builder, OfflineStoreConfig> {
    private static final SdkField<S3StorageConfig> S3_STORAGE_CONFIG_FIELD = SdkField
            .<S3StorageConfig> builder(MarshallingType.SDK_POJO).memberName("S3StorageConfig")
            .getter(getter(OfflineStoreConfig::s3StorageConfig)).setter(setter(Builder::s3StorageConfig))
            .constructor(S3StorageConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3StorageConfig").build()).build();

    private static final SdkField<Boolean> DISABLE_GLUE_TABLE_CREATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("DisableGlueTableCreation")
            .getter(getter(OfflineStoreConfig::disableGlueTableCreation)).setter(setter(Builder::disableGlueTableCreation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableGlueTableCreation").build())
            .build();

    private static final SdkField<DataCatalogConfig> DATA_CATALOG_CONFIG_FIELD = SdkField
            .<DataCatalogConfig> builder(MarshallingType.SDK_POJO).memberName("DataCatalogConfig")
            .getter(getter(OfflineStoreConfig::dataCatalogConfig)).setter(setter(Builder::dataCatalogConfig))
            .constructor(DataCatalogConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCatalogConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_STORAGE_CONFIG_FIELD,
            DISABLE_GLUE_TABLE_CREATION_FIELD, DATA_CATALOG_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3StorageConfig s3StorageConfig;

    private final Boolean disableGlueTableCreation;

    private final DataCatalogConfig dataCatalogConfig;

    private OfflineStoreConfig(BuilderImpl builder) {
        this.s3StorageConfig = builder.s3StorageConfig;
        this.disableGlueTableCreation = builder.disableGlueTableCreation;
        this.dataCatalogConfig = builder.dataCatalogConfig;
    }

    /**
     * <p>
     * The Amazon Simple Storage (Amazon S3) location of <code>OfflineStore</code>.
     * </p>
     * 
     * @return The Amazon Simple Storage (Amazon S3) location of <code>OfflineStore</code>.
     */
    public final S3StorageConfig s3StorageConfig() {
        return s3StorageConfig;
    }

    /**
     * <p>
     * Set to <code>True</code> to disable the automatic creation of an Amazon Web Services Glue table when configuring
     * an <code>OfflineStore</code>.
     * </p>
     * 
     * @return Set to <code>True</code> to disable the automatic creation of an Amazon Web Services Glue table when
     *         configuring an <code>OfflineStore</code>.
     */
    public final Boolean disableGlueTableCreation() {
        return disableGlueTableCreation;
    }

    /**
     * <p>
     * The meta data of the Glue table that is autogenerated when an <code>OfflineStore</code> is created.
     * </p>
     * 
     * @return The meta data of the Glue table that is autogenerated when an <code>OfflineStore</code> is created.
     */
    public final DataCatalogConfig dataCatalogConfig() {
        return dataCatalogConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3StorageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(disableGlueTableCreation());
        hashCode = 31 * hashCode + Objects.hashCode(dataCatalogConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OfflineStoreConfig)) {
            return false;
        }
        OfflineStoreConfig other = (OfflineStoreConfig) obj;
        return Objects.equals(s3StorageConfig(), other.s3StorageConfig())
                && Objects.equals(disableGlueTableCreation(), other.disableGlueTableCreation())
                && Objects.equals(dataCatalogConfig(), other.dataCatalogConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OfflineStoreConfig").add("S3StorageConfig", s3StorageConfig())
                .add("DisableGlueTableCreation", disableGlueTableCreation()).add("DataCatalogConfig", dataCatalogConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3StorageConfig":
            return Optional.ofNullable(clazz.cast(s3StorageConfig()));
        case "DisableGlueTableCreation":
            return Optional.ofNullable(clazz.cast(disableGlueTableCreation()));
        case "DataCatalogConfig":
            return Optional.ofNullable(clazz.cast(dataCatalogConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OfflineStoreConfig, T> g) {
        return obj -> g.apply((OfflineStoreConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OfflineStoreConfig> {
        /**
         * <p>
         * The Amazon Simple Storage (Amazon S3) location of <code>OfflineStore</code>.
         * </p>
         * 
         * @param s3StorageConfig
         *        The Amazon Simple Storage (Amazon S3) location of <code>OfflineStore</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3StorageConfig(S3StorageConfig s3StorageConfig);

        /**
         * <p>
         * The Amazon Simple Storage (Amazon S3) location of <code>OfflineStore</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3StorageConfig.Builder} avoiding the
         * need to create one manually via {@link S3StorageConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3StorageConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #s3StorageConfig(S3StorageConfig)}.
         * 
         * @param s3StorageConfig
         *        a consumer that will call methods on {@link S3StorageConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3StorageConfig(S3StorageConfig)
         */
        default Builder s3StorageConfig(Consumer<S3StorageConfig.Builder> s3StorageConfig) {
            return s3StorageConfig(S3StorageConfig.builder().applyMutation(s3StorageConfig).build());
        }

        /**
         * <p>
         * Set to <code>True</code> to disable the automatic creation of an Amazon Web Services Glue table when
         * configuring an <code>OfflineStore</code>.
         * </p>
         * 
         * @param disableGlueTableCreation
         *        Set to <code>True</code> to disable the automatic creation of an Amazon Web Services Glue table when
         *        configuring an <code>OfflineStore</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableGlueTableCreation(Boolean disableGlueTableCreation);

        /**
         * <p>
         * The meta data of the Glue table that is autogenerated when an <code>OfflineStore</code> is created.
         * </p>
         * 
         * @param dataCatalogConfig
         *        The meta data of the Glue table that is autogenerated when an <code>OfflineStore</code> is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataCatalogConfig(DataCatalogConfig dataCatalogConfig);

        /**
         * <p>
         * The meta data of the Glue table that is autogenerated when an <code>OfflineStore</code> is created.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataCatalogConfig.Builder} avoiding the
         * need to create one manually via {@link DataCatalogConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataCatalogConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #dataCatalogConfig(DataCatalogConfig)}.
         * 
         * @param dataCatalogConfig
         *        a consumer that will call methods on {@link DataCatalogConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataCatalogConfig(DataCatalogConfig)
         */
        default Builder dataCatalogConfig(Consumer<DataCatalogConfig.Builder> dataCatalogConfig) {
            return dataCatalogConfig(DataCatalogConfig.builder().applyMutation(dataCatalogConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3StorageConfig s3StorageConfig;

        private Boolean disableGlueTableCreation;

        private DataCatalogConfig dataCatalogConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(OfflineStoreConfig model) {
            s3StorageConfig(model.s3StorageConfig);
            disableGlueTableCreation(model.disableGlueTableCreation);
            dataCatalogConfig(model.dataCatalogConfig);
        }

        public final S3StorageConfig.Builder getS3StorageConfig() {
            return s3StorageConfig != null ? s3StorageConfig.toBuilder() : null;
        }

        public final void setS3StorageConfig(S3StorageConfig.BuilderImpl s3StorageConfig) {
            this.s3StorageConfig = s3StorageConfig != null ? s3StorageConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder s3StorageConfig(S3StorageConfig s3StorageConfig) {
            this.s3StorageConfig = s3StorageConfig;
            return this;
        }

        public final Boolean getDisableGlueTableCreation() {
            return disableGlueTableCreation;
        }

        public final void setDisableGlueTableCreation(Boolean disableGlueTableCreation) {
            this.disableGlueTableCreation = disableGlueTableCreation;
        }

        @Override
        @Transient
        public final Builder disableGlueTableCreation(Boolean disableGlueTableCreation) {
            this.disableGlueTableCreation = disableGlueTableCreation;
            return this;
        }

        public final DataCatalogConfig.Builder getDataCatalogConfig() {
            return dataCatalogConfig != null ? dataCatalogConfig.toBuilder() : null;
        }

        public final void setDataCatalogConfig(DataCatalogConfig.BuilderImpl dataCatalogConfig) {
            this.dataCatalogConfig = dataCatalogConfig != null ? dataCatalogConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder dataCatalogConfig(DataCatalogConfig dataCatalogConfig) {
            this.dataCatalogConfig = dataCatalogConfig;
            return this;
        }

        @Override
        public OfflineStoreConfig build() {
            return new OfflineStoreConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
