/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A SageMaker Model Building Pipeline instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Pipeline implements SdkPojo, Serializable, ToCopyableBuilder<Pipeline.Builder, Pipeline> {
    private static final SdkField<String> PIPELINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineArn").getter(getter(Pipeline::pipelineArn)).setter(setter(Builder::pipelineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineArn").build()).build();

    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineName").getter(getter(Pipeline::pipelineName)).setter(setter(Builder::pipelineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineName").build()).build();

    private static final SdkField<String> PIPELINE_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineDisplayName").getter(getter(Pipeline::pipelineDisplayName))
            .setter(setter(Builder::pipelineDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDisplayName").build())
            .build();

    private static final SdkField<String> PIPELINE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineDescription").getter(getter(Pipeline::pipelineDescription))
            .setter(setter(Builder::pipelineDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineDescription").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(Pipeline::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> PIPELINE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineStatus").getter(getter(Pipeline::pipelineStatusAsString))
            .setter(setter(Builder::pipelineStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineStatus").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(Pipeline::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(Pipeline::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<Instant> LAST_RUN_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastRunTime").getter(getter(Pipeline::lastRunTime)).setter(setter(Builder::lastRunTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRunTime").build()).build();

    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(Pipeline::createdBy)).setter(setter(Builder::createdBy))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("LastModifiedBy").getter(getter(Pipeline::lastModifiedBy)).setter(setter(Builder::lastModifiedBy))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<ParallelismConfiguration> PARALLELISM_CONFIGURATION_FIELD = SdkField
            .<ParallelismConfiguration> builder(MarshallingType.SDK_POJO).memberName("ParallelismConfiguration")
            .getter(getter(Pipeline::parallelismConfiguration)).setter(setter(Builder::parallelismConfiguration))
            .constructor(ParallelismConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelismConfiguration").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(Pipeline::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ARN_FIELD,
            PIPELINE_NAME_FIELD, PIPELINE_DISPLAY_NAME_FIELD, PIPELINE_DESCRIPTION_FIELD, ROLE_ARN_FIELD, PIPELINE_STATUS_FIELD,
            CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_RUN_TIME_FIELD, CREATED_BY_FIELD, LAST_MODIFIED_BY_FIELD,
            PARALLELISM_CONFIGURATION_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pipelineArn;

    private final String pipelineName;

    private final String pipelineDisplayName;

    private final String pipelineDescription;

    private final String roleArn;

    private final String pipelineStatus;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final Instant lastRunTime;

    private final UserContext createdBy;

    private final UserContext lastModifiedBy;

    private final ParallelismConfiguration parallelismConfiguration;

    private final List<Tag> tags;

    private Pipeline(BuilderImpl builder) {
        this.pipelineArn = builder.pipelineArn;
        this.pipelineName = builder.pipelineName;
        this.pipelineDisplayName = builder.pipelineDisplayName;
        this.pipelineDescription = builder.pipelineDescription;
        this.roleArn = builder.roleArn;
        this.pipelineStatus = builder.pipelineStatus;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastRunTime = builder.lastRunTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.parallelismConfiguration = builder.parallelismConfiguration;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the pipeline.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the pipeline.
     */
    public final String pipelineArn() {
        return pipelineArn;
    }

    /**
     * <p>
     * The name of the pipeline.
     * </p>
     * 
     * @return The name of the pipeline.
     */
    public final String pipelineName() {
        return pipelineName;
    }

    /**
     * <p>
     * The display name of the pipeline.
     * </p>
     * 
     * @return The display name of the pipeline.
     */
    public final String pipelineDisplayName() {
        return pipelineDisplayName;
    }

    /**
     * <p>
     * The description of the pipeline.
     * </p>
     * 
     * @return The description of the pipeline.
     */
    public final String pipelineDescription() {
        return pipelineDescription;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role that created the pipeline.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role that created the pipeline.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The status of the pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pipelineStatus}
     * will return {@link PipelineStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #pipelineStatusAsString}.
     * </p>
     * 
     * @return The status of the pipeline.
     * @see PipelineStatus
     */
    public final PipelineStatus pipelineStatus() {
        return PipelineStatus.fromValue(pipelineStatus);
    }

    /**
     * <p>
     * The status of the pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pipelineStatus}
     * will return {@link PipelineStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #pipelineStatusAsString}.
     * </p>
     * 
     * @return The status of the pipeline.
     * @see PipelineStatus
     */
    public final String pipelineStatusAsString() {
        return pipelineStatus;
    }

    /**
     * <p>
     * The creation time of the pipeline.
     * </p>
     * 
     * @return The creation time of the pipeline.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time that the pipeline was last modified.
     * </p>
     * 
     * @return The time that the pipeline was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The time when the pipeline was last run.
     * </p>
     * 
     * @return The time when the pipeline was last run.
     */
    public final Instant lastRunTime() {
        return lastRunTime;
    }

    /**
     * Returns the value of the CreatedBy property for this object.
     * 
     * @return The value of the CreatedBy property for this object.
     */
    public final UserContext createdBy() {
        return createdBy;
    }

    /**
     * Returns the value of the LastModifiedBy property for this object.
     * 
     * @return The value of the LastModifiedBy property for this object.
     */
    public final UserContext lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * <p>
     * The parallelism configuration applied to the pipeline.
     * </p>
     * 
     * @return The parallelism configuration applied to the pipeline.
     */
    public final ParallelismConfiguration parallelismConfiguration() {
        return parallelismConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags that apply to the pipeline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags that apply to the pipeline.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineDescription());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastRunTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(parallelismConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pipeline)) {
            return false;
        }
        Pipeline other = (Pipeline) obj;
        return Objects.equals(pipelineArn(), other.pipelineArn()) && Objects.equals(pipelineName(), other.pipelineName())
                && Objects.equals(pipelineDisplayName(), other.pipelineDisplayName())
                && Objects.equals(pipelineDescription(), other.pipelineDescription())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(pipelineStatusAsString(), other.pipelineStatusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastRunTime(), other.lastRunTime()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy())
                && Objects.equals(parallelismConfiguration(), other.parallelismConfiguration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Pipeline").add("PipelineArn", pipelineArn()).add("PipelineName", pipelineName())
                .add("PipelineDisplayName", pipelineDisplayName()).add("PipelineDescription", pipelineDescription())
                .add("RoleArn", roleArn()).add("PipelineStatus", pipelineStatusAsString()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).add("LastRunTime", lastRunTime()).add("CreatedBy", createdBy())
                .add("LastModifiedBy", lastModifiedBy()).add("ParallelismConfiguration", parallelismConfiguration())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineArn":
            return Optional.ofNullable(clazz.cast(pipelineArn()));
        case "PipelineName":
            return Optional.ofNullable(clazz.cast(pipelineName()));
        case "PipelineDisplayName":
            return Optional.ofNullable(clazz.cast(pipelineDisplayName()));
        case "PipelineDescription":
            return Optional.ofNullable(clazz.cast(pipelineDescription()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "PipelineStatus":
            return Optional.ofNullable(clazz.cast(pipelineStatusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastRunTime":
            return Optional.ofNullable(clazz.cast(lastRunTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "ParallelismConfiguration":
            return Optional.ofNullable(clazz.cast(parallelismConfiguration()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Pipeline, T> g) {
        return obj -> g.apply((Pipeline) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Pipeline> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the pipeline.
         * </p>
         * 
         * @param pipelineArn
         *        The Amazon Resource Name (ARN) of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineArn(String pipelineArn);

        /**
         * <p>
         * The name of the pipeline.
         * </p>
         * 
         * @param pipelineName
         *        The name of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineName(String pipelineName);

        /**
         * <p>
         * The display name of the pipeline.
         * </p>
         * 
         * @param pipelineDisplayName
         *        The display name of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineDisplayName(String pipelineDisplayName);

        /**
         * <p>
         * The description of the pipeline.
         * </p>
         * 
         * @param pipelineDescription
         *        The description of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineDescription(String pipelineDescription);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role that created the pipeline.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role that created the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The status of the pipeline.
         * </p>
         * 
         * @param pipelineStatus
         *        The status of the pipeline.
         * @see PipelineStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineStatus
         */
        Builder pipelineStatus(String pipelineStatus);

        /**
         * <p>
         * The status of the pipeline.
         * </p>
         * 
         * @param pipelineStatus
         *        The status of the pipeline.
         * @see PipelineStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineStatus
         */
        Builder pipelineStatus(PipelineStatus pipelineStatus);

        /**
         * <p>
         * The creation time of the pipeline.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time that the pipeline was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time that the pipeline was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The time when the pipeline was last run.
         * </p>
         * 
         * @param lastRunTime
         *        The time when the pipeline was last run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRunTime(Instant lastRunTime);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * @param createdBy
         *        The new value for the CreatedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(UserContext createdBy);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #createdBy(UserContext)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(UserContext)
         */
        default Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return createdBy(UserContext.builder().applyMutation(createdBy).build());
        }

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * @param lastModifiedBy
         *        The new value for the LastModifiedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(UserContext lastModifiedBy);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #lastModifiedBy(UserContext)}.
         * 
         * @param lastModifiedBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedBy(UserContext)
         */
        default Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return lastModifiedBy(UserContext.builder().applyMutation(lastModifiedBy).build());
        }

        /**
         * <p>
         * The parallelism configuration applied to the pipeline.
         * </p>
         * 
         * @param parallelismConfiguration
         *        The parallelism configuration applied to the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelismConfiguration(ParallelismConfiguration parallelismConfiguration);

        /**
         * <p>
         * The parallelism configuration applied to the pipeline.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParallelismConfiguration.Builder}
         * avoiding the need to create one manually via {@link ParallelismConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ParallelismConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #parallelismConfiguration(ParallelismConfiguration)}.
         * 
         * @param parallelismConfiguration
         *        a consumer that will call methods on {@link ParallelismConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parallelismConfiguration(ParallelismConfiguration)
         */
        default Builder parallelismConfiguration(Consumer<ParallelismConfiguration.Builder> parallelismConfiguration) {
            return parallelismConfiguration(ParallelismConfiguration.builder().applyMutation(parallelismConfiguration).build());
        }

        /**
         * <p>
         * A list of tags that apply to the pipeline.
         * </p>
         * 
         * @param tags
         *        A list of tags that apply to the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags that apply to the pipeline.
         * </p>
         * 
         * @param tags
         *        A list of tags that apply to the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags that apply to the pipeline.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String pipelineArn;

        private String pipelineName;

        private String pipelineDisplayName;

        private String pipelineDescription;

        private String roleArn;

        private String pipelineStatus;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private Instant lastRunTime;

        private UserContext createdBy;

        private UserContext lastModifiedBy;

        private ParallelismConfiguration parallelismConfiguration;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Pipeline model) {
            pipelineArn(model.pipelineArn);
            pipelineName(model.pipelineName);
            pipelineDisplayName(model.pipelineDisplayName);
            pipelineDescription(model.pipelineDescription);
            roleArn(model.roleArn);
            pipelineStatus(model.pipelineStatus);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            lastRunTime(model.lastRunTime);
            createdBy(model.createdBy);
            lastModifiedBy(model.lastModifiedBy);
            parallelismConfiguration(model.parallelismConfiguration);
            tags(model.tags);
        }

        public final String getPipelineArn() {
            return pipelineArn;
        }

        public final void setPipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
        }

        @Override
        @Transient
        public final Builder pipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
            return this;
        }

        public final String getPipelineName() {
            return pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        @Transient
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final String getPipelineDisplayName() {
            return pipelineDisplayName;
        }

        public final void setPipelineDisplayName(String pipelineDisplayName) {
            this.pipelineDisplayName = pipelineDisplayName;
        }

        @Override
        @Transient
        public final Builder pipelineDisplayName(String pipelineDisplayName) {
            this.pipelineDisplayName = pipelineDisplayName;
            return this;
        }

        public final String getPipelineDescription() {
            return pipelineDescription;
        }

        public final void setPipelineDescription(String pipelineDescription) {
            this.pipelineDescription = pipelineDescription;
        }

        @Override
        @Transient
        public final Builder pipelineDescription(String pipelineDescription) {
            this.pipelineDescription = pipelineDescription;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getPipelineStatus() {
            return pipelineStatus;
        }

        public final void setPipelineStatus(String pipelineStatus) {
            this.pipelineStatus = pipelineStatus;
        }

        @Override
        @Transient
        public final Builder pipelineStatus(String pipelineStatus) {
            this.pipelineStatus = pipelineStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder pipelineStatus(PipelineStatus pipelineStatus) {
            this.pipelineStatus(pipelineStatus == null ? null : pipelineStatus.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getLastRunTime() {
            return lastRunTime;
        }

        public final void setLastRunTime(Instant lastRunTime) {
            this.lastRunTime = lastRunTime;
        }

        @Override
        @Transient
        public final Builder lastRunTime(Instant lastRunTime) {
            this.lastRunTime = lastRunTime;
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        @Transient
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return lastModifiedBy != null ? lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        @Transient
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final ParallelismConfiguration.Builder getParallelismConfiguration() {
            return parallelismConfiguration != null ? parallelismConfiguration.toBuilder() : null;
        }

        public final void setParallelismConfiguration(ParallelismConfiguration.BuilderImpl parallelismConfiguration) {
            this.parallelismConfiguration = parallelismConfiguration != null ? parallelismConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder parallelismConfiguration(ParallelismConfiguration parallelismConfiguration) {
            this.parallelismConfiguration = parallelismConfiguration;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Pipeline build() {
            return new Pipeline(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
