/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for uploading output from the processing container.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProcessingOutputConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ProcessingOutputConfig.Builder, ProcessingOutputConfig> {
    private static final SdkField<List<ProcessingOutput>> OUTPUTS_FIELD = SdkField
            .<List<ProcessingOutput>> builder(MarshallingType.LIST)
            .memberName("Outputs")
            .getter(getter(ProcessingOutputConfig::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProcessingOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProcessingOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(ProcessingOutputConfig::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUTS_FIELD,
            KMS_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ProcessingOutput> outputs;

    private final String kmsKeyId;

    private ProcessingOutputConfig(BuilderImpl builder) {
        this.outputs = builder.outputs;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of outputs configuring the data to upload from the processing container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputs} method.
     * </p>
     * 
     * @return An array of outputs configuring the data to upload from the processing container.
     */
    public final List<ProcessingOutput> outputs() {
        return outputs;
    }

    /**
     * <p>
     * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to
     * encrypt the processing job output. <code>KmsKeyId</code> can be an ID of a KMS key, ARN of a KMS key, alias of a
     * KMS key, or alias of a KMS key. The <code>KmsKeyId</code> is applied to all outputs.
     * </p>
     * 
     * @return The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses
     *         to encrypt the processing job output. <code>KmsKeyId</code> can be an ID of a KMS key, ARN of a KMS key,
     *         alias of a KMS key, or alias of a KMS key. The <code>KmsKeyId</code> is applied to all outputs.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessingOutputConfig)) {
            return false;
        }
        ProcessingOutputConfig other = (ProcessingOutputConfig) obj;
        return hasOutputs() == other.hasOutputs() && Objects.equals(outputs(), other.outputs())
                && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProcessingOutputConfig").add("Outputs", hasOutputs() ? outputs() : null)
                .add("KmsKeyId", kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProcessingOutputConfig, T> g) {
        return obj -> g.apply((ProcessingOutputConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProcessingOutputConfig> {
        /**
         * <p>
         * An array of outputs configuring the data to upload from the processing container.
         * </p>
         * 
         * @param outputs
         *        An array of outputs configuring the data to upload from the processing container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<ProcessingOutput> outputs);

        /**
         * <p>
         * An array of outputs configuring the data to upload from the processing container.
         * </p>
         * 
         * @param outputs
         *        An array of outputs configuring the data to upload from the processing container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(ProcessingOutput... outputs);

        /**
         * <p>
         * An array of outputs configuring the data to upload from the processing container.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ProcessingOutput>.Builder} avoiding
         * the need to create one manually via {@link List<ProcessingOutput>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProcessingOutput>.Builder#build()} is called immediately and
         * its result is passed to {@link #outputs(List<ProcessingOutput>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on {@link List<ProcessingOutput>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(List<ProcessingOutput>)
         */
        Builder outputs(Consumer<ProcessingOutput.Builder>... outputs);

        /**
         * <p>
         * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to
         * encrypt the processing job output. <code>KmsKeyId</code> can be an ID of a KMS key, ARN of a KMS key, alias
         * of a KMS key, or alias of a KMS key. The <code>KmsKeyId</code> is applied to all outputs.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker
         *        uses to encrypt the processing job output. <code>KmsKeyId</code> can be an ID of a KMS key, ARN of a
         *        KMS key, alias of a KMS key, or alias of a KMS key. The <code>KmsKeyId</code> is applied to all
         *        outputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private List<ProcessingOutput> outputs = DefaultSdkAutoConstructList.getInstance();

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessingOutputConfig model) {
            outputs(model.outputs);
            kmsKeyId(model.kmsKeyId);
        }

        public final List<ProcessingOutput.Builder> getOutputs() {
            List<ProcessingOutput.Builder> result = ProcessingOutputsCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<ProcessingOutput.BuilderImpl> outputs) {
            this.outputs = ProcessingOutputsCopier.copyFromBuilder(outputs);
        }

        @Override
        @Transient
        public final Builder outputs(Collection<ProcessingOutput> outputs) {
            this.outputs = ProcessingOutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outputs(ProcessingOutput... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outputs(Consumer<ProcessingOutput.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> ProcessingOutput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public ProcessingOutputConfig build() {
            return new ProcessingOutputConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
