/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetryPipelineExecutionRequest extends SageMakerRequest implements
        ToCopyableBuilder<RetryPipelineExecutionRequest.Builder, RetryPipelineExecutionRequest> {
    private static final SdkField<String> PIPELINE_EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PipelineExecutionArn").getter(getter(RetryPipelineExecutionRequest::pipelineExecutionArn))
            .setter(setter(Builder::pipelineExecutionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionArn").build())
            .build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(RetryPipelineExecutionRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<ParallelismConfiguration> PARALLELISM_CONFIGURATION_FIELD = SdkField
            .<ParallelismConfiguration> builder(MarshallingType.SDK_POJO).memberName("ParallelismConfiguration")
            .getter(getter(RetryPipelineExecutionRequest::parallelismConfiguration))
            .setter(setter(Builder::parallelismConfiguration)).constructor(ParallelismConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelismConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_EXECUTION_ARN_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, PARALLELISM_CONFIGURATION_FIELD));

    private final String pipelineExecutionArn;

    private final String clientRequestToken;

    private final ParallelismConfiguration parallelismConfiguration;

    private RetryPipelineExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineExecutionArn = builder.pipelineExecutionArn;
        this.clientRequestToken = builder.clientRequestToken;
        this.parallelismConfiguration = builder.parallelismConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the pipeline execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the pipeline execution.
     */
    public final String pipelineExecutionArn() {
        return pipelineExecutionArn;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent
     * operation completes no more than once.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An
     *         idempotent operation completes no more than once.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * This configuration, if specified, overrides the parallelism configuration of the parent pipeline.
     * </p>
     * 
     * @return This configuration, if specified, overrides the parallelism configuration of the parent pipeline.
     */
    public final ParallelismConfiguration parallelismConfiguration() {
        return parallelismConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(parallelismConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryPipelineExecutionRequest)) {
            return false;
        }
        RetryPipelineExecutionRequest other = (RetryPipelineExecutionRequest) obj;
        return Objects.equals(pipelineExecutionArn(), other.pipelineExecutionArn())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(parallelismConfiguration(), other.parallelismConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetryPipelineExecutionRequest").add("PipelineExecutionArn", pipelineExecutionArn())
                .add("ClientRequestToken", clientRequestToken()).add("ParallelismConfiguration", parallelismConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineExecutionArn":
            return Optional.ofNullable(clazz.cast(pipelineExecutionArn()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "ParallelismConfiguration":
            return Optional.ofNullable(clazz.cast(parallelismConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetryPipelineExecutionRequest, T> g) {
        return obj -> g.apply((RetryPipelineExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, RetryPipelineExecutionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the pipeline execution.
         * </p>
         * 
         * @param pipelineExecutionArn
         *        The Amazon Resource Name (ARN) of the pipeline execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineExecutionArn(String pipelineExecutionArn);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An
         * idempotent operation completes no more than once.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An
         *        idempotent operation completes no more than once.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * This configuration, if specified, overrides the parallelism configuration of the parent pipeline.
         * </p>
         * 
         * @param parallelismConfiguration
         *        This configuration, if specified, overrides the parallelism configuration of the parent pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelismConfiguration(ParallelismConfiguration parallelismConfiguration);

        /**
         * <p>
         * This configuration, if specified, overrides the parallelism configuration of the parent pipeline.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParallelismConfiguration.Builder}
         * avoiding the need to create one manually via {@link ParallelismConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ParallelismConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #parallelismConfiguration(ParallelismConfiguration)}.
         * 
         * @param parallelismConfiguration
         *        a consumer that will call methods on {@link ParallelismConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parallelismConfiguration(ParallelismConfiguration)
         */
        default Builder parallelismConfiguration(Consumer<ParallelismConfiguration.Builder> parallelismConfiguration) {
            return parallelismConfiguration(ParallelismConfiguration.builder().applyMutation(parallelismConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String pipelineExecutionArn;

        private String clientRequestToken;

        private ParallelismConfiguration parallelismConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RetryPipelineExecutionRequest model) {
            super(model);
            pipelineExecutionArn(model.pipelineExecutionArn);
            clientRequestToken(model.clientRequestToken);
            parallelismConfiguration(model.parallelismConfiguration);
        }

        public final String getPipelineExecutionArn() {
            return pipelineExecutionArn;
        }

        public final void setPipelineExecutionArn(String pipelineExecutionArn) {
            this.pipelineExecutionArn = pipelineExecutionArn;
        }

        @Override
        @Transient
        public final Builder pipelineExecutionArn(String pipelineExecutionArn) {
            this.pipelineExecutionArn = pipelineExecutionArn;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final ParallelismConfiguration.Builder getParallelismConfiguration() {
            return parallelismConfiguration != null ? parallelismConfiguration.toBuilder() : null;
        }

        public final void setParallelismConfiguration(ParallelismConfiguration.BuilderImpl parallelismConfiguration) {
            this.parallelismConfiguration = parallelismConfiguration != null ? parallelismConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder parallelismConfiguration(ParallelismConfiguration parallelismConfiguration) {
            this.parallelismConfiguration = parallelismConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RetryPipelineExecutionRequest build() {
            return new RetryPipelineExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
