/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendPipelineExecutionStepSuccessRequest extends SageMakerRequest implements
        ToCopyableBuilder<SendPipelineExecutionStepSuccessRequest.Builder, SendPipelineExecutionStepSuccessRequest> {
    private static final SdkField<String> CALLBACK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CallbackToken").getter(getter(SendPipelineExecutionStepSuccessRequest::callbackToken))
            .setter(setter(Builder::callbackToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallbackToken").build()).build();

    private static final SdkField<List<OutputParameter>> OUTPUT_PARAMETERS_FIELD = SdkField
            .<List<OutputParameter>> builder(MarshallingType.LIST)
            .memberName("OutputParameters")
            .getter(getter(SendPipelineExecutionStepSuccessRequest::outputParameters))
            .setter(setter(Builder::outputParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(SendPipelineExecutionStepSuccessRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALLBACK_TOKEN_FIELD,
            OUTPUT_PARAMETERS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private final String callbackToken;

    private final List<OutputParameter> outputParameters;

    private final String clientRequestToken;

    private SendPipelineExecutionStepSuccessRequest(BuilderImpl builder) {
        super(builder);
        this.callbackToken = builder.callbackToken;
        this.outputParameters = builder.outputParameters;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The pipeline generated token from the Amazon SQS queue.
     * </p>
     * 
     * @return The pipeline generated token from the Amazon SQS queue.
     */
    public final String callbackToken() {
        return callbackToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputParameters() {
        return outputParameters != null && !(outputParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the output parameters of the callback step.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputParameters} method.
     * </p>
     * 
     * @return A list of the output parameters of the callback step.
     */
    public final List<OutputParameter> outputParameters() {
        return outputParameters;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent
     * operation completes no more than one time.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An
     *         idempotent operation completes no more than one time.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(callbackToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputParameters() ? outputParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendPipelineExecutionStepSuccessRequest)) {
            return false;
        }
        SendPipelineExecutionStepSuccessRequest other = (SendPipelineExecutionStepSuccessRequest) obj;
        return Objects.equals(callbackToken(), other.callbackToken()) && hasOutputParameters() == other.hasOutputParameters()
                && Objects.equals(outputParameters(), other.outputParameters())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendPipelineExecutionStepSuccessRequest").add("CallbackToken", callbackToken())
                .add("OutputParameters", hasOutputParameters() ? outputParameters() : null)
                .add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CallbackToken":
            return Optional.ofNullable(clazz.cast(callbackToken()));
        case "OutputParameters":
            return Optional.ofNullable(clazz.cast(outputParameters()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendPipelineExecutionStepSuccessRequest, T> g) {
        return obj -> g.apply((SendPipelineExecutionStepSuccessRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SendPipelineExecutionStepSuccessRequest> {
        /**
         * <p>
         * The pipeline generated token from the Amazon SQS queue.
         * </p>
         * 
         * @param callbackToken
         *        The pipeline generated token from the Amazon SQS queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callbackToken(String callbackToken);

        /**
         * <p>
         * A list of the output parameters of the callback step.
         * </p>
         * 
         * @param outputParameters
         *        A list of the output parameters of the callback step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputParameters(Collection<OutputParameter> outputParameters);

        /**
         * <p>
         * A list of the output parameters of the callback step.
         * </p>
         * 
         * @param outputParameters
         *        A list of the output parameters of the callback step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputParameters(OutputParameter... outputParameters);

        /**
         * <p>
         * A list of the output parameters of the callback step.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<OutputParameter>.Builder} avoiding
         * the need to create one manually via {@link List<OutputParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OutputParameter>.Builder#build()} is called immediately and
         * its result is passed to {@link #outputParameters(List<OutputParameter>)}.
         * 
         * @param outputParameters
         *        a consumer that will call methods on {@link List<OutputParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputParameters(List<OutputParameter>)
         */
        Builder outputParameters(Consumer<OutputParameter.Builder>... outputParameters);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An
         * idempotent operation completes no more than one time.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An
         *        idempotent operation completes no more than one time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String callbackToken;

        private List<OutputParameter> outputParameters = DefaultSdkAutoConstructList.getInstance();

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SendPipelineExecutionStepSuccessRequest model) {
            super(model);
            callbackToken(model.callbackToken);
            outputParameters(model.outputParameters);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getCallbackToken() {
            return callbackToken;
        }

        public final void setCallbackToken(String callbackToken) {
            this.callbackToken = callbackToken;
        }

        @Override
        @Transient
        public final Builder callbackToken(String callbackToken) {
            this.callbackToken = callbackToken;
            return this;
        }

        public final List<OutputParameter.Builder> getOutputParameters() {
            List<OutputParameter.Builder> result = OutputParameterListCopier.copyToBuilder(this.outputParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputParameters(Collection<OutputParameter.BuilderImpl> outputParameters) {
            this.outputParameters = OutputParameterListCopier.copyFromBuilder(outputParameters);
        }

        @Override
        @Transient
        public final Builder outputParameters(Collection<OutputParameter> outputParameters) {
            this.outputParameters = OutputParameterListCopier.copy(outputParameters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outputParameters(OutputParameter... outputParameters) {
            outputParameters(Arrays.asList(outputParameters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outputParameters(Consumer<OutputParameter.Builder>... outputParameters) {
            outputParameters(Stream.of(outputParameters).map(c -> OutputParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        @Transient
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendPipelineExecutionStepSuccessRequest build() {
            return new SendPipelineExecutionStepSuccessRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
