/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProjectRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateProjectRequest.Builder, UpdateProjectRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectName").getter(getter(UpdateProjectRequest::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectName").build()).build();

    private static final SdkField<String> PROJECT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectDescription").getter(getter(UpdateProjectRequest::projectDescription))
            .setter(setter(Builder::projectDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectDescription").build())
            .build();

    private static final SdkField<ServiceCatalogProvisioningUpdateDetails> SERVICE_CATALOG_PROVISIONING_UPDATE_DETAILS_FIELD = SdkField
            .<ServiceCatalogProvisioningUpdateDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ServiceCatalogProvisioningUpdateDetails")
            .getter(getter(UpdateProjectRequest::serviceCatalogProvisioningUpdateDetails))
            .setter(setter(Builder::serviceCatalogProvisioningUpdateDetails))
            .constructor(ServiceCatalogProvisioningUpdateDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ServiceCatalogProvisioningUpdateDetails").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(UpdateProjectRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD,
            PROJECT_DESCRIPTION_FIELD, SERVICE_CATALOG_PROVISIONING_UPDATE_DETAILS_FIELD, TAGS_FIELD));

    private final String projectName;

    private final String projectDescription;

    private final ServiceCatalogProvisioningUpdateDetails serviceCatalogProvisioningUpdateDetails;

    private final List<Tag> tags;

    private UpdateProjectRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.projectDescription = builder.projectDescription;
        this.serviceCatalogProvisioningUpdateDetails = builder.serviceCatalogProvisioningUpdateDetails;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the project.
     * </p>
     * 
     * @return The name of the project.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * <p>
     * The description for the project.
     * </p>
     * 
     * @return The description for the project.
     */
    public final String projectDescription() {
        return projectDescription;
    }

    /**
     * <p>
     * The product ID and provisioning artifact ID to provision a service catalog. The provisioning artifact ID will
     * default to the latest provisioning artifact ID of the product, if you don't provide the provisioning artifact ID.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services
     * Service Catalog</a>.
     * </p>
     * 
     * @return The product ID and provisioning artifact ID to provision a service catalog. The provisioning artifact ID
     *         will default to the latest provisioning artifact ID of the product, if you don't provide the provisioning
     *         artifact ID. For more information, see <a
     *         href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web
     *         Services Service Catalog</a>.
     */
    public final ServiceCatalogProvisioningUpdateDetails serviceCatalogProvisioningUpdateDetails() {
        return serviceCatalogProvisioningUpdateDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways,
     * for example, by purpose, owner, or environment. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
     *         different ways, for example, by purpose, owner, or environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         Resources</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(projectDescription());
        hashCode = 31 * hashCode + Objects.hashCode(serviceCatalogProvisioningUpdateDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProjectRequest)) {
            return false;
        }
        UpdateProjectRequest other = (UpdateProjectRequest) obj;
        return Objects.equals(projectName(), other.projectName())
                && Objects.equals(projectDescription(), other.projectDescription())
                && Objects.equals(serviceCatalogProvisioningUpdateDetails(), other.serviceCatalogProvisioningUpdateDetails())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProjectRequest").add("ProjectName", projectName())
                .add("ProjectDescription", projectDescription())
                .add("ServiceCatalogProvisioningUpdateDetails", serviceCatalogProvisioningUpdateDetails())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "ProjectDescription":
            return Optional.ofNullable(clazz.cast(projectDescription()));
        case "ServiceCatalogProvisioningUpdateDetails":
            return Optional.ofNullable(clazz.cast(serviceCatalogProvisioningUpdateDetails()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProjectRequest, T> g) {
        return obj -> g.apply((UpdateProjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateProjectRequest> {
        /**
         * <p>
         * The name of the project.
         * </p>
         * 
         * @param projectName
         *        The name of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * The description for the project.
         * </p>
         * 
         * @param projectDescription
         *        The description for the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectDescription(String projectDescription);

        /**
         * <p>
         * The product ID and provisioning artifact ID to provision a service catalog. The provisioning artifact ID will
         * default to the latest provisioning artifact ID of the product, if you don't provide the provisioning artifact
         * ID. For more information, see <a
         * href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web
         * Services Service Catalog</a>.
         * </p>
         * 
         * @param serviceCatalogProvisioningUpdateDetails
         *        The product ID and provisioning artifact ID to provision a service catalog. The provisioning artifact
         *        ID will default to the latest provisioning artifact ID of the product, if you don't provide the
         *        provisioning artifact ID. For more information, see <a
         *        href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon
         *        Web Services Service Catalog</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCatalogProvisioningUpdateDetails(
                ServiceCatalogProvisioningUpdateDetails serviceCatalogProvisioningUpdateDetails);

        /**
         * <p>
         * The product ID and provisioning artifact ID to provision a service catalog. The provisioning artifact ID will
         * default to the latest provisioning artifact ID of the product, if you don't provide the provisioning artifact
         * ID. For more information, see <a
         * href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web
         * Services Service Catalog</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ServiceCatalogProvisioningUpdateDetails.Builder} avoiding the need to create one manually via
         * {@link ServiceCatalogProvisioningUpdateDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceCatalogProvisioningUpdateDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #serviceCatalogProvisioningUpdateDetails(ServiceCatalogProvisioningUpdateDetails)}.
         * 
         * @param serviceCatalogProvisioningUpdateDetails
         *        a consumer that will call methods on {@link ServiceCatalogProvisioningUpdateDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceCatalogProvisioningUpdateDetails(ServiceCatalogProvisioningUpdateDetails)
         */
        default Builder serviceCatalogProvisioningUpdateDetails(
                Consumer<ServiceCatalogProvisioningUpdateDetails.Builder> serviceCatalogProvisioningUpdateDetails) {
            return serviceCatalogProvisioningUpdateDetails(ServiceCatalogProvisioningUpdateDetails.builder()
                    .applyMutation(serviceCatalogProvisioningUpdateDetails).build());
        }

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
         *        different ways, for example, by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
         *        different ways, for example, by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String projectName;

        private String projectDescription;

        private ServiceCatalogProvisioningUpdateDetails serviceCatalogProvisioningUpdateDetails;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProjectRequest model) {
            super(model);
            projectName(model.projectName);
            projectDescription(model.projectDescription);
            serviceCatalogProvisioningUpdateDetails(model.serviceCatalogProvisioningUpdateDetails);
            tags(model.tags);
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        @Transient
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getProjectDescription() {
            return projectDescription;
        }

        public final void setProjectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
        }

        @Override
        @Transient
        public final Builder projectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
            return this;
        }

        public final ServiceCatalogProvisioningUpdateDetails.Builder getServiceCatalogProvisioningUpdateDetails() {
            return serviceCatalogProvisioningUpdateDetails != null ? serviceCatalogProvisioningUpdateDetails.toBuilder() : null;
        }

        public final void setServiceCatalogProvisioningUpdateDetails(
                ServiceCatalogProvisioningUpdateDetails.BuilderImpl serviceCatalogProvisioningUpdateDetails) {
            this.serviceCatalogProvisioningUpdateDetails = serviceCatalogProvisioningUpdateDetails != null ? serviceCatalogProvisioningUpdateDetails
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder serviceCatalogProvisioningUpdateDetails(
                ServiceCatalogProvisioningUpdateDetails serviceCatalogProvisioningUpdateDetails) {
            this.serviceCatalogProvisioningUpdateDetails = serviceCatalogProvisioningUpdateDetails;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProjectRequest build() {
            return new UpdateProjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
