/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the monitoring job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoringJobDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoringJobDefinition.Builder, MonitoringJobDefinition> {
    private static final SdkField<MonitoringBaselineConfig> BASELINE_CONFIG_FIELD = SdkField
            .<MonitoringBaselineConfig> builder(MarshallingType.SDK_POJO).memberName("BaselineConfig")
            .getter(getter(MonitoringJobDefinition::baselineConfig)).setter(setter(Builder::baselineConfig))
            .constructor(MonitoringBaselineConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineConfig").build()).build();

    private static final SdkField<List<MonitoringInput>> MONITORING_INPUTS_FIELD = SdkField
            .<List<MonitoringInput>> builder(MarshallingType.LIST)
            .memberName("MonitoringInputs")
            .getter(getter(MonitoringJobDefinition::monitoringInputs))
            .setter(setter(Builder::monitoringInputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringInputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MonitoringInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(MonitoringInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MonitoringOutputConfig> MONITORING_OUTPUT_CONFIG_FIELD = SdkField
            .<MonitoringOutputConfig> builder(MarshallingType.SDK_POJO).memberName("MonitoringOutputConfig")
            .getter(getter(MonitoringJobDefinition::monitoringOutputConfig)).setter(setter(Builder::monitoringOutputConfig))
            .constructor(MonitoringOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringOutputConfig").build())
            .build();

    private static final SdkField<MonitoringResources> MONITORING_RESOURCES_FIELD = SdkField
            .<MonitoringResources> builder(MarshallingType.SDK_POJO).memberName("MonitoringResources")
            .getter(getter(MonitoringJobDefinition::monitoringResources)).setter(setter(Builder::monitoringResources))
            .constructor(MonitoringResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringResources").build())
            .build();

    private static final SdkField<MonitoringAppSpecification> MONITORING_APP_SPECIFICATION_FIELD = SdkField
            .<MonitoringAppSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("MonitoringAppSpecification")
            .getter(getter(MonitoringJobDefinition::monitoringAppSpecification))
            .setter(setter(Builder::monitoringAppSpecification))
            .constructor(MonitoringAppSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringAppSpecification").build())
            .build();

    private static final SdkField<MonitoringStoppingCondition> STOPPING_CONDITION_FIELD = SdkField
            .<MonitoringStoppingCondition> builder(MarshallingType.SDK_POJO).memberName("StoppingCondition")
            .getter(getter(MonitoringJobDefinition::stoppingCondition)).setter(setter(Builder::stoppingCondition))
            .constructor(MonitoringStoppingCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Environment")
            .getter(getter(MonitoringJobDefinition::environment))
            .setter(setter(Builder::environment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<NetworkConfig> NETWORK_CONFIG_FIELD = SdkField
            .<NetworkConfig> builder(MarshallingType.SDK_POJO).memberName("NetworkConfig")
            .getter(getter(MonitoringJobDefinition::networkConfig)).setter(setter(Builder::networkConfig))
            .constructor(NetworkConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfig").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(MonitoringJobDefinition::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(BASELINE_CONFIG_FIELD, MONITORING_INPUTS_FIELD, MONITORING_OUTPUT_CONFIG_FIELD, MONITORING_RESOURCES_FIELD,
                    MONITORING_APP_SPECIFICATION_FIELD, STOPPING_CONDITION_FIELD, ENVIRONMENT_FIELD, NETWORK_CONFIG_FIELD,
                    ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final MonitoringBaselineConfig baselineConfig;

    private final List<MonitoringInput> monitoringInputs;

    private final MonitoringOutputConfig monitoringOutputConfig;

    private final MonitoringResources monitoringResources;

    private final MonitoringAppSpecification monitoringAppSpecification;

    private final MonitoringStoppingCondition stoppingCondition;

    private final Map<String, String> environment;

    private final NetworkConfig networkConfig;

    private final String roleArn;

    private MonitoringJobDefinition(BuilderImpl builder) {
        this.baselineConfig = builder.baselineConfig;
        this.monitoringInputs = builder.monitoringInputs;
        this.monitoringOutputConfig = builder.monitoringOutputConfig;
        this.monitoringResources = builder.monitoringResources;
        this.monitoringAppSpecification = builder.monitoringAppSpecification;
        this.stoppingCondition = builder.stoppingCondition;
        this.environment = builder.environment;
        this.networkConfig = builder.networkConfig;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * Baseline configuration used to validate that the data conforms to the specified constraints and statistics
     * </p>
     * 
     * @return Baseline configuration used to validate that the data conforms to the specified constraints and
     *         statistics
     */
    public final MonitoringBaselineConfig baselineConfig() {
        return baselineConfig;
    }

    /**
     * Returns true if the MonitoringInputs property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasMonitoringInputs() {
        return monitoringInputs != null && !(monitoringInputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of inputs for the monitoring job. Currently we support monitoring an Amazon SageMaker Endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMonitoringInputs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The array of inputs for the monitoring job. Currently we support monitoring an Amazon SageMaker Endpoint.
     */
    public final List<MonitoringInput> monitoringInputs() {
        return monitoringInputs;
    }

    /**
     * <p>
     * The array of outputs from the monitoring job to be uploaded to Amazon Simple Storage Service (Amazon S3).
     * </p>
     * 
     * @return The array of outputs from the monitoring job to be uploaded to Amazon Simple Storage Service (Amazon S3).
     */
    public final MonitoringOutputConfig monitoringOutputConfig() {
        return monitoringOutputConfig;
    }

    /**
     * <p>
     * Identifies the resources, ML compute instances, and ML storage volumes to deploy for a monitoring job. In
     * distributed processing, you specify more than one instance.
     * </p>
     * 
     * @return Identifies the resources, ML compute instances, and ML storage volumes to deploy for a monitoring job. In
     *         distributed processing, you specify more than one instance.
     */
    public final MonitoringResources monitoringResources() {
        return monitoringResources;
    }

    /**
     * <p>
     * Configures the monitoring job to run a specified Docker container image.
     * </p>
     * 
     * @return Configures the monitoring job to run a specified Docker container image.
     */
    public final MonitoringAppSpecification monitoringAppSpecification() {
        return monitoringAppSpecification;
    }

    /**
     * <p>
     * Specifies a time limit for how long the monitoring job is allowed to run.
     * </p>
     * 
     * @return Specifies a time limit for how long the monitoring job is allowed to run.
     */
    public final MonitoringStoppingCondition stoppingCondition() {
        return stoppingCondition;
    }

    /**
     * Returns true if the Environment property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEnvironment() {
        return environment != null && !(environment instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Sets the environment variables in the Docker container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEnvironment()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Sets the environment variables in the Docker container.
     */
    public final Map<String, String> environment() {
        return environment;
    }

    /**
     * <p>
     * Specifies networking options for an monitoring job.
     * </p>
     * 
     * @return Specifies networking options for an monitoring job.
     */
    public final NetworkConfig networkConfig() {
        return networkConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your
     *         behalf.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baselineConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasMonitoringInputs() ? monitoringInputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(monitoringOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringResources());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringAppSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironment() ? environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(networkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringJobDefinition)) {
            return false;
        }
        MonitoringJobDefinition other = (MonitoringJobDefinition) obj;
        return Objects.equals(baselineConfig(), other.baselineConfig()) && hasMonitoringInputs() == other.hasMonitoringInputs()
                && Objects.equals(monitoringInputs(), other.monitoringInputs())
                && Objects.equals(monitoringOutputConfig(), other.monitoringOutputConfig())
                && Objects.equals(monitoringResources(), other.monitoringResources())
                && Objects.equals(monitoringAppSpecification(), other.monitoringAppSpecification())
                && Objects.equals(stoppingCondition(), other.stoppingCondition()) && hasEnvironment() == other.hasEnvironment()
                && Objects.equals(environment(), other.environment()) && Objects.equals(networkConfig(), other.networkConfig())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitoringJobDefinition").add("BaselineConfig", baselineConfig())
                .add("MonitoringInputs", hasMonitoringInputs() ? monitoringInputs() : null)
                .add("MonitoringOutputConfig", monitoringOutputConfig()).add("MonitoringResources", monitoringResources())
                .add("MonitoringAppSpecification", monitoringAppSpecification()).add("StoppingCondition", stoppingCondition())
                .add("Environment", hasEnvironment() ? environment() : null).add("NetworkConfig", networkConfig())
                .add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaselineConfig":
            return Optional.ofNullable(clazz.cast(baselineConfig()));
        case "MonitoringInputs":
            return Optional.ofNullable(clazz.cast(monitoringInputs()));
        case "MonitoringOutputConfig":
            return Optional.ofNullable(clazz.cast(monitoringOutputConfig()));
        case "MonitoringResources":
            return Optional.ofNullable(clazz.cast(monitoringResources()));
        case "MonitoringAppSpecification":
            return Optional.ofNullable(clazz.cast(monitoringAppSpecification()));
        case "StoppingCondition":
            return Optional.ofNullable(clazz.cast(stoppingCondition()));
        case "Environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "NetworkConfig":
            return Optional.ofNullable(clazz.cast(networkConfig()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringJobDefinition, T> g) {
        return obj -> g.apply((MonitoringJobDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoringJobDefinition> {
        /**
         * <p>
         * Baseline configuration used to validate that the data conforms to the specified constraints and statistics
         * </p>
         * 
         * @param baselineConfig
         *        Baseline configuration used to validate that the data conforms to the specified constraints and
         *        statistics
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineConfig(MonitoringBaselineConfig baselineConfig);

        /**
         * <p>
         * Baseline configuration used to validate that the data conforms to the specified constraints and statistics
         * </p>
         * This is a convenience that creates an instance of the {@link MonitoringBaselineConfig.Builder} avoiding the
         * need to create one manually via {@link MonitoringBaselineConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringBaselineConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #baselineConfig(MonitoringBaselineConfig)}.
         * 
         * @param baselineConfig
         *        a consumer that will call methods on {@link MonitoringBaselineConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #baselineConfig(MonitoringBaselineConfig)
         */
        default Builder baselineConfig(Consumer<MonitoringBaselineConfig.Builder> baselineConfig) {
            return baselineConfig(MonitoringBaselineConfig.builder().applyMutation(baselineConfig).build());
        }

        /**
         * <p>
         * The array of inputs for the monitoring job. Currently we support monitoring an Amazon SageMaker Endpoint.
         * </p>
         * 
         * @param monitoringInputs
         *        The array of inputs for the monitoring job. Currently we support monitoring an Amazon SageMaker
         *        Endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringInputs(Collection<MonitoringInput> monitoringInputs);

        /**
         * <p>
         * The array of inputs for the monitoring job. Currently we support monitoring an Amazon SageMaker Endpoint.
         * </p>
         * 
         * @param monitoringInputs
         *        The array of inputs for the monitoring job. Currently we support monitoring an Amazon SageMaker
         *        Endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringInputs(MonitoringInput... monitoringInputs);

        /**
         * <p>
         * The array of inputs for the monitoring job. Currently we support monitoring an Amazon SageMaker Endpoint.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MonitoringInput>.Builder} avoiding the need
         * to create one manually via {@link List<MonitoringInput>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MonitoringInput>.Builder#build()} is called immediately and
         * its result is passed to {@link #monitoringInputs(List<MonitoringInput>)}.
         * 
         * @param monitoringInputs
         *        a consumer that will call methods on {@link List<MonitoringInput>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringInputs(List<MonitoringInput>)
         */
        Builder monitoringInputs(Consumer<MonitoringInput.Builder>... monitoringInputs);

        /**
         * <p>
         * The array of outputs from the monitoring job to be uploaded to Amazon Simple Storage Service (Amazon S3).
         * </p>
         * 
         * @param monitoringOutputConfig
         *        The array of outputs from the monitoring job to be uploaded to Amazon Simple Storage Service (Amazon
         *        S3).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringOutputConfig(MonitoringOutputConfig monitoringOutputConfig);

        /**
         * <p>
         * The array of outputs from the monitoring job to be uploaded to Amazon Simple Storage Service (Amazon S3).
         * </p>
         * This is a convenience that creates an instance of the {@link MonitoringOutputConfig.Builder} avoiding the
         * need to create one manually via {@link MonitoringOutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringOutputConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #monitoringOutputConfig(MonitoringOutputConfig)}.
         * 
         * @param monitoringOutputConfig
         *        a consumer that will call methods on {@link MonitoringOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringOutputConfig(MonitoringOutputConfig)
         */
        default Builder monitoringOutputConfig(Consumer<MonitoringOutputConfig.Builder> monitoringOutputConfig) {
            return monitoringOutputConfig(MonitoringOutputConfig.builder().applyMutation(monitoringOutputConfig).build());
        }

        /**
         * <p>
         * Identifies the resources, ML compute instances, and ML storage volumes to deploy for a monitoring job. In
         * distributed processing, you specify more than one instance.
         * </p>
         * 
         * @param monitoringResources
         *        Identifies the resources, ML compute instances, and ML storage volumes to deploy for a monitoring job.
         *        In distributed processing, you specify more than one instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringResources(MonitoringResources monitoringResources);

        /**
         * <p>
         * Identifies the resources, ML compute instances, and ML storage volumes to deploy for a monitoring job. In
         * distributed processing, you specify more than one instance.
         * </p>
         * This is a convenience that creates an instance of the {@link MonitoringResources.Builder} avoiding the need
         * to create one manually via {@link MonitoringResources#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringResources.Builder#build()} is called immediately and
         * its result is passed to {@link #monitoringResources(MonitoringResources)}.
         * 
         * @param monitoringResources
         *        a consumer that will call methods on {@link MonitoringResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringResources(MonitoringResources)
         */
        default Builder monitoringResources(Consumer<MonitoringResources.Builder> monitoringResources) {
            return monitoringResources(MonitoringResources.builder().applyMutation(monitoringResources).build());
        }

        /**
         * <p>
         * Configures the monitoring job to run a specified Docker container image.
         * </p>
         * 
         * @param monitoringAppSpecification
         *        Configures the monitoring job to run a specified Docker container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringAppSpecification(MonitoringAppSpecification monitoringAppSpecification);

        /**
         * <p>
         * Configures the monitoring job to run a specified Docker container image.
         * </p>
         * This is a convenience that creates an instance of the {@link MonitoringAppSpecification.Builder} avoiding the
         * need to create one manually via {@link MonitoringAppSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringAppSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #monitoringAppSpecification(MonitoringAppSpecification)}.
         * 
         * @param monitoringAppSpecification
         *        a consumer that will call methods on {@link MonitoringAppSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringAppSpecification(MonitoringAppSpecification)
         */
        default Builder monitoringAppSpecification(Consumer<MonitoringAppSpecification.Builder> monitoringAppSpecification) {
            return monitoringAppSpecification(MonitoringAppSpecification.builder().applyMutation(monitoringAppSpecification)
                    .build());
        }

        /**
         * <p>
         * Specifies a time limit for how long the monitoring job is allowed to run.
         * </p>
         * 
         * @param stoppingCondition
         *        Specifies a time limit for how long the monitoring job is allowed to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingCondition(MonitoringStoppingCondition stoppingCondition);

        /**
         * <p>
         * Specifies a time limit for how long the monitoring job is allowed to run.
         * </p>
         * This is a convenience that creates an instance of the {@link MonitoringStoppingCondition.Builder} avoiding
         * the need to create one manually via {@link MonitoringStoppingCondition#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringStoppingCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #stoppingCondition(MonitoringStoppingCondition)}.
         * 
         * @param stoppingCondition
         *        a consumer that will call methods on {@link MonitoringStoppingCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingCondition(MonitoringStoppingCondition)
         */
        default Builder stoppingCondition(Consumer<MonitoringStoppingCondition.Builder> stoppingCondition) {
            return stoppingCondition(MonitoringStoppingCondition.builder().applyMutation(stoppingCondition).build());
        }

        /**
         * <p>
         * Sets the environment variables in the Docker container.
         * </p>
         * 
         * @param environment
         *        Sets the environment variables in the Docker container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Map<String, String> environment);

        /**
         * <p>
         * Specifies networking options for an monitoring job.
         * </p>
         * 
         * @param networkConfig
         *        Specifies networking options for an monitoring job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfig(NetworkConfig networkConfig);

        /**
         * <p>
         * Specifies networking options for an monitoring job.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkConfig.Builder} avoiding the need to
         * create one manually via {@link NetworkConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #networkConfig(NetworkConfig)}.
         * 
         * @param networkConfig
         *        a consumer that will call methods on {@link NetworkConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfig(NetworkConfig)
         */
        default Builder networkConfig(Consumer<NetworkConfig.Builder> networkConfig) {
            return networkConfig(NetworkConfig.builder().applyMutation(networkConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your
         * behalf.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on
         *        your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private MonitoringBaselineConfig baselineConfig;

        private List<MonitoringInput> monitoringInputs = DefaultSdkAutoConstructList.getInstance();

        private MonitoringOutputConfig monitoringOutputConfig;

        private MonitoringResources monitoringResources;

        private MonitoringAppSpecification monitoringAppSpecification;

        private MonitoringStoppingCondition stoppingCondition;

        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();

        private NetworkConfig networkConfig;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringJobDefinition model) {
            baselineConfig(model.baselineConfig);
            monitoringInputs(model.monitoringInputs);
            monitoringOutputConfig(model.monitoringOutputConfig);
            monitoringResources(model.monitoringResources);
            monitoringAppSpecification(model.monitoringAppSpecification);
            stoppingCondition(model.stoppingCondition);
            environment(model.environment);
            networkConfig(model.networkConfig);
            roleArn(model.roleArn);
        }

        public final MonitoringBaselineConfig.Builder getBaselineConfig() {
            return baselineConfig != null ? baselineConfig.toBuilder() : null;
        }

        public final void setBaselineConfig(MonitoringBaselineConfig.BuilderImpl baselineConfig) {
            this.baselineConfig = baselineConfig != null ? baselineConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder baselineConfig(MonitoringBaselineConfig baselineConfig) {
            this.baselineConfig = baselineConfig;
            return this;
        }

        public final List<MonitoringInput.Builder> getMonitoringInputs() {
            List<MonitoringInput.Builder> result = MonitoringInputsCopier.copyToBuilder(this.monitoringInputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMonitoringInputs(Collection<MonitoringInput.BuilderImpl> monitoringInputs) {
            this.monitoringInputs = MonitoringInputsCopier.copyFromBuilder(monitoringInputs);
        }

        @Override
        @Transient
        public final Builder monitoringInputs(Collection<MonitoringInput> monitoringInputs) {
            this.monitoringInputs = MonitoringInputsCopier.copy(monitoringInputs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder monitoringInputs(MonitoringInput... monitoringInputs) {
            monitoringInputs(Arrays.asList(monitoringInputs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder monitoringInputs(Consumer<MonitoringInput.Builder>... monitoringInputs) {
            monitoringInputs(Stream.of(monitoringInputs).map(c -> MonitoringInput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final MonitoringOutputConfig.Builder getMonitoringOutputConfig() {
            return monitoringOutputConfig != null ? monitoringOutputConfig.toBuilder() : null;
        }

        public final void setMonitoringOutputConfig(MonitoringOutputConfig.BuilderImpl monitoringOutputConfig) {
            this.monitoringOutputConfig = monitoringOutputConfig != null ? monitoringOutputConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder monitoringOutputConfig(MonitoringOutputConfig monitoringOutputConfig) {
            this.monitoringOutputConfig = monitoringOutputConfig;
            return this;
        }

        public final MonitoringResources.Builder getMonitoringResources() {
            return monitoringResources != null ? monitoringResources.toBuilder() : null;
        }

        public final void setMonitoringResources(MonitoringResources.BuilderImpl monitoringResources) {
            this.monitoringResources = monitoringResources != null ? monitoringResources.build() : null;
        }

        @Override
        @Transient
        public final Builder monitoringResources(MonitoringResources monitoringResources) {
            this.monitoringResources = monitoringResources;
            return this;
        }

        public final MonitoringAppSpecification.Builder getMonitoringAppSpecification() {
            return monitoringAppSpecification != null ? monitoringAppSpecification.toBuilder() : null;
        }

        public final void setMonitoringAppSpecification(MonitoringAppSpecification.BuilderImpl monitoringAppSpecification) {
            this.monitoringAppSpecification = monitoringAppSpecification != null ? monitoringAppSpecification.build() : null;
        }

        @Override
        @Transient
        public final Builder monitoringAppSpecification(MonitoringAppSpecification monitoringAppSpecification) {
            this.monitoringAppSpecification = monitoringAppSpecification;
            return this;
        }

        public final MonitoringStoppingCondition.Builder getStoppingCondition() {
            return stoppingCondition != null ? stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(MonitoringStoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        @Transient
        public final Builder stoppingCondition(MonitoringStoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final Map<String, String> getEnvironment() {
            if (environment instanceof SdkAutoConstructMap) {
                return null;
            }
            return environment;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = MonitoringEnvironmentMapCopier.copy(environment);
        }

        @Override
        @Transient
        public final Builder environment(Map<String, String> environment) {
            this.environment = MonitoringEnvironmentMapCopier.copy(environment);
            return this;
        }

        public final NetworkConfig.Builder getNetworkConfig() {
            return networkConfig != null ? networkConfig.toBuilder() : null;
        }

        public final void setNetworkConfig(NetworkConfig.BuilderImpl networkConfig) {
            this.networkConfig = networkConfig != null ? networkConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder networkConfig(NetworkConfig networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public MonitoringJobDefinition build() {
            return new MonitoringJobDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
