/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHyperParameterTuningJobResponse extends SageMakerResponse implements
        ToCopyableBuilder<CreateHyperParameterTuningJobResponse.Builder, CreateHyperParameterTuningJobResponse> {
    private static final SdkField<String> HYPER_PARAMETER_TUNING_JOB_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HyperParameterTuningJobArn")
            .getter(getter(CreateHyperParameterTuningJobResponse::hyperParameterTuningJobArn))
            .setter(setter(Builder::hyperParameterTuningJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningJobArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(HYPER_PARAMETER_TUNING_JOB_ARN_FIELD));

    private final String hyperParameterTuningJobArn;

    private CreateHyperParameterTuningJobResponse(BuilderImpl builder) {
        super(builder);
        this.hyperParameterTuningJobArn = builder.hyperParameterTuningJobArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the tuning job. Amazon SageMaker assigns an ARN to a hyperparameter tuning job
     * when you create it.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the tuning job. Amazon SageMaker assigns an ARN to a hyperparameter
     *         tuning job when you create it.
     */
    public final String hyperParameterTuningJobArn() {
        return hyperParameterTuningJobArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hyperParameterTuningJobArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHyperParameterTuningJobResponse)) {
            return false;
        }
        CreateHyperParameterTuningJobResponse other = (CreateHyperParameterTuningJobResponse) obj;
        return Objects.equals(hyperParameterTuningJobArn(), other.hyperParameterTuningJobArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateHyperParameterTuningJobResponse")
                .add("HyperParameterTuningJobArn", hyperParameterTuningJobArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HyperParameterTuningJobArn":
            return Optional.ofNullable(clazz.cast(hyperParameterTuningJobArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHyperParameterTuningJobResponse, T> g) {
        return obj -> g.apply((CreateHyperParameterTuningJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateHyperParameterTuningJobResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the tuning job. Amazon SageMaker assigns an ARN to a hyperparameter tuning
         * job when you create it.
         * </p>
         * 
         * @param hyperParameterTuningJobArn
         *        The Amazon Resource Name (ARN) of the tuning job. Amazon SageMaker assigns an ARN to a hyperparameter
         *        tuning job when you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameterTuningJobArn(String hyperParameterTuningJobArn);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String hyperParameterTuningJobArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHyperParameterTuningJobResponse model) {
            super(model);
            hyperParameterTuningJobArn(model.hyperParameterTuningJobArn);
        }

        public final String getHyperParameterTuningJobArn() {
            return hyperParameterTuningJobArn;
        }

        public final void setHyperParameterTuningJobArn(String hyperParameterTuningJobArn) {
            this.hyperParameterTuningJobArn = hyperParameterTuningJobArn;
        }

        @Override
        public final Builder hyperParameterTuningJobArn(String hyperParameterTuningJobArn) {
            this.hyperParameterTuningJobArn = hyperParameterTuningJobArn;
            return this;
        }

        @Override
        public CreateHyperParameterTuningJobResponse build() {
            return new CreateHyperParameterTuningJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
