/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data structure used to specify the data to be used for inference in a batch transform job and to associate the
 * data that is relevant to the prediction results in the output. The input filter provided allows you to exclude input
 * data that is not needed for inference in a batch transform job. The output filter provided allows you to include
 * input data relevant to interpreting the predictions in the output from the job. For more information, see <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html">Associate Prediction
 * Results with their Corresponding Input Records</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataProcessing implements SdkPojo, Serializable, ToCopyableBuilder<DataProcessing.Builder, DataProcessing> {
    private static final SdkField<String> INPUT_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputFilter").getter(getter(DataProcessing::inputFilter)).setter(setter(Builder::inputFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputFilter").build()).build();

    private static final SdkField<String> OUTPUT_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputFilter").getter(getter(DataProcessing::outputFilter)).setter(setter(Builder::outputFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFilter").build()).build();

    private static final SdkField<String> JOIN_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JoinSource").getter(getter(DataProcessing::joinSourceAsString)).setter(setter(Builder::joinSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JoinSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FILTER_FIELD,
            OUTPUT_FILTER_FIELD, JOIN_SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String inputFilter;

    private final String outputFilter;

    private final String joinSource;

    private DataProcessing(BuilderImpl builder) {
        this.inputFilter = builder.inputFilter;
        this.outputFilter = builder.outputFilter;
        this.joinSource = builder.joinSource;
    }

    /**
     * <p>
     * A <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#data-processing-operators"
     * >JSONPath</a> expression used to select a portion of the input data to pass to the algorithm. Use the
     * <code>InputFilter</code> parameter to exclude fields, such as an ID column, from the input. If you want Amazon
     * SageMaker to pass the entire input dataset to the algorithm, accept the default value <code>$</code>.
     * </p>
     * <p>
     * Examples: <code>"$"</code>, <code>"$[1:]"</code>, <code>"$.features"</code>
     * </p>
     * 
     * @return A <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#data-processing-operators"
     *         >JSONPath</a> expression used to select a portion of the input data to pass to the algorithm. Use the
     *         <code>InputFilter</code> parameter to exclude fields, such as an ID column, from the input. If you want
     *         Amazon SageMaker to pass the entire input dataset to the algorithm, accept the default value
     *         <code>$</code>.</p>
     *         <p>
     *         Examples: <code>"$"</code>, <code>"$[1:]"</code>, <code>"$.features"</code>
     */
    public final String inputFilter() {
        return inputFilter;
    }

    /**
     * <p>
     * A <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#data-processing-operators"
     * >JSONPath</a> expression used to select a portion of the joined dataset to save in the output file for a batch
     * transform job. If you want Amazon SageMaker to store the entire input dataset in the output file, leave the
     * default value, <code>$</code>. If you specify indexes that aren't within the dimension size of the joined
     * dataset, you get an error.
     * </p>
     * <p>
     * Examples: <code>"$"</code>, <code>"$[0,5:]"</code>, <code>"$['id','SageMakerOutput']"</code>
     * </p>
     * 
     * @return A <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#data-processing-operators"
     *         >JSONPath</a> expression used to select a portion of the joined dataset to save in the output file for a
     *         batch transform job. If you want Amazon SageMaker to store the entire input dataset in the output file,
     *         leave the default value, <code>$</code>. If you specify indexes that aren't within the dimension size of
     *         the joined dataset, you get an error.</p>
     *         <p>
     *         Examples: <code>"$"</code>, <code>"$[0,5:]"</code>, <code>"$['id','SageMakerOutput']"</code>
     */
    public final String outputFilter() {
        return outputFilter;
    }

    /**
     * <p>
     * Specifies the source of the data to join with the transformed data. The valid values are <code>None</code> and
     * <code>Input</code>. The default value is <code>None</code>, which specifies not to join the input with the
     * transformed data. If you want the batch transform job to join the original input data with the transformed data,
     * set <code>JoinSource</code> to <code>Input</code>. You can specify <code>OutputFilter</code> as an additional
     * filter to select a portion of the joined dataset and store it in the output file.
     * </p>
     * <p>
     * For JSON or JSONLines objects, such as a JSON array, SageMaker adds the transformed data to the input JSON object
     * in an attribute called <code>SageMakerOutput</code>. The joined result for JSON must be a key-value pair object.
     * If the input is not a key-value pair object, SageMaker creates a new JSON file. In the new JSON file, and the
     * input data is stored under the <code>SageMakerInput</code> key and the results are stored in
     * <code>SageMakerOutput</code>.
     * </p>
     * <p>
     * For CSV data, SageMaker takes each row as a JSON array and joins the transformed data with the input by appending
     * each transformed row to the end of the input. The joined data has the original input data followed by the
     * transformed data and the output is a CSV file.
     * </p>
     * <p>
     * For information on how joining in applied, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#batch-transform-data-processing-workflow"
     * >Workflow for Associating Inferences with Input Records</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #joinSource} will
     * return {@link JoinSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #joinSourceAsString}.
     * </p>
     * 
     * @return Specifies the source of the data to join with the transformed data. The valid values are
     *         <code>None</code> and <code>Input</code>. The default value is <code>None</code>, which specifies not to
     *         join the input with the transformed data. If you want the batch transform job to join the original input
     *         data with the transformed data, set <code>JoinSource</code> to <code>Input</code>. You can specify
     *         <code>OutputFilter</code> as an additional filter to select a portion of the joined dataset and store it
     *         in the output file.</p>
     *         <p>
     *         For JSON or JSONLines objects, such as a JSON array, SageMaker adds the transformed data to the input
     *         JSON object in an attribute called <code>SageMakerOutput</code>. The joined result for JSON must be a
     *         key-value pair object. If the input is not a key-value pair object, SageMaker creates a new JSON file. In
     *         the new JSON file, and the input data is stored under the <code>SageMakerInput</code> key and the results
     *         are stored in <code>SageMakerOutput</code>.
     *         </p>
     *         <p>
     *         For CSV data, SageMaker takes each row as a JSON array and joins the transformed data with the input by
     *         appending each transformed row to the end of the input. The joined data has the original input data
     *         followed by the transformed data and the output is a CSV file.
     *         </p>
     *         <p>
     *         For information on how joining in applied, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#batch-transform-data-processing-workflow"
     *         >Workflow for Associating Inferences with Input Records</a>.
     * @see JoinSource
     */
    public final JoinSource joinSource() {
        return JoinSource.fromValue(joinSource);
    }

    /**
     * <p>
     * Specifies the source of the data to join with the transformed data. The valid values are <code>None</code> and
     * <code>Input</code>. The default value is <code>None</code>, which specifies not to join the input with the
     * transformed data. If you want the batch transform job to join the original input data with the transformed data,
     * set <code>JoinSource</code> to <code>Input</code>. You can specify <code>OutputFilter</code> as an additional
     * filter to select a portion of the joined dataset and store it in the output file.
     * </p>
     * <p>
     * For JSON or JSONLines objects, such as a JSON array, SageMaker adds the transformed data to the input JSON object
     * in an attribute called <code>SageMakerOutput</code>. The joined result for JSON must be a key-value pair object.
     * If the input is not a key-value pair object, SageMaker creates a new JSON file. In the new JSON file, and the
     * input data is stored under the <code>SageMakerInput</code> key and the results are stored in
     * <code>SageMakerOutput</code>.
     * </p>
     * <p>
     * For CSV data, SageMaker takes each row as a JSON array and joins the transformed data with the input by appending
     * each transformed row to the end of the input. The joined data has the original input data followed by the
     * transformed data and the output is a CSV file.
     * </p>
     * <p>
     * For information on how joining in applied, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#batch-transform-data-processing-workflow"
     * >Workflow for Associating Inferences with Input Records</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #joinSource} will
     * return {@link JoinSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #joinSourceAsString}.
     * </p>
     * 
     * @return Specifies the source of the data to join with the transformed data. The valid values are
     *         <code>None</code> and <code>Input</code>. The default value is <code>None</code>, which specifies not to
     *         join the input with the transformed data. If you want the batch transform job to join the original input
     *         data with the transformed data, set <code>JoinSource</code> to <code>Input</code>. You can specify
     *         <code>OutputFilter</code> as an additional filter to select a portion of the joined dataset and store it
     *         in the output file.</p>
     *         <p>
     *         For JSON or JSONLines objects, such as a JSON array, SageMaker adds the transformed data to the input
     *         JSON object in an attribute called <code>SageMakerOutput</code>. The joined result for JSON must be a
     *         key-value pair object. If the input is not a key-value pair object, SageMaker creates a new JSON file. In
     *         the new JSON file, and the input data is stored under the <code>SageMakerInput</code> key and the results
     *         are stored in <code>SageMakerOutput</code>.
     *         </p>
     *         <p>
     *         For CSV data, SageMaker takes each row as a JSON array and joins the transformed data with the input by
     *         appending each transformed row to the end of the input. The joined data has the original input data
     *         followed by the transformed data and the output is a CSV file.
     *         </p>
     *         <p>
     *         For information on how joining in applied, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#batch-transform-data-processing-workflow"
     *         >Workflow for Associating Inferences with Input Records</a>.
     * @see JoinSource
     */
    public final String joinSourceAsString() {
        return joinSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputFilter());
        hashCode = 31 * hashCode + Objects.hashCode(outputFilter());
        hashCode = 31 * hashCode + Objects.hashCode(joinSourceAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProcessing)) {
            return false;
        }
        DataProcessing other = (DataProcessing) obj;
        return Objects.equals(inputFilter(), other.inputFilter()) && Objects.equals(outputFilter(), other.outputFilter())
                && Objects.equals(joinSourceAsString(), other.joinSourceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataProcessing").add("InputFilter", inputFilter()).add("OutputFilter", outputFilter())
                .add("JoinSource", joinSourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputFilter":
            return Optional.ofNullable(clazz.cast(inputFilter()));
        case "OutputFilter":
            return Optional.ofNullable(clazz.cast(outputFilter()));
        case "JoinSource":
            return Optional.ofNullable(clazz.cast(joinSourceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataProcessing, T> g) {
        return obj -> g.apply((DataProcessing) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataProcessing> {
        /**
         * <p>
         * A <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#data-processing-operators"
         * >JSONPath</a> expression used to select a portion of the input data to pass to the algorithm. Use the
         * <code>InputFilter</code> parameter to exclude fields, such as an ID column, from the input. If you want
         * Amazon SageMaker to pass the entire input dataset to the algorithm, accept the default value <code>$</code>.
         * </p>
         * <p>
         * Examples: <code>"$"</code>, <code>"$[1:]"</code>, <code>"$.features"</code>
         * </p>
         * 
         * @param inputFilter
         *        A <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#data-processing-operators"
         *        >JSONPath</a> expression used to select a portion of the input data to pass to the algorithm. Use the
         *        <code>InputFilter</code> parameter to exclude fields, such as an ID column, from the input. If you
         *        want Amazon SageMaker to pass the entire input dataset to the algorithm, accept the default value
         *        <code>$</code>.</p>
         *        <p>
         *        Examples: <code>"$"</code>, <code>"$[1:]"</code>, <code>"$.features"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputFilter(String inputFilter);

        /**
         * <p>
         * A <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#data-processing-operators"
         * >JSONPath</a> expression used to select a portion of the joined dataset to save in the output file for a
         * batch transform job. If you want Amazon SageMaker to store the entire input dataset in the output file, leave
         * the default value, <code>$</code>. If you specify indexes that aren't within the dimension size of the joined
         * dataset, you get an error.
         * </p>
         * <p>
         * Examples: <code>"$"</code>, <code>"$[0,5:]"</code>, <code>"$['id','SageMakerOutput']"</code>
         * </p>
         * 
         * @param outputFilter
         *        A <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#data-processing-operators"
         *        >JSONPath</a> expression used to select a portion of the joined dataset to save in the output file for
         *        a batch transform job. If you want Amazon SageMaker to store the entire input dataset in the output
         *        file, leave the default value, <code>$</code>. If you specify indexes that aren't within the dimension
         *        size of the joined dataset, you get an error.</p>
         *        <p>
         *        Examples: <code>"$"</code>, <code>"$[0,5:]"</code>, <code>"$['id','SageMakerOutput']"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputFilter(String outputFilter);

        /**
         * <p>
         * Specifies the source of the data to join with the transformed data. The valid values are <code>None</code>
         * and <code>Input</code>. The default value is <code>None</code>, which specifies not to join the input with
         * the transformed data. If you want the batch transform job to join the original input data with the
         * transformed data, set <code>JoinSource</code> to <code>Input</code>. You can specify
         * <code>OutputFilter</code> as an additional filter to select a portion of the joined dataset and store it in
         * the output file.
         * </p>
         * <p>
         * For JSON or JSONLines objects, such as a JSON array, SageMaker adds the transformed data to the input JSON
         * object in an attribute called <code>SageMakerOutput</code>. The joined result for JSON must be a key-value
         * pair object. If the input is not a key-value pair object, SageMaker creates a new JSON file. In the new JSON
         * file, and the input data is stored under the <code>SageMakerInput</code> key and the results are stored in
         * <code>SageMakerOutput</code>.
         * </p>
         * <p>
         * For CSV data, SageMaker takes each row as a JSON array and joins the transformed data with the input by
         * appending each transformed row to the end of the input. The joined data has the original input data followed
         * by the transformed data and the output is a CSV file.
         * </p>
         * <p>
         * For information on how joining in applied, see <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#batch-transform-data-processing-workflow"
         * >Workflow for Associating Inferences with Input Records</a>.
         * </p>
         * 
         * @param joinSource
         *        Specifies the source of the data to join with the transformed data. The valid values are
         *        <code>None</code> and <code>Input</code>. The default value is <code>None</code>, which specifies not
         *        to join the input with the transformed data. If you want the batch transform job to join the original
         *        input data with the transformed data, set <code>JoinSource</code> to <code>Input</code>. You can
         *        specify <code>OutputFilter</code> as an additional filter to select a portion of the joined dataset
         *        and store it in the output file.</p>
         *        <p>
         *        For JSON or JSONLines objects, such as a JSON array, SageMaker adds the transformed data to the input
         *        JSON object in an attribute called <code>SageMakerOutput</code>. The joined result for JSON must be a
         *        key-value pair object. If the input is not a key-value pair object, SageMaker creates a new JSON file.
         *        In the new JSON file, and the input data is stored under the <code>SageMakerInput</code> key and the
         *        results are stored in <code>SageMakerOutput</code>.
         *        </p>
         *        <p>
         *        For CSV data, SageMaker takes each row as a JSON array and joins the transformed data with the input
         *        by appending each transformed row to the end of the input. The joined data has the original input data
         *        followed by the transformed data and the output is a CSV file.
         *        </p>
         *        <p>
         *        For information on how joining in applied, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#batch-transform-data-processing-workflow"
         *        >Workflow for Associating Inferences with Input Records</a>.
         * @see JoinSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JoinSource
         */
        Builder joinSource(String joinSource);

        /**
         * <p>
         * Specifies the source of the data to join with the transformed data. The valid values are <code>None</code>
         * and <code>Input</code>. The default value is <code>None</code>, which specifies not to join the input with
         * the transformed data. If you want the batch transform job to join the original input data with the
         * transformed data, set <code>JoinSource</code> to <code>Input</code>. You can specify
         * <code>OutputFilter</code> as an additional filter to select a portion of the joined dataset and store it in
         * the output file.
         * </p>
         * <p>
         * For JSON or JSONLines objects, such as a JSON array, SageMaker adds the transformed data to the input JSON
         * object in an attribute called <code>SageMakerOutput</code>. The joined result for JSON must be a key-value
         * pair object. If the input is not a key-value pair object, SageMaker creates a new JSON file. In the new JSON
         * file, and the input data is stored under the <code>SageMakerInput</code> key and the results are stored in
         * <code>SageMakerOutput</code>.
         * </p>
         * <p>
         * For CSV data, SageMaker takes each row as a JSON array and joins the transformed data with the input by
         * appending each transformed row to the end of the input. The joined data has the original input data followed
         * by the transformed data and the output is a CSV file.
         * </p>
         * <p>
         * For information on how joining in applied, see <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#batch-transform-data-processing-workflow"
         * >Workflow for Associating Inferences with Input Records</a>.
         * </p>
         * 
         * @param joinSource
         *        Specifies the source of the data to join with the transformed data. The valid values are
         *        <code>None</code> and <code>Input</code>. The default value is <code>None</code>, which specifies not
         *        to join the input with the transformed data. If you want the batch transform job to join the original
         *        input data with the transformed data, set <code>JoinSource</code> to <code>Input</code>. You can
         *        specify <code>OutputFilter</code> as an additional filter to select a portion of the joined dataset
         *        and store it in the output file.</p>
         *        <p>
         *        For JSON or JSONLines objects, such as a JSON array, SageMaker adds the transformed data to the input
         *        JSON object in an attribute called <code>SageMakerOutput</code>. The joined result for JSON must be a
         *        key-value pair object. If the input is not a key-value pair object, SageMaker creates a new JSON file.
         *        In the new JSON file, and the input data is stored under the <code>SageMakerInput</code> key and the
         *        results are stored in <code>SageMakerOutput</code>.
         *        </p>
         *        <p>
         *        For CSV data, SageMaker takes each row as a JSON array and joins the transformed data with the input
         *        by appending each transformed row to the end of the input. The joined data has the original input data
         *        followed by the transformed data and the output is a CSV file.
         *        </p>
         *        <p>
         *        For information on how joining in applied, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#batch-transform-data-processing-workflow"
         *        >Workflow for Associating Inferences with Input Records</a>.
         * @see JoinSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JoinSource
         */
        Builder joinSource(JoinSource joinSource);
    }

    static final class BuilderImpl implements Builder {
        private String inputFilter;

        private String outputFilter;

        private String joinSource;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProcessing model) {
            inputFilter(model.inputFilter);
            outputFilter(model.outputFilter);
            joinSource(model.joinSource);
        }

        public final String getInputFilter() {
            return inputFilter;
        }

        public final void setInputFilter(String inputFilter) {
            this.inputFilter = inputFilter;
        }

        @Override
        public final Builder inputFilter(String inputFilter) {
            this.inputFilter = inputFilter;
            return this;
        }

        public final String getOutputFilter() {
            return outputFilter;
        }

        public final void setOutputFilter(String outputFilter) {
            this.outputFilter = outputFilter;
        }

        @Override
        public final Builder outputFilter(String outputFilter) {
            this.outputFilter = outputFilter;
            return this;
        }

        public final String getJoinSource() {
            return joinSource;
        }

        public final void setJoinSource(String joinSource) {
            this.joinSource = joinSource;
        }

        @Override
        public final Builder joinSource(String joinSource) {
            this.joinSource = joinSource;
            return this;
        }

        @Override
        public final Builder joinSource(JoinSource joinSource) {
            this.joinSource(joinSource == null ? null : joinSource.toString());
            return this;
        }

        @Override
        public DataProcessing build() {
            return new DataProcessing(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
