/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAlgorithmResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeAlgorithmResponse.Builder, DescribeAlgorithmResponse> {
    private static final SdkField<String> ALGORITHM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlgorithmName").getter(getter(DescribeAlgorithmResponse::algorithmName))
            .setter(setter(Builder::algorithmName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmName").build()).build();

    private static final SdkField<String> ALGORITHM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlgorithmArn").getter(getter(DescribeAlgorithmResponse::algorithmArn))
            .setter(setter(Builder::algorithmArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmArn").build()).build();

    private static final SdkField<String> ALGORITHM_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlgorithmDescription").getter(getter(DescribeAlgorithmResponse::algorithmDescription))
            .setter(setter(Builder::algorithmDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmDescription").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeAlgorithmResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<TrainingSpecification> TRAINING_SPECIFICATION_FIELD = SdkField
            .<TrainingSpecification> builder(MarshallingType.SDK_POJO).memberName("TrainingSpecification")
            .getter(getter(DescribeAlgorithmResponse::trainingSpecification)).setter(setter(Builder::trainingSpecification))
            .constructor(TrainingSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingSpecification").build())
            .build();

    private static final SdkField<InferenceSpecification> INFERENCE_SPECIFICATION_FIELD = SdkField
            .<InferenceSpecification> builder(MarshallingType.SDK_POJO).memberName("InferenceSpecification")
            .getter(getter(DescribeAlgorithmResponse::inferenceSpecification)).setter(setter(Builder::inferenceSpecification))
            .constructor(InferenceSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSpecification").build())
            .build();

    private static final SdkField<AlgorithmValidationSpecification> VALIDATION_SPECIFICATION_FIELD = SdkField
            .<AlgorithmValidationSpecification> builder(MarshallingType.SDK_POJO).memberName("ValidationSpecification")
            .getter(getter(DescribeAlgorithmResponse::validationSpecification)).setter(setter(Builder::validationSpecification))
            .constructor(AlgorithmValidationSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationSpecification").build())
            .build();

    private static final SdkField<String> ALGORITHM_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlgorithmStatus").getter(getter(DescribeAlgorithmResponse::algorithmStatusAsString))
            .setter(setter(Builder::algorithmStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmStatus").build()).build();

    private static final SdkField<AlgorithmStatusDetails> ALGORITHM_STATUS_DETAILS_FIELD = SdkField
            .<AlgorithmStatusDetails> builder(MarshallingType.SDK_POJO).memberName("AlgorithmStatusDetails")
            .getter(getter(DescribeAlgorithmResponse::algorithmStatusDetails)).setter(setter(Builder::algorithmStatusDetails))
            .constructor(AlgorithmStatusDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmStatusDetails").build())
            .build();

    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductId").getter(getter(DescribeAlgorithmResponse::productId)).setter(setter(Builder::productId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()).build();

    private static final SdkField<Boolean> CERTIFY_FOR_MARKETPLACE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CertifyForMarketplace").getter(getter(DescribeAlgorithmResponse::certifyForMarketplace))
            .setter(setter(Builder::certifyForMarketplace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertifyForMarketplace").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_NAME_FIELD,
            ALGORITHM_ARN_FIELD, ALGORITHM_DESCRIPTION_FIELD, CREATION_TIME_FIELD, TRAINING_SPECIFICATION_FIELD,
            INFERENCE_SPECIFICATION_FIELD, VALIDATION_SPECIFICATION_FIELD, ALGORITHM_STATUS_FIELD,
            ALGORITHM_STATUS_DETAILS_FIELD, PRODUCT_ID_FIELD, CERTIFY_FOR_MARKETPLACE_FIELD));

    private final String algorithmName;

    private final String algorithmArn;

    private final String algorithmDescription;

    private final Instant creationTime;

    private final TrainingSpecification trainingSpecification;

    private final InferenceSpecification inferenceSpecification;

    private final AlgorithmValidationSpecification validationSpecification;

    private final String algorithmStatus;

    private final AlgorithmStatusDetails algorithmStatusDetails;

    private final String productId;

    private final Boolean certifyForMarketplace;

    private DescribeAlgorithmResponse(BuilderImpl builder) {
        super(builder);
        this.algorithmName = builder.algorithmName;
        this.algorithmArn = builder.algorithmArn;
        this.algorithmDescription = builder.algorithmDescription;
        this.creationTime = builder.creationTime;
        this.trainingSpecification = builder.trainingSpecification;
        this.inferenceSpecification = builder.inferenceSpecification;
        this.validationSpecification = builder.validationSpecification;
        this.algorithmStatus = builder.algorithmStatus;
        this.algorithmStatusDetails = builder.algorithmStatusDetails;
        this.productId = builder.productId;
        this.certifyForMarketplace = builder.certifyForMarketplace;
    }

    /**
     * <p>
     * The name of the algorithm being described.
     * </p>
     * 
     * @return The name of the algorithm being described.
     */
    public final String algorithmName() {
        return algorithmName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the algorithm.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the algorithm.
     */
    public final String algorithmArn() {
        return algorithmArn;
    }

    /**
     * <p>
     * A brief summary about the algorithm.
     * </p>
     * 
     * @return A brief summary about the algorithm.
     */
    public final String algorithmDescription() {
        return algorithmDescription;
    }

    /**
     * <p>
     * A timestamp specifying when the algorithm was created.
     * </p>
     * 
     * @return A timestamp specifying when the algorithm was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Details about training jobs run by this algorithm.
     * </p>
     * 
     * @return Details about training jobs run by this algorithm.
     */
    public final TrainingSpecification trainingSpecification() {
        return trainingSpecification;
    }

    /**
     * <p>
     * Details about inference jobs that the algorithm runs.
     * </p>
     * 
     * @return Details about inference jobs that the algorithm runs.
     */
    public final InferenceSpecification inferenceSpecification() {
        return inferenceSpecification;
    }

    /**
     * <p>
     * Details about configurations for one or more training jobs that Amazon SageMaker runs to test the algorithm.
     * </p>
     * 
     * @return Details about configurations for one or more training jobs that Amazon SageMaker runs to test the
     *         algorithm.
     */
    public final AlgorithmValidationSpecification validationSpecification() {
        return validationSpecification;
    }

    /**
     * <p>
     * The current status of the algorithm.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #algorithmStatus}
     * will return {@link AlgorithmStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #algorithmStatusAsString}.
     * </p>
     * 
     * @return The current status of the algorithm.
     * @see AlgorithmStatus
     */
    public final AlgorithmStatus algorithmStatus() {
        return AlgorithmStatus.fromValue(algorithmStatus);
    }

    /**
     * <p>
     * The current status of the algorithm.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #algorithmStatus}
     * will return {@link AlgorithmStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #algorithmStatusAsString}.
     * </p>
     * 
     * @return The current status of the algorithm.
     * @see AlgorithmStatus
     */
    public final String algorithmStatusAsString() {
        return algorithmStatus;
    }

    /**
     * <p>
     * Details about the current status of the algorithm.
     * </p>
     * 
     * @return Details about the current status of the algorithm.
     */
    public final AlgorithmStatusDetails algorithmStatusDetails() {
        return algorithmStatusDetails;
    }

    /**
     * <p>
     * The product identifier of the algorithm.
     * </p>
     * 
     * @return The product identifier of the algorithm.
     */
    public final String productId() {
        return productId;
    }

    /**
     * <p>
     * Whether the algorithm is certified to be listed in Amazon Web Services Marketplace.
     * </p>
     * 
     * @return Whether the algorithm is certified to be listed in Amazon Web Services Marketplace.
     */
    public final Boolean certifyForMarketplace() {
        return certifyForMarketplace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(algorithmName());
        hashCode = 31 * hashCode + Objects.hashCode(algorithmArn());
        hashCode = 31 * hashCode + Objects.hashCode(algorithmDescription());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(trainingSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(validationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(algorithmStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(algorithmStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(productId());
        hashCode = 31 * hashCode + Objects.hashCode(certifyForMarketplace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlgorithmResponse)) {
            return false;
        }
        DescribeAlgorithmResponse other = (DescribeAlgorithmResponse) obj;
        return Objects.equals(algorithmName(), other.algorithmName()) && Objects.equals(algorithmArn(), other.algorithmArn())
                && Objects.equals(algorithmDescription(), other.algorithmDescription())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(trainingSpecification(), other.trainingSpecification())
                && Objects.equals(inferenceSpecification(), other.inferenceSpecification())
                && Objects.equals(validationSpecification(), other.validationSpecification())
                && Objects.equals(algorithmStatusAsString(), other.algorithmStatusAsString())
                && Objects.equals(algorithmStatusDetails(), other.algorithmStatusDetails())
                && Objects.equals(productId(), other.productId())
                && Objects.equals(certifyForMarketplace(), other.certifyForMarketplace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAlgorithmResponse").add("AlgorithmName", algorithmName())
                .add("AlgorithmArn", algorithmArn()).add("AlgorithmDescription", algorithmDescription())
                .add("CreationTime", creationTime()).add("TrainingSpecification", trainingSpecification())
                .add("InferenceSpecification", inferenceSpecification())
                .add("ValidationSpecification", validationSpecification()).add("AlgorithmStatus", algorithmStatusAsString())
                .add("AlgorithmStatusDetails", algorithmStatusDetails()).add("ProductId", productId())
                .add("CertifyForMarketplace", certifyForMarketplace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlgorithmName":
            return Optional.ofNullable(clazz.cast(algorithmName()));
        case "AlgorithmArn":
            return Optional.ofNullable(clazz.cast(algorithmArn()));
        case "AlgorithmDescription":
            return Optional.ofNullable(clazz.cast(algorithmDescription()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "TrainingSpecification":
            return Optional.ofNullable(clazz.cast(trainingSpecification()));
        case "InferenceSpecification":
            return Optional.ofNullable(clazz.cast(inferenceSpecification()));
        case "ValidationSpecification":
            return Optional.ofNullable(clazz.cast(validationSpecification()));
        case "AlgorithmStatus":
            return Optional.ofNullable(clazz.cast(algorithmStatusAsString()));
        case "AlgorithmStatusDetails":
            return Optional.ofNullable(clazz.cast(algorithmStatusDetails()));
        case "ProductId":
            return Optional.ofNullable(clazz.cast(productId()));
        case "CertifyForMarketplace":
            return Optional.ofNullable(clazz.cast(certifyForMarketplace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAlgorithmResponse, T> g) {
        return obj -> g.apply((DescribeAlgorithmResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAlgorithmResponse> {
        /**
         * <p>
         * The name of the algorithm being described.
         * </p>
         * 
         * @param algorithmName
         *        The name of the algorithm being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithmName(String algorithmName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the algorithm.
         * </p>
         * 
         * @param algorithmArn
         *        The Amazon Resource Name (ARN) of the algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithmArn(String algorithmArn);

        /**
         * <p>
         * A brief summary about the algorithm.
         * </p>
         * 
         * @param algorithmDescription
         *        A brief summary about the algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithmDescription(String algorithmDescription);

        /**
         * <p>
         * A timestamp specifying when the algorithm was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp specifying when the algorithm was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Details about training jobs run by this algorithm.
         * </p>
         * 
         * @param trainingSpecification
         *        Details about training jobs run by this algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingSpecification(TrainingSpecification trainingSpecification);

        /**
         * <p>
         * Details about training jobs run by this algorithm.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrainingSpecification.Builder} avoiding
         * the need to create one manually via {@link TrainingSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrainingSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #trainingSpecification(TrainingSpecification)}.
         * 
         * @param trainingSpecification
         *        a consumer that will call methods on {@link TrainingSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingSpecification(TrainingSpecification)
         */
        default Builder trainingSpecification(Consumer<TrainingSpecification.Builder> trainingSpecification) {
            return trainingSpecification(TrainingSpecification.builder().applyMutation(trainingSpecification).build());
        }

        /**
         * <p>
         * Details about inference jobs that the algorithm runs.
         * </p>
         * 
         * @param inferenceSpecification
         *        Details about inference jobs that the algorithm runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceSpecification(InferenceSpecification inferenceSpecification);

        /**
         * <p>
         * Details about inference jobs that the algorithm runs.
         * </p>
         * This is a convenience method that creates an instance of the {@link InferenceSpecification.Builder} avoiding
         * the need to create one manually via {@link InferenceSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link InferenceSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #inferenceSpecification(InferenceSpecification)}.
         * 
         * @param inferenceSpecification
         *        a consumer that will call methods on {@link InferenceSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceSpecification(InferenceSpecification)
         */
        default Builder inferenceSpecification(Consumer<InferenceSpecification.Builder> inferenceSpecification) {
            return inferenceSpecification(InferenceSpecification.builder().applyMutation(inferenceSpecification).build());
        }

        /**
         * <p>
         * Details about configurations for one or more training jobs that Amazon SageMaker runs to test the algorithm.
         * </p>
         * 
         * @param validationSpecification
         *        Details about configurations for one or more training jobs that Amazon SageMaker runs to test the
         *        algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationSpecification(AlgorithmValidationSpecification validationSpecification);

        /**
         * <p>
         * Details about configurations for one or more training jobs that Amazon SageMaker runs to test the algorithm.
         * </p>
         * This is a convenience method that creates an instance of the {@link AlgorithmValidationSpecification.Builder}
         * avoiding the need to create one manually via {@link AlgorithmValidationSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link AlgorithmValidationSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #validationSpecification(AlgorithmValidationSpecification)}.
         * 
         * @param validationSpecification
         *        a consumer that will call methods on {@link AlgorithmValidationSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationSpecification(AlgorithmValidationSpecification)
         */
        default Builder validationSpecification(Consumer<AlgorithmValidationSpecification.Builder> validationSpecification) {
            return validationSpecification(AlgorithmValidationSpecification.builder().applyMutation(validationSpecification)
                    .build());
        }

        /**
         * <p>
         * The current status of the algorithm.
         * </p>
         * 
         * @param algorithmStatus
         *        The current status of the algorithm.
         * @see AlgorithmStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlgorithmStatus
         */
        Builder algorithmStatus(String algorithmStatus);

        /**
         * <p>
         * The current status of the algorithm.
         * </p>
         * 
         * @param algorithmStatus
         *        The current status of the algorithm.
         * @see AlgorithmStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlgorithmStatus
         */
        Builder algorithmStatus(AlgorithmStatus algorithmStatus);

        /**
         * <p>
         * Details about the current status of the algorithm.
         * </p>
         * 
         * @param algorithmStatusDetails
         *        Details about the current status of the algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithmStatusDetails(AlgorithmStatusDetails algorithmStatusDetails);

        /**
         * <p>
         * Details about the current status of the algorithm.
         * </p>
         * This is a convenience method that creates an instance of the {@link AlgorithmStatusDetails.Builder} avoiding
         * the need to create one manually via {@link AlgorithmStatusDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AlgorithmStatusDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #algorithmStatusDetails(AlgorithmStatusDetails)}.
         * 
         * @param algorithmStatusDetails
         *        a consumer that will call methods on {@link AlgorithmStatusDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #algorithmStatusDetails(AlgorithmStatusDetails)
         */
        default Builder algorithmStatusDetails(Consumer<AlgorithmStatusDetails.Builder> algorithmStatusDetails) {
            return algorithmStatusDetails(AlgorithmStatusDetails.builder().applyMutation(algorithmStatusDetails).build());
        }

        /**
         * <p>
         * The product identifier of the algorithm.
         * </p>
         * 
         * @param productId
         *        The product identifier of the algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productId(String productId);

        /**
         * <p>
         * Whether the algorithm is certified to be listed in Amazon Web Services Marketplace.
         * </p>
         * 
         * @param certifyForMarketplace
         *        Whether the algorithm is certified to be listed in Amazon Web Services Marketplace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certifyForMarketplace(Boolean certifyForMarketplace);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String algorithmName;

        private String algorithmArn;

        private String algorithmDescription;

        private Instant creationTime;

        private TrainingSpecification trainingSpecification;

        private InferenceSpecification inferenceSpecification;

        private AlgorithmValidationSpecification validationSpecification;

        private String algorithmStatus;

        private AlgorithmStatusDetails algorithmStatusDetails;

        private String productId;

        private Boolean certifyForMarketplace;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlgorithmResponse model) {
            super(model);
            algorithmName(model.algorithmName);
            algorithmArn(model.algorithmArn);
            algorithmDescription(model.algorithmDescription);
            creationTime(model.creationTime);
            trainingSpecification(model.trainingSpecification);
            inferenceSpecification(model.inferenceSpecification);
            validationSpecification(model.validationSpecification);
            algorithmStatus(model.algorithmStatus);
            algorithmStatusDetails(model.algorithmStatusDetails);
            productId(model.productId);
            certifyForMarketplace(model.certifyForMarketplace);
        }

        public final String getAlgorithmName() {
            return algorithmName;
        }

        public final void setAlgorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
        }

        @Override
        public final Builder algorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
            return this;
        }

        public final String getAlgorithmArn() {
            return algorithmArn;
        }

        public final void setAlgorithmArn(String algorithmArn) {
            this.algorithmArn = algorithmArn;
        }

        @Override
        public final Builder algorithmArn(String algorithmArn) {
            this.algorithmArn = algorithmArn;
            return this;
        }

        public final String getAlgorithmDescription() {
            return algorithmDescription;
        }

        public final void setAlgorithmDescription(String algorithmDescription) {
            this.algorithmDescription = algorithmDescription;
        }

        @Override
        public final Builder algorithmDescription(String algorithmDescription) {
            this.algorithmDescription = algorithmDescription;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final TrainingSpecification.Builder getTrainingSpecification() {
            return trainingSpecification != null ? trainingSpecification.toBuilder() : null;
        }

        public final void setTrainingSpecification(TrainingSpecification.BuilderImpl trainingSpecification) {
            this.trainingSpecification = trainingSpecification != null ? trainingSpecification.build() : null;
        }

        @Override
        public final Builder trainingSpecification(TrainingSpecification trainingSpecification) {
            this.trainingSpecification = trainingSpecification;
            return this;
        }

        public final InferenceSpecification.Builder getInferenceSpecification() {
            return inferenceSpecification != null ? inferenceSpecification.toBuilder() : null;
        }

        public final void setInferenceSpecification(InferenceSpecification.BuilderImpl inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification != null ? inferenceSpecification.build() : null;
        }

        @Override
        public final Builder inferenceSpecification(InferenceSpecification inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification;
            return this;
        }

        public final AlgorithmValidationSpecification.Builder getValidationSpecification() {
            return validationSpecification != null ? validationSpecification.toBuilder() : null;
        }

        public final void setValidationSpecification(AlgorithmValidationSpecification.BuilderImpl validationSpecification) {
            this.validationSpecification = validationSpecification != null ? validationSpecification.build() : null;
        }

        @Override
        public final Builder validationSpecification(AlgorithmValidationSpecification validationSpecification) {
            this.validationSpecification = validationSpecification;
            return this;
        }

        public final String getAlgorithmStatus() {
            return algorithmStatus;
        }

        public final void setAlgorithmStatus(String algorithmStatus) {
            this.algorithmStatus = algorithmStatus;
        }

        @Override
        public final Builder algorithmStatus(String algorithmStatus) {
            this.algorithmStatus = algorithmStatus;
            return this;
        }

        @Override
        public final Builder algorithmStatus(AlgorithmStatus algorithmStatus) {
            this.algorithmStatus(algorithmStatus == null ? null : algorithmStatus.toString());
            return this;
        }

        public final AlgorithmStatusDetails.Builder getAlgorithmStatusDetails() {
            return algorithmStatusDetails != null ? algorithmStatusDetails.toBuilder() : null;
        }

        public final void setAlgorithmStatusDetails(AlgorithmStatusDetails.BuilderImpl algorithmStatusDetails) {
            this.algorithmStatusDetails = algorithmStatusDetails != null ? algorithmStatusDetails.build() : null;
        }

        @Override
        public final Builder algorithmStatusDetails(AlgorithmStatusDetails algorithmStatusDetails) {
            this.algorithmStatusDetails = algorithmStatusDetails;
            return this;
        }

        public final String getProductId() {
            return productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final Boolean getCertifyForMarketplace() {
            return certifyForMarketplace;
        }

        public final void setCertifyForMarketplace(Boolean certifyForMarketplace) {
            this.certifyForMarketplace = certifyForMarketplace;
        }

        @Override
        public final Builder certifyForMarketplace(Boolean certifyForMarketplace) {
            this.certifyForMarketplace = certifyForMarketplace;
            return this;
        }

        @Override
        public DescribeAlgorithmResponse build() {
            return new DescribeAlgorithmResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
