/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTrialComponentRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateTrialComponentRequest.Builder, UpdateTrialComponentRequest> {
    private static final SdkField<String> TRIAL_COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrialComponentName").getter(getter(UpdateTrialComponentRequest::trialComponentName))
            .setter(setter(Builder::trialComponentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentName").build())
            .build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(UpdateTrialComponentRequest::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<TrialComponentStatus> STATUS_FIELD = SdkField
            .<TrialComponentStatus> builder(MarshallingType.SDK_POJO).memberName("Status")
            .getter(getter(UpdateTrialComponentRequest::status)).setter(setter(Builder::status))
            .constructor(TrialComponentStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(UpdateTrialComponentRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(UpdateTrialComponentRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Map<String, TrialComponentParameterValue>> PARAMETERS_FIELD = SdkField
            .<Map<String, TrialComponentParameterValue>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(UpdateTrialComponentRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<TrialComponentParameterValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrialComponentParameterValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> PARAMETERS_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ParametersToRemove")
            .getter(getter(UpdateTrialComponentRequest::parametersToRemove))
            .setter(setter(Builder::parametersToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParametersToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, TrialComponentArtifact>> INPUT_ARTIFACTS_FIELD = SdkField
            .<Map<String, TrialComponentArtifact>> builder(MarshallingType.MAP)
            .memberName("InputArtifacts")
            .getter(getter(UpdateTrialComponentRequest::inputArtifacts))
            .setter(setter(Builder::inputArtifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputArtifacts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<TrialComponentArtifact> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrialComponentArtifact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> INPUT_ARTIFACTS_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InputArtifactsToRemove")
            .getter(getter(UpdateTrialComponentRequest::inputArtifactsToRemove))
            .setter(setter(Builder::inputArtifactsToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputArtifactsToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, TrialComponentArtifact>> OUTPUT_ARTIFACTS_FIELD = SdkField
            .<Map<String, TrialComponentArtifact>> builder(MarshallingType.MAP)
            .memberName("OutputArtifacts")
            .getter(getter(UpdateTrialComponentRequest::outputArtifacts))
            .setter(setter(Builder::outputArtifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputArtifacts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<TrialComponentArtifact> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrialComponentArtifact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> OUTPUT_ARTIFACTS_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OutputArtifactsToRemove")
            .getter(getter(UpdateTrialComponentRequest::outputArtifactsToRemove))
            .setter(setter(Builder::outputArtifactsToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputArtifactsToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIAL_COMPONENT_NAME_FIELD,
            DISPLAY_NAME_FIELD, STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD, PARAMETERS_FIELD, PARAMETERS_TO_REMOVE_FIELD,
            INPUT_ARTIFACTS_FIELD, INPUT_ARTIFACTS_TO_REMOVE_FIELD, OUTPUT_ARTIFACTS_FIELD, OUTPUT_ARTIFACTS_TO_REMOVE_FIELD));

    private final String trialComponentName;

    private final String displayName;

    private final TrialComponentStatus status;

    private final Instant startTime;

    private final Instant endTime;

    private final Map<String, TrialComponentParameterValue> parameters;

    private final List<String> parametersToRemove;

    private final Map<String, TrialComponentArtifact> inputArtifacts;

    private final List<String> inputArtifactsToRemove;

    private final Map<String, TrialComponentArtifact> outputArtifacts;

    private final List<String> outputArtifactsToRemove;

    private UpdateTrialComponentRequest(BuilderImpl builder) {
        super(builder);
        this.trialComponentName = builder.trialComponentName;
        this.displayName = builder.displayName;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.parameters = builder.parameters;
        this.parametersToRemove = builder.parametersToRemove;
        this.inputArtifacts = builder.inputArtifacts;
        this.inputArtifactsToRemove = builder.inputArtifactsToRemove;
        this.outputArtifacts = builder.outputArtifacts;
        this.outputArtifactsToRemove = builder.outputArtifactsToRemove;
    }

    /**
     * <p>
     * The name of the component to update.
     * </p>
     * 
     * @return The name of the component to update.
     */
    public final String trialComponentName() {
        return trialComponentName;
    }

    /**
     * <p>
     * The name of the component as displayed. The name doesn't need to be unique. If <code>DisplayName</code> isn't
     * specified, <code>TrialComponentName</code> is displayed.
     * </p>
     * 
     * @return The name of the component as displayed. The name doesn't need to be unique. If <code>DisplayName</code>
     *         isn't specified, <code>TrialComponentName</code> is displayed.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The new status of the component.
     * </p>
     * 
     * @return The new status of the component.
     */
    public final TrialComponentStatus status() {
        return status;
    }

    /**
     * <p>
     * When the component started.
     * </p>
     * 
     * @return When the component started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * When the component ended.
     * </p>
     * 
     * @return When the component ended.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Replaces all of the component's hyperparameters with the specified hyperparameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return Replaces all of the component's hyperparameters with the specified hyperparameters.
     */
    public final Map<String, TrialComponentParameterValue> parameters() {
        return parameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParametersToRemove property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasParametersToRemove() {
        return parametersToRemove != null && !(parametersToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The hyperparameters to remove from the component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParametersToRemove} method.
     * </p>
     * 
     * @return The hyperparameters to remove from the component.
     */
    public final List<String> parametersToRemove() {
        return parametersToRemove;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputArtifacts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputArtifacts() {
        return inputArtifacts != null && !(inputArtifacts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Replaces all of the component's input artifacts with the specified artifacts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputArtifacts} method.
     * </p>
     * 
     * @return Replaces all of the component's input artifacts with the specified artifacts.
     */
    public final Map<String, TrialComponentArtifact> inputArtifacts() {
        return inputArtifacts;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputArtifactsToRemove property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInputArtifactsToRemove() {
        return inputArtifactsToRemove != null && !(inputArtifactsToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The input artifacts to remove from the component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputArtifactsToRemove} method.
     * </p>
     * 
     * @return The input artifacts to remove from the component.
     */
    public final List<String> inputArtifactsToRemove() {
        return inputArtifactsToRemove;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputArtifacts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputArtifacts() {
        return outputArtifacts != null && !(outputArtifacts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Replaces all of the component's output artifacts with the specified artifacts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputArtifacts} method.
     * </p>
     * 
     * @return Replaces all of the component's output artifacts with the specified artifacts.
     */
    public final Map<String, TrialComponentArtifact> outputArtifacts() {
        return outputArtifacts;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputArtifactsToRemove property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOutputArtifactsToRemove() {
        return outputArtifactsToRemove != null && !(outputArtifactsToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The output artifacts to remove from the component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputArtifactsToRemove} method.
     * </p>
     * 
     * @return The output artifacts to remove from the component.
     */
    public final List<String> outputArtifactsToRemove() {
        return outputArtifactsToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trialComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasParametersToRemove() ? parametersToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInputArtifacts() ? inputArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInputArtifactsToRemove() ? inputArtifactsToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputArtifacts() ? outputArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputArtifactsToRemove() ? outputArtifactsToRemove() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrialComponentRequest)) {
            return false;
        }
        UpdateTrialComponentRequest other = (UpdateTrialComponentRequest) obj;
        return Objects.equals(trialComponentName(), other.trialComponentName())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(status(), other.status())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && hasParametersToRemove() == other.hasParametersToRemove()
                && Objects.equals(parametersToRemove(), other.parametersToRemove())
                && hasInputArtifacts() == other.hasInputArtifacts() && Objects.equals(inputArtifacts(), other.inputArtifacts())
                && hasInputArtifactsToRemove() == other.hasInputArtifactsToRemove()
                && Objects.equals(inputArtifactsToRemove(), other.inputArtifactsToRemove())
                && hasOutputArtifacts() == other.hasOutputArtifacts()
                && Objects.equals(outputArtifacts(), other.outputArtifacts())
                && hasOutputArtifactsToRemove() == other.hasOutputArtifactsToRemove()
                && Objects.equals(outputArtifactsToRemove(), other.outputArtifactsToRemove());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTrialComponentRequest").add("TrialComponentName", trialComponentName())
                .add("DisplayName", displayName()).add("Status", status()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("Parameters", hasParameters() ? parameters() : null)
                .add("ParametersToRemove", hasParametersToRemove() ? parametersToRemove() : null)
                .add("InputArtifacts", hasInputArtifacts() ? inputArtifacts() : null)
                .add("InputArtifactsToRemove", hasInputArtifactsToRemove() ? inputArtifactsToRemove() : null)
                .add("OutputArtifacts", hasOutputArtifacts() ? outputArtifacts() : null)
                .add("OutputArtifactsToRemove", hasOutputArtifactsToRemove() ? outputArtifactsToRemove() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrialComponentName":
            return Optional.ofNullable(clazz.cast(trialComponentName()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "ParametersToRemove":
            return Optional.ofNullable(clazz.cast(parametersToRemove()));
        case "InputArtifacts":
            return Optional.ofNullable(clazz.cast(inputArtifacts()));
        case "InputArtifactsToRemove":
            return Optional.ofNullable(clazz.cast(inputArtifactsToRemove()));
        case "OutputArtifacts":
            return Optional.ofNullable(clazz.cast(outputArtifacts()));
        case "OutputArtifactsToRemove":
            return Optional.ofNullable(clazz.cast(outputArtifactsToRemove()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTrialComponentRequest, T> g) {
        return obj -> g.apply((UpdateTrialComponentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTrialComponentRequest> {
        /**
         * <p>
         * The name of the component to update.
         * </p>
         * 
         * @param trialComponentName
         *        The name of the component to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialComponentName(String trialComponentName);

        /**
         * <p>
         * The name of the component as displayed. The name doesn't need to be unique. If <code>DisplayName</code> isn't
         * specified, <code>TrialComponentName</code> is displayed.
         * </p>
         * 
         * @param displayName
         *        The name of the component as displayed. The name doesn't need to be unique. If
         *        <code>DisplayName</code> isn't specified, <code>TrialComponentName</code> is displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The new status of the component.
         * </p>
         * 
         * @param status
         *        The new status of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(TrialComponentStatus status);

        /**
         * <p>
         * The new status of the component.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrialComponentStatus.Builder} avoiding
         * the need to create one manually via {@link TrialComponentStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrialComponentStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #status(TrialComponentStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link TrialComponentStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(TrialComponentStatus)
         */
        default Builder status(Consumer<TrialComponentStatus.Builder> status) {
            return status(TrialComponentStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * When the component started.
         * </p>
         * 
         * @param startTime
         *        When the component started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * When the component ended.
         * </p>
         * 
         * @param endTime
         *        When the component ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Replaces all of the component's hyperparameters with the specified hyperparameters.
         * </p>
         * 
         * @param parameters
         *        Replaces all of the component's hyperparameters with the specified hyperparameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, TrialComponentParameterValue> parameters);

        /**
         * <p>
         * The hyperparameters to remove from the component.
         * </p>
         * 
         * @param parametersToRemove
         *        The hyperparameters to remove from the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parametersToRemove(Collection<String> parametersToRemove);

        /**
         * <p>
         * The hyperparameters to remove from the component.
         * </p>
         * 
         * @param parametersToRemove
         *        The hyperparameters to remove from the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parametersToRemove(String... parametersToRemove);

        /**
         * <p>
         * Replaces all of the component's input artifacts with the specified artifacts.
         * </p>
         * 
         * @param inputArtifacts
         *        Replaces all of the component's input artifacts with the specified artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputArtifacts(Map<String, TrialComponentArtifact> inputArtifacts);

        /**
         * <p>
         * The input artifacts to remove from the component.
         * </p>
         * 
         * @param inputArtifactsToRemove
         *        The input artifacts to remove from the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputArtifactsToRemove(Collection<String> inputArtifactsToRemove);

        /**
         * <p>
         * The input artifacts to remove from the component.
         * </p>
         * 
         * @param inputArtifactsToRemove
         *        The input artifacts to remove from the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputArtifactsToRemove(String... inputArtifactsToRemove);

        /**
         * <p>
         * Replaces all of the component's output artifacts with the specified artifacts.
         * </p>
         * 
         * @param outputArtifacts
         *        Replaces all of the component's output artifacts with the specified artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputArtifacts(Map<String, TrialComponentArtifact> outputArtifacts);

        /**
         * <p>
         * The output artifacts to remove from the component.
         * </p>
         * 
         * @param outputArtifactsToRemove
         *        The output artifacts to remove from the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputArtifactsToRemove(Collection<String> outputArtifactsToRemove);

        /**
         * <p>
         * The output artifacts to remove from the component.
         * </p>
         * 
         * @param outputArtifactsToRemove
         *        The output artifacts to remove from the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputArtifactsToRemove(String... outputArtifactsToRemove);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String trialComponentName;

        private String displayName;

        private TrialComponentStatus status;

        private Instant startTime;

        private Instant endTime;

        private Map<String, TrialComponentParameterValue> parameters = DefaultSdkAutoConstructMap.getInstance();

        private List<String> parametersToRemove = DefaultSdkAutoConstructList.getInstance();

        private Map<String, TrialComponentArtifact> inputArtifacts = DefaultSdkAutoConstructMap.getInstance();

        private List<String> inputArtifactsToRemove = DefaultSdkAutoConstructList.getInstance();

        private Map<String, TrialComponentArtifact> outputArtifacts = DefaultSdkAutoConstructMap.getInstance();

        private List<String> outputArtifactsToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrialComponentRequest model) {
            super(model);
            trialComponentName(model.trialComponentName);
            displayName(model.displayName);
            status(model.status);
            startTime(model.startTime);
            endTime(model.endTime);
            parameters(model.parameters);
            parametersToRemove(model.parametersToRemove);
            inputArtifacts(model.inputArtifacts);
            inputArtifactsToRemove(model.inputArtifactsToRemove);
            outputArtifacts(model.outputArtifacts);
            outputArtifactsToRemove(model.outputArtifactsToRemove);
        }

        public final String getTrialComponentName() {
            return trialComponentName;
        }

        public final void setTrialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
        }

        @Override
        public final Builder trialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final TrialComponentStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(TrialComponentStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(TrialComponentStatus status) {
            this.status = status;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Map<String, TrialComponentParameterValue.Builder> getParameters() {
            Map<String, TrialComponentParameterValue.Builder> result = TrialComponentParametersCopier
                    .copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, TrialComponentParameterValue.BuilderImpl> parameters) {
            this.parameters = TrialComponentParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, TrialComponentParameterValue> parameters) {
            this.parameters = TrialComponentParametersCopier.copy(parameters);
            return this;
        }

        public final Collection<String> getParametersToRemove() {
            if (parametersToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return parametersToRemove;
        }

        public final void setParametersToRemove(Collection<String> parametersToRemove) {
            this.parametersToRemove = ListTrialComponentKey256Copier.copy(parametersToRemove);
        }

        @Override
        public final Builder parametersToRemove(Collection<String> parametersToRemove) {
            this.parametersToRemove = ListTrialComponentKey256Copier.copy(parametersToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parametersToRemove(String... parametersToRemove) {
            parametersToRemove(Arrays.asList(parametersToRemove));
            return this;
        }

        public final Map<String, TrialComponentArtifact.Builder> getInputArtifacts() {
            Map<String, TrialComponentArtifact.Builder> result = TrialComponentArtifactsCopier.copyToBuilder(this.inputArtifacts);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setInputArtifacts(Map<String, TrialComponentArtifact.BuilderImpl> inputArtifacts) {
            this.inputArtifacts = TrialComponentArtifactsCopier.copyFromBuilder(inputArtifacts);
        }

        @Override
        public final Builder inputArtifacts(Map<String, TrialComponentArtifact> inputArtifacts) {
            this.inputArtifacts = TrialComponentArtifactsCopier.copy(inputArtifacts);
            return this;
        }

        public final Collection<String> getInputArtifactsToRemove() {
            if (inputArtifactsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return inputArtifactsToRemove;
        }

        public final void setInputArtifactsToRemove(Collection<String> inputArtifactsToRemove) {
            this.inputArtifactsToRemove = ListTrialComponentKey256Copier.copy(inputArtifactsToRemove);
        }

        @Override
        public final Builder inputArtifactsToRemove(Collection<String> inputArtifactsToRemove) {
            this.inputArtifactsToRemove = ListTrialComponentKey256Copier.copy(inputArtifactsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputArtifactsToRemove(String... inputArtifactsToRemove) {
            inputArtifactsToRemove(Arrays.asList(inputArtifactsToRemove));
            return this;
        }

        public final Map<String, TrialComponentArtifact.Builder> getOutputArtifacts() {
            Map<String, TrialComponentArtifact.Builder> result = TrialComponentArtifactsCopier
                    .copyToBuilder(this.outputArtifacts);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setOutputArtifacts(Map<String, TrialComponentArtifact.BuilderImpl> outputArtifacts) {
            this.outputArtifacts = TrialComponentArtifactsCopier.copyFromBuilder(outputArtifacts);
        }

        @Override
        public final Builder outputArtifacts(Map<String, TrialComponentArtifact> outputArtifacts) {
            this.outputArtifacts = TrialComponentArtifactsCopier.copy(outputArtifacts);
            return this;
        }

        public final Collection<String> getOutputArtifactsToRemove() {
            if (outputArtifactsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return outputArtifactsToRemove;
        }

        public final void setOutputArtifactsToRemove(Collection<String> outputArtifactsToRemove) {
            this.outputArtifactsToRemove = ListTrialComponentKey256Copier.copy(outputArtifactsToRemove);
        }

        @Override
        public final Builder outputArtifactsToRemove(Collection<String> outputArtifactsToRemove) {
            this.outputArtifactsToRemove = ListTrialComponentKey256Copier.copy(outputArtifactsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputArtifactsToRemove(String... outputArtifactsToRemove) {
            outputArtifactsToRemove(Arrays.asList(outputArtifactsToRemove));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTrialComponentRequest build() {
            return new UpdateTrialComponentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
