/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Attributes of the data specified by the customer. Use these to describe the data to be labeled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LabelingJobDataAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<LabelingJobDataAttributes.Builder, LabelingJobDataAttributes> {
    private static final SdkField<List<String>> CONTENT_CLASSIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ContentClassifiers")
            .getter(getter(LabelingJobDataAttributes::contentClassifiersAsStrings))
            .setter(setter(Builder::contentClassifiersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentClassifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_CLASSIFIERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> contentClassifiers;

    private LabelingJobDataAttributes(BuilderImpl builder) {
        this.contentClassifiers = builder.contentClassifiers;
    }

    /**
     * <p>
     * Declares that your content is free of personally identifiable information or adult content. Amazon SageMaker may
     * restrict the Amazon Mechanical Turk workers that can view your task based on this information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContentClassifiers} method.
     * </p>
     * 
     * @return Declares that your content is free of personally identifiable information or adult content. Amazon
     *         SageMaker may restrict the Amazon Mechanical Turk workers that can view your task based on this
     *         information.
     */
    public final List<ContentClassifier> contentClassifiers() {
        return ContentClassifiersCopier.copyStringToEnum(contentClassifiers);
    }

    /**
     * For responses, this returns true if the service returned a value for the ContentClassifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContentClassifiers() {
        return contentClassifiers != null && !(contentClassifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Declares that your content is free of personally identifiable information or adult content. Amazon SageMaker may
     * restrict the Amazon Mechanical Turk workers that can view your task based on this information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContentClassifiers} method.
     * </p>
     * 
     * @return Declares that your content is free of personally identifiable information or adult content. Amazon
     *         SageMaker may restrict the Amazon Mechanical Turk workers that can view your task based on this
     *         information.
     */
    public final List<String> contentClassifiersAsStrings() {
        return contentClassifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasContentClassifiers() ? contentClassifiersAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelingJobDataAttributes)) {
            return false;
        }
        LabelingJobDataAttributes other = (LabelingJobDataAttributes) obj;
        return hasContentClassifiers() == other.hasContentClassifiers()
                && Objects.equals(contentClassifiersAsStrings(), other.contentClassifiersAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LabelingJobDataAttributes")
                .add("ContentClassifiers", hasContentClassifiers() ? contentClassifiersAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContentClassifiers":
            return Optional.ofNullable(clazz.cast(contentClassifiersAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelingJobDataAttributes, T> g) {
        return obj -> g.apply((LabelingJobDataAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LabelingJobDataAttributes> {
        /**
         * <p>
         * Declares that your content is free of personally identifiable information or adult content. Amazon SageMaker
         * may restrict the Amazon Mechanical Turk workers that can view your task based on this information.
         * </p>
         * 
         * @param contentClassifiers
         *        Declares that your content is free of personally identifiable information or adult content. Amazon
         *        SageMaker may restrict the Amazon Mechanical Turk workers that can view your task based on this
         *        information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentClassifiersWithStrings(Collection<String> contentClassifiers);

        /**
         * <p>
         * Declares that your content is free of personally identifiable information or adult content. Amazon SageMaker
         * may restrict the Amazon Mechanical Turk workers that can view your task based on this information.
         * </p>
         * 
         * @param contentClassifiers
         *        Declares that your content is free of personally identifiable information or adult content. Amazon
         *        SageMaker may restrict the Amazon Mechanical Turk workers that can view your task based on this
         *        information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentClassifiersWithStrings(String... contentClassifiers);

        /**
         * <p>
         * Declares that your content is free of personally identifiable information or adult content. Amazon SageMaker
         * may restrict the Amazon Mechanical Turk workers that can view your task based on this information.
         * </p>
         * 
         * @param contentClassifiers
         *        Declares that your content is free of personally identifiable information or adult content. Amazon
         *        SageMaker may restrict the Amazon Mechanical Turk workers that can view your task based on this
         *        information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentClassifiers(Collection<ContentClassifier> contentClassifiers);

        /**
         * <p>
         * Declares that your content is free of personally identifiable information or adult content. Amazon SageMaker
         * may restrict the Amazon Mechanical Turk workers that can view your task based on this information.
         * </p>
         * 
         * @param contentClassifiers
         *        Declares that your content is free of personally identifiable information or adult content. Amazon
         *        SageMaker may restrict the Amazon Mechanical Turk workers that can view your task based on this
         *        information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentClassifiers(ContentClassifier... contentClassifiers);
    }

    static final class BuilderImpl implements Builder {
        private List<String> contentClassifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LabelingJobDataAttributes model) {
            contentClassifiersWithStrings(model.contentClassifiers);
        }

        public final Collection<String> getContentClassifiers() {
            if (contentClassifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return contentClassifiers;
        }

        public final void setContentClassifiers(Collection<String> contentClassifiers) {
            this.contentClassifiers = ContentClassifiersCopier.copy(contentClassifiers);
        }

        @Override
        public final Builder contentClassifiersWithStrings(Collection<String> contentClassifiers) {
            this.contentClassifiers = ContentClassifiersCopier.copy(contentClassifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentClassifiersWithStrings(String... contentClassifiers) {
            contentClassifiersWithStrings(Arrays.asList(contentClassifiers));
            return this;
        }

        @Override
        public final Builder contentClassifiers(Collection<ContentClassifier> contentClassifiers) {
            this.contentClassifiers = ContentClassifiersCopier.copyEnumToString(contentClassifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentClassifiers(ContentClassifier... contentClassifiers) {
            contentClassifiers(Arrays.asList(contentClassifiers));
            return this;
        }

        @Override
        public LabelingJobDataAttributes build() {
            return new LabelingJobDataAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
