/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.Parameter;

public class ListPipelineParametersForExecutionIterable
implements SdkIterable<ListPipelineParametersForExecutionResponse> {
    private final SageMakerClient client;
    private final ListPipelineParametersForExecutionRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPipelineParametersForExecutionIterable(SageMakerClient client, ListPipelineParametersForExecutionRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPipelineParametersForExecutionResponseFetcher();
    }

    public Iterator<ListPipelineParametersForExecutionResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Parameter> pipelineParameters() {
        Function<ListPipelineParametersForExecutionResponse, Iterator> getIterator = response -> {
            if (response != null && response.pipelineParameters() != null) {
                return response.pipelineParameters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPipelineParametersForExecutionResponseFetcher
    implements SyncPageFetcher<ListPipelineParametersForExecutionResponse> {
        private ListPipelineParametersForExecutionResponseFetcher() {
        }

        public boolean hasNextPage(ListPipelineParametersForExecutionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPipelineParametersForExecutionResponse nextPage(ListPipelineParametersForExecutionResponse previousPage) {
            if (previousPage == null) {
                return ListPipelineParametersForExecutionIterable.this.client.listPipelineParametersForExecution(ListPipelineParametersForExecutionIterable.this.firstRequest);
            }
            return ListPipelineParametersForExecutionIterable.this.client.listPipelineParametersForExecution((ListPipelineParametersForExecutionRequest)((Object)ListPipelineParametersForExecutionIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

